/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.console;

import javax.microedition.io.*;
import javax.wireless.messaging.*;
import malik.emulator.microedition.system.*;

public class MessageConsoleCommand extends ConsoleCommand
{
    public MessageConsoleCommand() {
        super(
            "смс",
            "Использование:\n смс <текст сообщения>\n смс <порт> <текст сообщения>\nВариант с одним аргументом посылает сообщение на порт 1200, то есть в консоль J2ME.\n" +
            "Вариант с двумя аргументами посылает сообщение на указанный порт.\nНомер порта – целое число от 0 до 65535.\n" +
            "Если приложение ожидает сообщение на заданный порт, то приложение получит текстовое сообщение."
        );
    }

    protected void execute(String[] arguments, Console console) {
        int len;
        String text;
        String address;
        if((len = arguments.length) >= 2)
        {
            address = "sms://:".concat(arguments[0]);
            text = arguments[1];
        }
        else if(len == 1)
        {
            address = "sms://:1200";
            text = arguments[0];
        }
        else
        {
            console.println("Команде «смс» требуется хотя бы один аргумент.");
            return;
        }
        try
        {
            MessageConnection connection = (MessageConnection) Connector.open("sms://");
            try
            {
                TextMessage message;
                (message = (TextMessage) connection.newMessage(MessageConnection.TEXT_MESSAGE, address)).setPayloadText(text);
                connection.send(message);
            }
            finally
            {
                connection.close();
            }
        }
        catch(Exception e)
        {
            e.printRealStackTrace();
        }
    }
}
