/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.protocol.sms;

import java.util.*;
import javax.wireless.messaging.*;

public abstract class ShortMessage extends Object implements Message
{
    public static final long EMPTY_TIMESTAMP = -1L << 63;

    private final boolean inbound;
    long timestamp;
    String senderAddress;
    String recipientAddress;
    final MessageConnection creator;

    public ShortMessage(MessageConnection creator, boolean inbound, String senderAddress, String recipientAddress, long timestamp) {
        this.inbound = inbound;
        this.timestamp = timestamp;
        this.senderAddress = senderAddress;
        this.recipientAddress = recipientAddress;
        this.creator = creator;
    }

    public abstract int getLength();

    public abstract ShortMessage createInboundCopy();

    public void setAddress(String address) {
        if(inbound)
        {
            senderAddress = address;
            return;
        }
        recipientAddress = address;
    }

    public String getAddress() {
        return inbound ? senderAddress : recipientAddress;
    }

    public Date getTimestamp() {
        long timestamp;
        return (timestamp = this.timestamp) == EMPTY_TIMESTAMP ? null : new Date(timestamp);
    }

    public void setTimestampAsLong(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestampAsLong() {
        return timestamp;
    }

    public final boolean isInbound() {
        return inbound;
    }

    public final String getSenderAddress() {
        return senderAddress;
    }

    public final String getRecipientAddress() {
        return recipientAddress;
    }

    public final MessageConnection getCreator() {
        return creator;
    }
}
