/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.bluetooth;

import javax.microedition.io.*;
import malik.emulator.microedition.*;
import malik.emulator.microedition.system.user.*;

public class LocalDevice extends Object
{
    private static final LocalDevice instance;

    static {
        instance = DeviceManager.getInstance() instanceof UserSystemManager ? new LocalDevice() : null;
    }

    public static boolean isPowerOn() {
        return DeviceManager.getInstance() instanceof UserSystemManager;
    }

    public static LocalDevice getLocalDevice() throws BluetoothStateException {
        LocalDevice result;
        if((result = instance) == null)
        {
            throw new BluetoothStateException("LocalDevice.getLocalDevice: Bluetooth API не был реализован на этой платформе.");
        }
        return result;
    }

    public static String getProperty(String key) {
        if("bluetooth.api.version".equals(key)) return "1.1.1";
        if("bluetooth.master.switch".equals(key)) return "false";
        if("bluetooth.sd.attr.retrievable.max".equals(key)) return "1";
        if("bluetooth.connected.devices.max".equals(key)) return "7";
        if("bluetooth.l2cap.receiveMTU.max".equals(key)) return "512";
        if("bluetooth.sd.trans.max".equals(key)) return "1";
        if("bluetooth.connected.inquiry.scan".equals(key)) return "false";
        if("bluetooth.connected.page.scan".equals(key)) return "false";
        if("bluetooth.connected.inquiry".equals(key)) return "false";
        if("bluetooth.connected.page".equals(key)) return "false";
        return null;
    }

    private int discoverableMode;
    private final DiscoveryAgent agent;

    private LocalDevice() {
        this.discoverableMode = DiscoveryAgent.LIAC;
        this.agent = new DiscoveryAgent();
    }

    public void updateRecord(ServiceRecord record) throws ServiceRegistrationException {
        if(record == null)
        {
            throw new NullPointerException("LocalDevice.updateRecord: аргумент record равен нулевой ссылке.");
        }
        throw new IllegalArgumentException("LocalDevice.updateRecord: неправильная запись услуги.");
    }

    public boolean setDiscoverable(int mode) throws BluetoothStateException {
        DiscoveryAgent agent;
        if(mode != DiscoveryAgent.NOT_DISCOVERABLE && (mode < 0x9e8b00 || mode > 0x9e8b3f))
        {
            throw new IllegalArgumentException("LocalDevice.setDiscoverable: аргумент mode имеет недопустимое значение.");
        }
        if((agent = this.agent).inquiryOperation != null || agent.searchOperation != null)
        {
            throw new BluetoothStateException("LocalDevice.setDiscoverable: невозможно изменить режим обнаружения.");
        }
        if(mode == DiscoveryAgent.NOT_DISCOVERABLE || mode == DiscoveryAgent.GIAC || mode == DiscoveryAgent.LIAC)
        {
            this.discoverableMode = mode;
            return true;
        }
        return false;
    }

    public int getDiscoverable() {
        return discoverableMode;
    }

    public String getFriendlyName() {
        return null;
    }

    public String getBluetoothAddress() {
        return "050710DF0BAC";
    }

    public DeviceClass getDeviceClass() {
        return null;
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return agent;
    }

    public ServiceRecord getRecord(Connection notifier) {
        if(notifier == null)
        {
            throw new NullPointerException("LocalDevice.getRecord: аргумент notifier равен нулевой ссылке.");
        }
        throw new IllegalArgumentException("LocalDevice.getRecord: неправильное соединение.");
    }
}
