/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.util;

public class Stack extends Vector
{
	public Stack()
	{
	}

	public boolean empty()
	{
		return super.isEmpty();
	}

	public int search(Object item)
	{
		int result;
		int i;
		synchronized(getMonitor())
		{
			result = (i = lastIndexOf(item)) >= 0 ? elementCount - i : -1;
		}
		return result;
	}

	public Object push(Object item)
	{
		super.addElement(item);
		return item;
	}

	public Object pop()
	{
		int c;
		int error;
		Object[] d;
		Object result;
		error = 0;
		synchronized(getMonitor())
		{
			label0:
			{
				if((c = elementCount) <= 0)
				{
					error = 1;
					result = null;
					break label0;
				}
				result = (d = elementData)[--c];
				d[elementCount = c] = null;
			}
		}
		if(error == 1)
		{
			throw new EmptyStackException("Stack.pop: " +
					"стек не содержит элементов.");
		}
		return result;
	}

	public Object peek()
	{
		int c;
		int error;
		Object result;
		error = 0;
		synchronized(getMonitor())
		{
			label0:
			{
				if((c = elementCount) <= 0)
				{
					error = 1;
					result = null;
					break label0;
				}
				result = elementData[c - 1];
			}
		}
		if(error == 1)
		{
			throw new EmptyStackException("Stack.peek: " +
					"стек не содержит элементов.");
		}
		return result;
	}
}
