/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.time;

import java.util.*;

public class DefaultFormat extends Object
		implements DateTimeFormat
{
	private static final String[] DAYS;
	private static final String[] MONTHS;

	static
	{
		DAYS = new String[] {
				"воскресенье", "понедельник", "вторник", "среда", "четверг", "пятница", "суббота"
		};
		MONTHS = new String[] {
				"января", "февраля", "марта", "апреля", "мая", "июня",
				"июля", "августа", "сентября", "октября", "ноября", "декабря"
		};
	}

	public static char[] asTwoChars(int num)
	{
		if(num < 0 || num > 99)
		{
			throw new IllegalArgumentException("DefaultFormat.asTwoChars: " +
					"двузначная компонента может быть в диапазоне от 0 до 99.");
		}
		return new char[] {
				(char) ((num / 10) + '0'),
				(char) ((num % 10) + '0')
		};
	}

	public static char[] asThreeChars(int num)
	{
		if(num < 0 || num > 999)
		{
			throw new IllegalArgumentException("DefaultFormat.asThreeChars: " +
					"трёхзначная компонента может быть в диапазоне от 0 до 999.");
		}
		return new char[] {
				(char) ((num / 100) + '0'),
				(char) (((num % 100) / 10) + '0'),
				(char) ((num % 10) + '0')
		};
	}


	public DefaultFormat()
	{
	}

	public String represent(int era, int year, int month, int day, int weekday,
			int hour, int minute, int second, int millis, TimeZone zone)
	{
		return getWeekDayRepresentation(weekday) + ", " + day + ' ' +
				getMonthRepresentation(month) + ' ' + year +
				(era == 0 ? " до н.э., " : (era == 1 && year <= 1000 ? " н.э., " : ", ")) +
				String.valueOf(asTwoChars(hour)) + ':' +
				String.valueOf(asTwoChars(minute)) + ':' +
				String.valueOf(asTwoChars(second)) + ',' +
				String.valueOf(asThreeChars(millis)) + ' ' + (zone instanceof LocaleTimeZone ?
				((LocaleTimeZone) zone).toString(era, year, month, day, weekday,
				3600000 * hour + 60000 * minute + 1000 * second + millis) : zone.toString());
	}

	protected String getWeekDayRepresentation(int weekday)
	{
		return DAYS[weekday - 1];
	}

	protected String getMonthRepresentation(int month)
	{
		return MONTHS[month];
	}
}
