/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public class Spacer extends Item
{
	private int minWidth;
	private int minHeight;

	public Spacer(int minWidth, int minHeight)
	{
		this(LAYOUT_DEFAULT, minWidth, minHeight);
	}

	public Spacer(int layout, int minWidth, int minHeight)
	{
		super(layout, -1, -1, null, null, null, null);
		if(minWidth < 0 || minHeight < 0)
		{
			throw new IllegalArgumentException("Spacer: " +
					"минимальные размеры не могут быть отрицательными.");
		}
		this.minWidth = minWidth;
		this.minHeight = minHeight;
	}

	public void addCommand(Command command)
	{
		throw new IllegalStateException("Spacer.addCommand: " +
				"добавление команд невозможно.");
	}

	public void setDefaultCommand(Command command)
	{
		throw new IllegalStateException("Spacer.setDefaultCommand: " +
				"изменение основной команды невозможно.");
	}

	public void setLabel(String label)
	{
		throw new IllegalStateException("Spacer.setLabel: " +
				"изменение метки элемента невозможно.");
	}

	public void setMinimumSize(int minWidth, int minHeight)
	{
		if(minWidth < 0 || minHeight < 0)
		{
			throw new IllegalArgumentException("Spacer.setMinimumSize: " +
					"минимальные размеры не могут быть отрицательными.");
		}
		this.minWidth = minWidth;
		this.minHeight = minHeight;
		notifyUpdate();
	}

	void paintContent(Graphics render, int contentWidth, int contentHeight)
	{
		/* На месте компонента Spacer должно быть пустое место. */
	}

	int getPreferredContentWidth(int contentHeight, int containerClientWidth)
	{
		return minWidth;
	}

	int getPreferredContentHeight(int contentWidth)
	{
		return minHeight;
	}
}
