/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.util;

import malik.emulator.util.*;

public abstract class TimeZone extends Object
{
    private static final TimeZoneCollection COLLECTION;

    static {
        TimeZoneCollection collection = null;
        try
        {
            collection = (TimeZoneCollection) Class.forName(System.getSystemProperty("malik.emulator.application.timezone.collection.class")).newInstance();
        }
        catch(Exception e)
        {
            e.printRealStackTrace();
        }
        COLLECTION = collection;
    }

    public static String[] getAvailableIDs() {
        return COLLECTION == null ? new String[] { "GMT" } : COLLECTION.getAvailableIDs();
    }

    public static TimeZone getDefault() {
        return COLLECTION == null ? new GMT() : COLLECTION.getDefault();
    }

    public static TimeZone getTimeZone(String id) {
        return COLLECTION == null ? new GMT() : COLLECTION.getTimeZone(id);
    }

    private String id;

    public TimeZone() {
    }

    public TimeZone(String id) {
        this.id = id;
    }

    public abstract boolean useDaylightTime();

    public abstract int getRawOffset();

    public abstract int getOffset(int era, int year, int month, int day, int weekday, int millis);

    public String getID() {
        return id;
    }
}

final class GMT extends TimeZone
{
    public GMT() {
        super("GMT");
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof GMT;
    }

    public boolean useDaylightTime() {
        return false;
    }

    public int hashCode() {
        return 0x00379f71;
    }

    public int getRawOffset() {
        return 0;
    }

    public int getOffset(int era, int year, int month, int day, int weekday, int millis) {
        if(era < 0 || era > 1)
        {
            throw new IllegalArgumentException("TimeZone.getOffset: аргумент era имеет недопустимое значение.");
        }
        if(year <= 0)
        {
            throw new IllegalArgumentException("TimeZone.getOffset: аргумент year может быть только положительным.");
        }
        if(++month < 1 || month > 12)
        {
            throw new IllegalArgumentException("TimeZone.getOffset: аргумент month имеет недопустимое значение.");
        }
        return 0;
    }

    public String toString() {
        return "GMT";
    }
}
