/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.fileformats;

import java.io.*;

public class ExtendedDataOutputStream extends DataOutputStream implements ExtendedDataOutput
{
    public ExtendedDataOutputStream(OutputStream stream) {
        super(stream);
    }

    public final void writeCharLE(int charData) throws IOException {
        OutputStream stream = out;
        stream.write(charData);
        stream.write(charData >> 8);
    }

    public final void writeFloatLE(float floatData) throws IOException {
        writeIntLE(Float.floatToIntBits(floatData));
    }

    public final void writeDoubleLE(double doubleData) throws IOException {
        writeLongLE(Double.doubleToLongBits(doubleData));
    }

    public final void writeShortLE(int shortData) throws IOException {
        OutputStream stream = out;
        stream.write(shortData);
        stream.write(shortData >> 8);
    }

    public final void writeIntLE(int intData) throws IOException {
        OutputStream stream = out;
        stream.write(intData);
        stream.write(intData >> 0x08);
        stream.write(intData >> 0x10);
        stream.write(intData >> 0x18);
    }

    public final void writeLongLE(long longData) throws IOException {
        OutputStream stream = out;
        stream.write((int) longData);
        stream.write((int) (longData >> 0x08));
        stream.write((int) (longData >> 0x10));
        stream.write((int) (longData >> 0x18));
        stream.write((int) (longData >> 0x20));
        stream.write((int) (longData >> 0x28));
        stream.write((int) (longData >> 0x30));
        stream.write((int) (longData >> 0x38));
    }

    public final void writeCharsLE(String charsData) throws IOException {
        char[] c;
        OutputStream stream;
        if(charsData == null)
        {
            throw new NullPointerException("ExtendedDataOutputStream.writeCharsLE: аргумент charsData равен нулевой ссылке.");
        }
        stream = out;
        for(int len = (c = charsData.toCharArray()).length, i = 0; i < len; i++)
        {
            int charData = c[i];
            stream.write(charData);
            stream.write(charData >> 8);
        }
    }

    public final OutputStream getDestinationStream() {
        return out;
    }
}
