/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.media.sound;

public abstract class SoundPlayer extends Object
{
    public static final int MUTE = 0x00;
    public static final int MAX_VOLUME = 0x7f;
    public static final int FREED = 0;
    public static final int STARTED = 1;
    public static final int STOPPED = 2;

    protected SoundPlayerListener listener;

    protected SoundPlayer() {
    }

    public abstract int loadBlock(long[] abstractData, int offset, int length) throws SoundPlayerException;

    public abstract int reset() throws SoundPlayerException;

    public abstract int start() throws SoundPlayerException;

    public abstract int stop() throws SoundPlayerException;

    public abstract int setCurrentBlockPosition(int position) throws SoundPlayerException;

    public abstract int getState() throws SoundPlayerException;

    public abstract int getVolume() throws SoundPlayerException;

    public abstract int getCurrentBlockIndex() throws SoundPlayerException;

    public abstract int getCurrentBlockPosition() throws SoundPlayerException;

    public void close() {
    }

    public void setSoundPlayerListener(SoundPlayerListener listener) {
        this.listener = listener;
    }

    public int setVolume(int volume) throws SoundPlayerException {
        return volume < MUTE ? MUTE : volume > MAX_VOLUME ? MAX_VOLUME : volume;
    }

    public long getCurrentBlockIndexAndPosition() throws SoundPlayerException {
        return (long) getCurrentBlockIndex() << 32 | (long) getCurrentBlockPosition() & 0x00000000ffffffffL;
    }
}
