/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.media;

public interface Player extends Controllable
{
    public static final int CLOSED     =   0;
    public static final int UNREALIZED = 100;
    public static final int REALIZED   = 200;
    public static final int PREFETCHED = 300;
    public static final int STARTED    = 400;
    public static final long TIME_UNKNOWN = -1L;

    public void close();

    public void deallocate();

    public void realize() throws MediaException;

    public void prefetch() throws MediaException;

    public void start() throws MediaException;

    public void stop() throws MediaException;

    public void addPlayerListener(PlayerListener listener);

    public void removePlayerListener(PlayerListener listener);

    public void setLoopCount(int loopCount);

    public void setTimeBase(TimeBase master) throws MediaException;

    public int getState();

    public long setMediaTime(long mediaTime) throws MediaException;

    public long getMediaTime();

    public long getDuration();

    public TimeBase getTimeBase();

    public String getContentType();
}
