/*
    Zlib – библиотека сжатия данных общего назначения. Версия 1.1.0
    Это изменённая объектно-ориентированная версия библиотеки, полностью
    совместимая с оригинальной библиотекой.
    
    Copyright © 1995–2005 Jean-loup Gailly и Mark Adler
    Copyright © 2000–2011 ymnk, JCraft, Inc.
    Copyright © 2016–2017, 2019–2022 Малик Разработчик
    
    Эта библиотека поставляется «как есть», без каких-либо явных или
    подразумеваемых гарантий. Ни при каких обстоятельствах авторы не
    несут какой-либо ответственности в случае потери данных вследствие
    использования данной библиотеки.
    
    Разрешается всем использовать эту библиотеку для любых целей, в том
    числе и для коммерческих приложений, а также изменять её и
    распространять свободно при соблюдении следующих условий:
    
        1. Оригинал библиотеки не должен быть искажён; вы не должны
    заявлять, что именно вы написали оригинальную библиотеку. Если вы
    используете эту библиотеку в своём программном продукте, то ссылка
    на авторов библиотеки была бы желательна, но это не является
    обязательным требованием.
    
        2. Изменённые версии исходных текстов должны быть отчётливо
    маркированы и не должны выдаваться за оригинал библиотеки.
    
        3. Эти замечания не могут быть удалены либо изменены при
    каком-либо варианте распространения исходных текстов.
*/

package malik.emulator.compression.zlib;

public final class Deflater extends ZStream
{
    private boolean finished;

    public Deflater() {
    }

    public Deflater(int level) throws GZIPException {
        this(level, MAX_WBITS, false);
    }

    public Deflater(int level, boolean nowrap) throws GZIPException {
        this(level, MAX_WBITS, nowrap);
    }

    public Deflater(int level, int bits) throws GZIPException {
        this(level, bits, false);
    }

    public Deflater(int level, int bits, boolean nowrap) throws GZIPException {
        int ret;
        if((ret = init(level, bits, nowrap)) != OK)
        {
            throw new GZIPException(Integer.toString(ret) + ": " + message);
        }
    }

    public Deflater(int level, int bits, int memlevel) throws GZIPException {
        int ret;
        if((ret = init(level, bits, memlevel)) != OK)
        {
            throw new GZIPException(Integer.toString(ret) + ": " + message);
        }
    }

    public int deflate(int flush) {
        int ret;
        if(dstate == null) return STREAM_ERROR;
        ret = dstate.deflate(flush);
        if(ret == STREAM_END) finished = true;
        return ret;
    }

    public boolean finished() {
        return finished;
    }

    public int init(int level) {
        return init(level, MAX_WBITS);
    }

    public int init(int level, boolean nowrap) {
        return init(level, MAX_WBITS, nowrap);
    }

    public int init(int level, int bits) {
        return init(level, bits, false);
    }

    public int init(int level, int bits, boolean nowrap) {
        finished = false;
        return (dstate = new Deflate(this)).deflateInit(level, nowrap ? -bits : bits);
    }

    public int init(int level, int bits, int memlevel) {
        finished = false;
        return (dstate = new Deflate(this)).deflateInit(level, bits, memlevel);
    }

    public int params(int level, int strategy) {
        return dstate == null ? STREAM_ERROR : dstate.deflateParams(level, strategy);
    }

    public int setDictionary(byte[] dictionary, int dictLength) {
        return dstate == null ? STREAM_ERROR : dstate.deflateSetDictionary(dictionary, dictLength);
    }

    public int copy(Deflater src) {
        finished = src.finished;
        return Deflate.deflateCopy(this, src);
    }

    public int end() {
        int result;
        finished = true;
        if(dstate == null) return STREAM_ERROR;
        result = dstate.deflateEnd();
        dstate = null;
        free();
        return result;
    }
}
