/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.bluetooth;

import java.io.*;

public interface ServiceRecord
{
    public static final int NOAUTHENTICATE_NOENCRYPT = 0;
    public static final int AUTHENTICATE_NOENCRYPT   = 1;
    public static final int AUTHENTICATE_ENCRYPT     = 2;

    public void setDeviceServiceClasses(int classes);

    public boolean populateRecord(int[] attributeIDs) throws IOException;

    public boolean setAttributeValue(int attributeID, DataElement attributeValue);

    public int[] getAttributeIDs();

    public RemoteDevice getHostDevice();

    public DataElement getAttributeValue(int attributeID);

    public String getConnectionURL(int requiredSecurity, boolean requiredMaster);
}
