/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.game;

import com.sensiblemobiles.game.MainGameCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Bullet {
    private Image img;
    private int cordY;
    private int cordX;
    private Sprite sprite;
    private int diraction;
    private int flag = 0;
    private int buletSpeed;
    private int frameindex;

    public Bullet(int x, int y, int bs, int dir) {
        this.cordY = y;
        this.cordX = x;
        this.buletSpeed = bs;
        this.diraction = dir;
        this.loadImage();
        this.flag = MainGameCanvas.player.getXcord() + MainGameCanvas.player.getPlayerWidth() / 2 <= this.cordX ? 1 : 2;
    }

    private void loadImage() {
        try {
            this.img = Image.createImage((String)"/res/game/user-bullet.png");
            this.sprite = new Sprite(this.img, this.img.getWidth() / 2, this.img.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doPaint(Graphics g) {
        this.sprite.setRefPixelPosition(this.cordX, this.cordY);
        this.sprite.setFrame(this.frameindex);
        this.sprite.paint(g);
        this.frameindex = this.frameindex < 1 ? ++this.frameindex : 0;
        if (this.diraction == 1) {
            this.cordX += this.buletSpeed;
        } else if (this.diraction == 2) {
            if (this.flag == 1) {
                this.cordY -= this.buletSpeed;
                this.cordX -= this.buletSpeed;
            } else if (this.flag == 2) {
                this.cordY -= this.buletSpeed;
                this.cordX += this.buletSpeed;
            }
        } else if (this.diraction == 3) {
            this.cordX -= this.buletSpeed;
        } else if (this.diraction == 4) {
            this.cordX -= this.buletSpeed;
            this.cordY -= this.buletSpeed;
        } else if (this.diraction == 5) {
            this.cordX += this.buletSpeed;
            this.cordY -= this.buletSpeed;
        } else if (this.diraction == 6) {
            this.cordY -= this.buletSpeed;
        }
    }

    public int getXcor() {
        return this.cordX;
    }

    public int getYcor() {
        return this.cordY;
    }

    public int getHeight() {
        return this.sprite.getHeight();
    }

    public int getWidth() {
        return this.img.getWidth() / 2;
    }

    public void deleteSprite() {
        this.sprite = null;
    }

    public Sprite getSprite() {
        return this.sprite;
    }
}

