/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.Brick;
import javax.microedition.lcdui.Graphics;

abstract class Ball {
    public static final int DIAMETER = 4;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    protected int X;
    protected int Y;
    protected int newX;
    protected int newY;
    protected int dX;
    protected int dY;
    protected boolean isShown = false;

    public Ball() {
    }

    public Ball(Ball cloner) {
        this.set(cloner.newX, cloner.newY);
        this.setSpeed(-cloner.dX, -cloner.dY);
    }

    protected abstract void ballHide(Graphics var1);

    protected abstract void ballShow(Graphics var1);

    public abstract int hitBrick(int var1, Brick var2, Graphics var3);

    public final void set(int x, int y) {
        this.newX = x;
        this.newY = y;
    }

    public final void move() {
        this.newX += this.dX;
        this.newY += this.dY;
    }

    public final void move(int dx, int dy) {
        this.newX += dx;
        this.newY += dy;
    }

    public final void setSpeed(int dx, int dy) {
        this.dX = dx;
        this.dY = dy;
    }

    public final boolean goesDown() {
        return this.dY > 0;
    }

    public final int direction() {
        int res = 0;
        res |= this.dY > 0 ? 2 : 1;
        return res |= this.dX > 0 ? 8 : 4;
    }

    public final void hide(Graphics g) {
        if (this.isShown) {
            this.ballHide(g);
            this.isShown = false;
        }
    }

    protected final void show(Graphics g) {
        if (!this.isShown) {
            this.X = this.newX;
            this.Y = this.newY;
            this.ballShow(g);
            this.isShown = true;
        }
    }

    public final void paint(Graphics g) {
        this.hide(g);
        this.show(g);
    }

    public final int left() {
        return this.newX;
    }

    public final int right() {
        return this.newX + 4 - 1;
    }

    public final int top() {
        return this.newY;
    }

    public final int bottom() {
        return this.newY + 4 - 1;
    }

    public final void reflectHor(int limX) {
        this.newX = this.dX < 0 ? (this.newX += 2 * (limX - this.left()) + 1) : (this.newX -= 2 * (this.right() - limX) + 1);
        this.dX = -this.dX;
    }

    public final void reflectVer(int limY) {
        if (this.dY < 0) {
            this.newY += 2 * (limY - this.top()) + 1;
        } else {
            String s = Integer.toString(this.newY);
            this.newY -= 2 * (this.bottom() - limY) + 1;
        }
        this.dY = -this.dY;
    }

    static {
        DIAMETER = 4;
        UP = 1;
        DOWN = 2;
        LEFT = 4;
        RIGHT = 8;
    }
}

