/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.Ball;
import arkanoid.Brick;
import javax.microedition.lcdui.Graphics;

class BrickField {
    private static final byte[][] LEVELS = new byte[][]{{5, 5, 71, 87, 71, 87, 71, 71, 71, 71, 71, 71, 71, 71, 87, 71, 71, 66, 71, 71, 71, 66, 71, 32, 66, 32, 71}, {5, 8, 87, 87, 66, 87, 87, 87, 66, 87, 66, 87, 87, 87, 98, 66, 87, 87, 87, 66, 87, 87, 87, 66, 66, 66, 87, 87, 32, 98, 32, 87, 32, 32, 32, 32, 32, 83, 83, 103, 83, 83}, {5, 8, 71, 66, 66, 66, 71, 71, 71, 71, 66, 71, 71, 71, 66, 71, 71, 71, 71, 71, 66, 71, 71, 66, 66, 66, 71, 87, 32, 32, 32, 87, 32, 32, 83, 32, 32, 83, 83, 115, 83, 83}, {5, 7, 87, 71, 87, 71, 87, 87, 71, 87, 71, 87, 87, 71, 87, 71, 87, 87, 71, 112, 71, 87, 71, 71, 71, 71, 71, 66, 66, 66, 66, 66, 112, 98, 66, 98, 112}, {5, 1, 32, 32, 71, 32, 32}};
    private static int appWidth;
    private static int appHeight;
    private static int fieldWidth;
    private static int fieldHeight;
    private static int originX;
    private static int onField;
    private static int lastAct;
    private static Brick[][] bField;
    private static int[] lvlBitfield;
    private static final Brick[] reflBricks;
    private static final int[] reflDirs;

    public BrickField(int cwidth, int cheight) {
        appWidth = cwidth;
        appHeight = cheight;
        bField = new Brick[cwidth / 17][cheight / 5];
        lvlBitfield = new int[cheight / 5 + 2];
    }

    public final boolean load(int level) {
        int n = 2;
        onField = 0;
        lastAct = 0;
        if (level > LEVELS.length) {
            return false;
        }
        byte[] curLevel = LEVELS[level - 1];
        fieldWidth = curLevel[0];
        fieldHeight = curLevel[1];
        originX = (appWidth - 17 * fieldWidth) / 2;
        BrickField.lvlBitfield[0] = -1;
        int walls = Integer.MIN_VALUE | 1 << 30 - fieldWidth;
        int i = 1;
        while (i < lvlBitfield.length - 1) {
            BrickField.lvlBitfield[i] = walls;
            ++i;
        }
        BrickField.lvlBitfield[BrickField.lvlBitfield.length - 1] = -1;
        int y = 0;
        while (y < fieldHeight) {
            int x = 0;
            while (x < fieldWidth) {
                Brick curBr;
                byte br_type = curLevel[n++];
                BrickField.bField[x][y] = curBr = Brick.getTyped((char)br_type, originX + x * 17, y * 5);
                if (curBr != null) {
                    this.addBrick(x, y);
                    if (curBr.destroyable()) {
                        ++onField;
                    }
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    protected final void addBrick(int x, int y) {
        int mask = 1 << 30 - x;
        int n = y + 1;
        lvlBitfield[n] = lvlBitfield[n] | mask;
    }

    protected final void removeBrick(int x, int y) {
        int mask = 1 << 30 - x;
        int n = y + 1;
        lvlBitfield[n] = lvlBitfield[n] & ~mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAction() {
        try {
            int n = lastAct;
            return n;
        }
        finally {
            lastAct = 0;
        }
    }

    public final void setAction(int act) {
        if (act > lastAct) {
            lastAct = act;
        }
    }

    public final void paint(Graphics g) {
        int x = 0;
        while (x < fieldWidth) {
            int y = 0;
            while (y < fieldHeight) {
                Brick br = bField[x][y];
                if (br != null) {
                    br.paint(g);
                }
                ++y;
            }
            ++x;
        }
    }

    public final int left() {
        return originX;
    }

    public int right() {
        return originX + fieldWidth * 17 - 1;
    }

    protected final Brick getBrick(int x, int y) {
        int cx = (x - originX) / 17;
        int cy = y / 5;
        return this.getBrickCoord(cx, cy);
    }

    protected final Brick getBrickCoord(int bx, int by) {
        if (bx < fieldWidth && by < fieldHeight) {
            return bField[bx][by];
        }
        return null;
    }

    protected final void delBrickCoord(int bx, int by) {
        if (bField[bx][by].destroyable() && --onField == 0) {
            this.setAction(6);
        }
        this.removeBrick(bx, by);
        BrickField.bField[bx][by] = null;
    }

    public boolean reflect(Ball ball, Graphics g) {
        int bt = ball.top();
        int bb = ball.bottom() / 5 + 1;
        int n = bt = bt < 0 ? 0 : bt / 5 + 1;
        if (lvlBitfield[bt] != 0 || lvlBitfield[bb] != 0) {
            int br;
            int bl = ball.left() - originX;
            int bmask = 1 << 30 - (bl = bl < 0 ? -1 : bl / 17) | 1 << 30 - (br = (ball.right() - originX) / 17);
            if ((lvlBitfield[bt] & bmask) != 0 || (lvlBitfield[bb] & bmask) != 0) {
                if (bl < 0) {
                    ball.reflectHor(this.left() - 1);
                } else if (br >= fieldWidth) {
                    ball.reflectHor(this.right() + 1);
                } else if (bt <= 0) {
                    ball.reflectVer(-1);
                } else {
                    int hor2;
                    int hor1;
                    int ver2;
                    int ver1;
                    int dir = ball.direction();
                    if ((dir & 1) != 0) {
                        ver1 = bt - 1;
                        ver2 = bb - 1;
                        BrickField.reflDirs[0] = 1;
                    } else {
                        ver1 = bb - 1;
                        ver2 = bt - 1;
                        BrickField.reflDirs[0] = 2;
                    }
                    if ((dir & 8) != 0) {
                        hor1 = br;
                        hor2 = bl;
                        BrickField.reflDirs[1] = 8;
                    } else {
                        hor1 = bl;
                        hor2 = br;
                        BrickField.reflDirs[1] = 4;
                    }
                    BrickField.reflBricks[0] = this.getBrickCoord(hor2, ver1);
                    BrickField.reflBricks[1] = this.getBrickCoord(hor1, ver2);
                    if (reflBricks[0] == null && reflBricks[1] == null) {
                        BrickField.reflBricks[0] = this.getBrickCoord(hor1, ver1);
                        BrickField.reflDirs[0] = reflDirs[0] | reflDirs[1];
                    }
                    int i = 0;
                    while (i < reflBricks.length) {
                        Brick brick = reflBricks[i];
                        if (brick != null && brick.hittable()) {
                            this.setAction(ball.hitBrick(reflDirs[i], brick, g));
                            brick.paint(g);
                            int bx = (brick.left() - originX) / 17;
                            int by = brick.top() / 5;
                            if (!brick.hittable()) {
                                this.delBrickCoord(bx, by);
                            }
                        }
                        ++i;
                    }
                }
                return true;
            }
        }
        return false;
    }

    static {
        reflBricks = new Brick[2];
        reflDirs = new int[2];
    }
}

