/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.Ball;
import arkanoid.Caret;
import arkanoid.StandardCaret;
import javax.microedition.lcdui.Graphics;

class ProtectedCaret
extends Caret {
    private static final int NOF_HITS = 10;
    protected static ProtectedCaret caret;
    private static int nofHits;

    protected ProtectedCaret() {
    }

    public static ProtectedCaret getCaret() {
        return caret;
    }

    protected void myHide(Graphics g) {
        g.setColor(0xFFFFFF);
        int topLine = Caret.Y - 3 + 1;
        g.fillRect(Caret.X, topLine + 1, this.width, 2);
        g.drawLine(Caret.fLeft + 1, topLine, Caret.fRight - 1, topLine);
    }

    protected void paintCaret(Graphics g) {
        g.setColor(0);
        int topLine = Caret.Y - 3 + 1;
        g.fillRect(Caret.X, topLine + 1, this.width, 2);
        if (nofHits == 1) {
            int x = Caret.fLeft + 1;
            while (x < Caret.fRight - 1) {
                g.drawLine(x, topLine, x, topLine);
                x += 2;
            }
        } else {
            g.drawLine(Caret.fLeft + 1, topLine, Caret.fRight - 1, topLine);
        }
    }

    protected void myInit() {
        super.myInit();
        nofHits = 10;
    }

    protected boolean myReflect(Ball ball, Graphics g) {
        ball.reflectVer(Caret.top());
        if (ball.right() < Caret.left() || ball.left() > this.right()) {
            Caret.paint(g);
            if (--nofHits == 0) {
                Caret.setCurrent(StandardCaret.getCaret(), g);
            }
        }
        return true;
    }

    protected void myAction(int act, Graphics g) {
        if (act == 4) {
            nofHits = 10;
        } else {
            StandardCaret.getCaret().myAction(act, g);
        }
    }

    static {
        NOF_HITS = 10;
        caret = new ProtectedCaret();
    }
}

