/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Playfield {
    public static final byte EMPTY = 0;
    public static final byte ROAD1 = 1;
    public static final byte ROAD2 = 2;
    public static final byte ROAD3 = 3;
    public static final byte ROAD4 = 4;
    public static final byte ROAD5 = 5;
    public static final byte ROAD6 = 6;
    public static final byte ROAD7 = 7;
    public static final byte ROAD8 = 8;
    public static final byte ROAD9 = 9;
    public static final byte WALL = 10;
    public static final byte BRICK = 11;
    public static final byte ROCK = 12;
    public static final byte CLOSED_DOOR = 13;
    public static final byte OPEN_DOOR = 14;
    public static final byte SPAWNER = 15;
    public static final byte SWITCH_OFF = 16;
    public static final byte SWITCH_ON = 17;
    public static final byte SGATEV_CLOSED = 18;
    public static final byte SGATEV_OPEN = 19;
    public static final byte SGATEH_CLOSED = 20;
    public static final byte SGATEH_OPEN = 21;
    public static final byte CHEST = 22;
    public static final byte FLAME = 23;
    public static final byte TREASURE = 24;
    public static final byte BOMB = 25;
    public static final byte RINGBOMB = 26;
    public static final byte POWERBOMB = 27;
    public static final byte BRANCHBOMB = 28;
    public static final byte HUGEBOMB = 29;
    public static final byte POWER_BOMB = 30;
    public static final byte POWER_FLAME = 31;
    public static final byte POWER_RINGBOMB = 32;
    private static final byte _$9662 = 33;
    private static final byte _$9663 = 34;
    public static final byte POWER_HUGEBOMB = 35;
    public static final byte GOLD = 37;
    public static final byte POWERUP = 36;
    public static final int TILESIZE = 16;
    public static final byte EFF_NONE = 0;
    public static final byte EFF_BURN = 10;
    public static final byte EFF_EXIT = 11;
    private static final int _$9665 = 120;
    private static final byte _$9666 = 0;
    public static final byte FIRE_STRAIGHT = 1;
    private static final byte _$9667 = 3;
    private static final byte _$9668 = 4;
    private static final int _$9669 = 28;
    public static final byte OBJECTIVE_NONE = 0;
    public static final byte OBJECTIVE_COLLECT = 1;
    public static final byte OBJECTIVE_CLEAN = 2;
    private int _$9660;
    private String _$9661;
    public int levCount = 0;
    boolean[] passableTiles = new boolean[]{true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, false, false, false, true, false, true, true, true, true, false, false, false, false, false, true, true, true, true, true, true, true, true};
    private String[] _$9664;
    private Fire[] _$9672;
    int firstEmpty;
    int width;
    int height;
    int drawWidth;
    int drawHeight;
    int pAnim;
    int bombs;
    byte[][] grid;
    byte[][] cnt;
    byte[][] occ;
    byte[][] trace;
    byte[][] firemap;
    byte[][] firetype;
    boolean levelClear;
    byte levelObjective;
    int switchActivationId;
    int nextSwitchActivationId;
    public Player player;
    public Enemies enemies;
    Image[] allImages;
    Image[] icons;

    public Playfield(int n, int n2) {
        int n3;
        this._$9686();
        this.allImages = new Image[45];
        this.width = n;
        this.height = n2;
        this._$9679(n, n2);
        this._$9672 = new Fire[28];
        for (n3 = 0; n3 < 28; ++n3) {
            this._$9672[n3] = new Fire(this);
        }
        this._$9674();
        this.allImages[0] = GameMidlet.getImage("grass1");
        this.allImages[10] = GameMidlet.getImage("mountain");
        this.allImages[11] = GameMidlet.getImage("tree2");
        this.allImages[13] = GameMidlet.getImage("door1");
        this.allImages[14] = GameMidlet.getImage("door2");
        this.allImages[15] = GameMidlet.getImage("enemy1");
        this.allImages[12] = GameMidlet.getImage("tree1");
        this.allImages[16] = GameMidlet.getImage("switch1");
        this.allImages[17] = GameMidlet.getImage("switch2");
        this.allImages[18] = GameMidlet.getImage("sgate0");
        this.allImages[19] = GameMidlet.getImage("sgate1");
        this.allImages[20] = GameMidlet.getImage("sgate2");
        this.allImages[21] = GameMidlet.getImage("sgate3");
        this.allImages[22] = GameMidlet.getImage("chest");
        this.allImages[1] = GameMidlet.getImage("road1");
        this.allImages[2] = GameMidlet.getImage("road2");
        this.allImages[3] = GameMidlet.getImage("road3");
        this.allImages[4] = GameMidlet.getImage("road4");
        this.allImages[5] = GameMidlet.getImage("road5");
        this.allImages[6] = GameMidlet.getImage("road6");
        this.allImages[7] = GameMidlet.getImage("road7");
        this.allImages[8] = GameMidlet.getImage("road8");
        this.allImages[9] = GameMidlet.getImage("road9");
        this.allImages[24] = GameMidlet.getImage("treasure");
        this.allImages[25] = GameMidlet.getImage("fireball");
        this.allImages[26] = this.allImages[25];
        this.allImages[27] = this.allImages[25];
        this.allImages[28] = this.allImages[25];
        this.allImages[29] = this.allImages[25];
        this.allImages[30] = GameMidlet.getImage("poweri1");
        this.allImages[31] = GameMidlet.getImage("poweri2");
        this.allImages[32] = GameMidlet.getImage("poweri4");
        this.allImages[33] = GameMidlet.getImage("poweri5");
        this.allImages[34] = GameMidlet.getImage("poweri6");
        this.allImages[35] = GameMidlet.getImage("poweri7");
        this.allImages[23] = GameMidlet.getImage("spell2");
        this.allImages[36] = GameMidlet.getImage("power0");
        this.allImages[37] = GameMidlet.getImage("power1");
        this.allImages[38] = GameMidlet.getImage("power2");
        this.icons = new Image[4];
        for (n3 = 0; n3 < 12; ++n3) {
            if (n3 >= this.icons.length) continue;
            this.icons[n3] = GameMidlet.getImage(String.valueOf(String.valueOf(new StringBuffer("icon").append(n3 + 1))));
        }
        this.icons[1] = this.allImages[25];
        this.pAnim = 0;
    }

    public int addFire(byte by, int n, int n2, int n3, int n4, byte by2) {
        int n5;
        for (n5 = this.firstEmpty; n5 < 28 && this._$9672[n5].type != 0; ++n5) {
        }
        if (n5 == 28) {
            return -1;
        }
        this._$9672[n5].type = by;
        this._$9672[n5].x = n;
        this._$9672[n5].y = n2;
        this._$9672[n5].xsp = n3;
        this._$9672[n5].ysp = n4;
        this._$9672[n5].cnt = by2;
        this.firstEmpty = n5;
        return n5;
    }

    private void _$9673(int n) {
        this._$9672[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
    }

    private void _$9674() {
        for (int i = 0; i < 28; ++i) {
            this._$9672[i].type = 0;
        }
        this.firstEmpty = 0;
    }

    private void _$9675(String string) {
        this._$9661 = string;
        this._$9660 = 0;
    }

    private int _$9676() {
        if (this._$9660 >= this._$9661.length()) {
            return -1;
        }
        return this._$9661.charAt(this._$9660++);
    }

    public void loadLevel(int n) {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            if (--n >= this._$9664.length) {
                n = this._$9664.length - 1;
            }
            this._$9675(this._$9664[n]);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n5 = this._$9676()) != 59) {
                stringBuffer.append((char)n5);
            }
            this.width = Integer.parseInt(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while ((n5 = this._$9676()) != 59) {
                stringBuffer.append((char)n5);
            }
            this.height = Integer.parseInt(stringBuffer.toString());
            this._$9679(this.width, this.height);
            for (n4 = 0; n4 < this.height; ++n4) {
                for (n3 = 0; n3 < this.width; ++n3) {
                    this.grid[n4][n3] = (byte)((byte)this._$9676() - 65);
                    this.trace[n4][n3] = -1;
                    this.firemap[n4][n3] = 0;
                    this.firetype[n4][n3] = 0;
                }
            }
            this.enemies.reset();
            n4 = this._$9676();
            if (n4 == 77) {
                n3 = 1;
                while (n3 != 0) {
                    stringBuffer = new StringBuffer();
                    while ((n5 = this._$9676()) != 59) {
                        if (n5 == 77) {
                            n3 = 0;
                            break;
                        }
                        stringBuffer.append((char)n5);
                    }
                    if (n3 == 0) continue;
                    this.enemies.decode(stringBuffer.toString());
                }
                n4 = this._$9676();
            }
            if (n4 == 84) {
                n3 = 1;
                n2 = 1;
                while (n3 != 0) {
                    stringBuffer = new StringBuffer();
                    while ((n5 = this._$9676()) != 59) {
                        if (n5 == 84) {
                            n3 = 0;
                            break;
                        }
                        stringBuffer.append((char)n5);
                    }
                    if (n3 == 0) break;
                    String string = stringBuffer.toString();
                    try {
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        if (string.charAt(0) == 's') {
                            string = string.substring(1);
                            n9 = string.indexOf(44);
                            int n10 = string.indexOf(58);
                            int n11 = 0;
                            int n12 = Integer.parseInt(string.substring(0, n9));
                            n8 = Integer.parseInt(string.substring(n9 + 1, n10));
                            while (n11 != string.length()) {
                                n9 = string.indexOf(44, n10 + 1);
                                n11 = string.indexOf(44, n9 + 1);
                                if (n11 == -1) {
                                    n11 = string.length();
                                }
                                n7 = Integer.parseInt(string.substring(n10 + 1, n9));
                                n6 = Integer.parseInt(string.substring(n9 + 1, n11));
                                n10 = n11;
                                byte[] byArray = this.cnt[n6];
                                int n13 = n7;
                                byArray[n13] = (byte)(byArray[n13] + n2);
                            }
                            this.cnt[n8][n12] = n2;
                            n2 = (byte)(n2 * 2);
                            continue;
                        }
                        if (string.charAt(0) != 'c') continue;
                        n6 = string.indexOf(44);
                        n9 = string.indexOf(58);
                        int n14 = Integer.parseInt(string.substring(1, n6));
                        n8 = Integer.parseInt(string.substring(n6 + 1, n9));
                        n7 = Integer.parseInt(string.substring(n9 + 1));
                        this.cnt[n8][n14] = (byte)n7;
                    }
                    catch (Exception exception) {
                        System.err.println("Playfield.loadlevel");
                        exception.printStackTrace();
                    }
                }
            }
            for (n3 = 0; n3 < this.height; ++n3) {
                for (n2 = 0; n2 < this.width; ++n2) {
                    if (this.grid[n3][n2] != 10) continue;
                    int n15 = 0;
                    if (n3 < this.height - 1 && this.grid[n3 + 1][n2] == 10) {
                        n15 = (byte)(n15 + 1);
                    }
                    if (n2 > 0 && this.grid[n3][n2 - 1] == 10) {
                        n15 = (byte)(n15 + 2);
                    }
                    if (n3 > 0 && this.grid[n3 - 1][n2] == 10) {
                        n15 = (byte)(n15 + 4);
                    }
                    if (n2 < this.width - 1 && this.grid[n3][n2 + 1] == 10) {
                        n15 = (byte)(n15 + 8);
                    }
                    this.cnt[n3][n2] = n15;
                }
            }
            this.player.resetPos();
            this.levelObjective = (byte)2;
            this.levelClear = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Playfield.loadlevel2");
        }
    }

    private void _$9679(int n, int n2) {
        this.grid = new byte[n2][n];
        this.cnt = new byte[n2][n];
        this.occ = new byte[n2][n];
        this.trace = new byte[n2][n];
        this.firemap = new byte[n2][n];
        this.firetype = new byte[n2][n];
        this.switchActivationId = 0;
        this.nextSwitchActivationId = 0;
    }

    private void _$9686() {
        try {
            InputStream inputStream = ((Object)((Object)GameMidlet.instance)).getClass().getResourceAsStream("/levels.txt");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[1000];
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            this.levCount = 1;
            while (n2 < this.levCount) {
                n = ((Reader)inputStreamReader).read(cArray, n4, 1000 - n4);
                if (n != -1) {
                    n4 += n;
                }
                for (n6 = n3; n6 < n4 && cArray[n6] != '\n'; ++n6) {
                }
                n5 = n6 - 1;
                String string = new String(cArray, n3, n5 - n3);
                n3 = 0;
                n5 += 2;
                while (n5 < n4) {
                    cArray[n3] = cArray[n5];
                    ++n3;
                    ++n5;
                }
                n4 = n3;
                n3 = 0;
                if (bl) {
                    bl = false;
                    this.levCount = Integer.parseInt(string);
                    this._$9664 = new String[this.levCount];
                    continue;
                }
                this._$9664[n2++] = string;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in ReadLevels: ");
            exception.printStackTrace();
        }
    }

    public void reset() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.grid[i][j] = 0;
                this.cnt[i][j] = 0;
                this.trace[i][j] = -1;
                this.firemap[i][j] = 0;
                this.firetype[i][j] = 0;
            }
        }
        this.bombs = 0;
    }

    int getGridX(int n) {
        return n / 16;
    }

    int getGridY(int n) {
        return n / 16;
    }

    public boolean setBomb(byte by, int n, int n2, int n3) {
        if (this.bombs >= this.player.bombs) {
            return false;
        }
        if (this.grid[n2][n] > 9 || this.firetype[n2][n] > 23) {
            return false;
        }
        this.firetype[n2][n] = by;
        this.firemap[n2][n] = (byte)n3;
        ++this.bombs;
        return true;
    }

    public boolean setFlame(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return true;
        }
        byte by = this.grid[n2][n];
        if (this.firetype[n2][n] > 23) {
            this.firemap[n2][n] = (byte)Math.min(this.firemap[n2][n], (byte)(1 + n3));
            return !bl;
        }
        if (by <= 9 || by == 36) {
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            return false;
        }
        if (by == 11) {
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            return true;
        }
        if (by == 22) {
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            this.grid[n2][n] = this.cnt[n2][n] == 37 ? 24 : 36;
            return false;
        }
        if (by == 12) {
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            if (this.cnt[n2][n] != 2 && !bl) {
                byte[] byArray = this.cnt[n2];
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] + 1);
            }
            return true;
        }
        if (by == 15) {
            this.player.givePoints(10);
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            if (bl) {
                return false;
            }
        }
        if (by == 21 || by == 19) {
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            return false;
        }
        if (by == 16 || by == 17) {
            this.firetype[n2][n] = 23;
            this.firemap[n2][n] = (byte)(0 - n3);
            this.nextSwitchActivationId |= this.cnt[n2][n];
            this.grid[n2][n] = by == 16 ? 17 : 16;
        }
        return true;
    }

    boolean isPassable(int n, int n2, int n3) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        if (this.firetype[n2][n] > 23) {
            return false;
        }
        return this.passableTiles[this.grid[n2][n]];
    }

    boolean isBomb(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        return this.firetype[n2][n] > 23;
    }

    boolean isOccupied(int n, int n2) {
        return this.occ[n2][n] != 0;
    }

    void occupy(int n, int n2) {
        this.occ[n2][n] = 2;
    }

    void setDrawDimensions(int n, int n2) {
        this.drawWidth = n;
        this.drawHeight = n2;
    }

    public byte passThrough(int n, int n2, boolean bl) {
        byte by = this.grid[n2][n];
        if (this.firetype[n2][n] == 23) {
            return 10;
        }
        switch (by) {
            case 14: {
                return 11;
            }
            case 24: {
                if (!bl) {
                    return 0;
                }
                Effects.playSound3();
                this.grid[n2][n] = 0;
                return 37;
            }
            case 36: {
                if (!bl) {
                    return 0;
                }
                byte by2 = this.cnt[n2][n];
                Effects.playSound3();
                this.grid[n2][n] = 0;
                System.out.println("bonus: ".concat(String.valueOf(String.valueOf(by2))));
                return by2;
            }
        }
        return 0;
    }

    public void update() {
        try {
            int n;
            int n2;
            int n3 = 0;
            this.switchActivationId = this.nextSwitchActivationId;
            this.nextSwitchActivationId = 0;
            for (n2 = 0; n2 < this.width; ++n2) {
                for (int i = 0; i < this.height; ++i) {
                    byte by;
                    if (this.occ[i][n2] > 0) {
                        byte[] byArray = this.occ[i];
                        int n4 = n2;
                        byArray[n4] = (byte)(byArray[n4] - 1);
                    }
                    n = this.grid[i][n2];
                    if (this.firetype[i][n2] == 23) {
                        byte[] byArray = this.firemap[i];
                        int n5 = n2;
                        byArray[n5] = (byte)(byArray[n5] + 1);
                        if (this.firemap[i][n2] == 9) {
                            this.firetype[i][n2] = 0;
                            if (n == 12 && this.cnt[i][n2] == 2 || n == 15 || n == 11) {
                                this.grid[i][n2] = 0;
                            }
                        }
                    } else if (this.firetype[i][n2] > 23) {
                        byte[] byArray = this.firemap[i];
                        int n6 = n2;
                        byArray[n6] = (byte)(byArray[n6] - 1);
                        if (this.firemap[i][n2] == 0) {
                            Effects.playSound1();
                            --this.bombs;
                            this.firemap[i][n2] = 0;
                            if (this.firetype[i][n2] == 29) {
                                this.setFlame(n2, i, 1, false);
                                this.firetype[i][n2] = 23;
                                return;
                            }
                            by = this.firetype[i][n2] == 25 ? (byte)1 : (this.firetype[i][n2] == 28 ? (byte)4 : 3);
                            this.addFire(by, n2 * 16, i * 16, -16, 0, (byte)(this.player.flames + 1));
                            this.addFire(by, n2 * 16, i * 16, 16, 0, (byte)(this.player.flames + 1));
                            this.addFire(by, n2 * 16, i * 16, 0, -16, (byte)(this.player.flames + 1));
                            this.addFire(by, n2 * 16, i * 16, 0, 16, (byte)(this.player.flames + 1));
                            this.firetype[i][n2] = 23;
                        }
                    } else if (this.firetype[i][n2] == 26) {
                        byte[] byArray = this.firemap[i];
                        int n7 = n2;
                        byArray[n7] = (byte)(byArray[n7] - 1);
                        if (this.firemap[i][n2] == 0) {
                            --this.bombs;
                            for (by = -2; by <= 2; ++by) {
                                this.setFlame(n2 - 2, i + by, 1, false);
                                this.setFlame(n2 + 2, i + by, 1, false);
                                this.setFlame(n2 + by, i - 2, 1, false);
                                this.setFlame(n2 + by, i + 2, 1, false);
                            }
                            this.firetype[i][n2] = 0;
                            this.firemap[i][n2] = 0;
                        }
                    }
                    if (n == 13) {
                        if (!this.levelClear) continue;
                        this.grid[i][n2] = 14;
                        continue;
                    }
                    if (n >= 18 && n <= 21 && (this.cnt[i][n2] & this.switchActivationId) != 0) {
                        switch (n) {
                            case 20: {
                                this.grid[i][n2] = 21;
                                break;
                            }
                            case 21: {
                                this.grid[i][n2] = 20;
                                break;
                            }
                            case 18: {
                                this.grid[i][n2] = 19;
                                break;
                            }
                            case 19: {
                                this.grid[i][n2] = 18;
                            }
                        }
                        continue;
                    }
                    if (n != 15) continue;
                    ++n3;
                    byte[] byArray = this.cnt[i];
                    int n8 = n2;
                    byArray[n8] = (byte)(byArray[n8] + 1);
                    if (this.cnt[i][n2] != 120) continue;
                    this.cnt[i][n2] = 0;
                    if (this.isOccupied(n2, i)) continue;
                    this.enemies.addEnemy((byte)2, n2, i, (byte)0, (byte)2, 0);
                }
            }
            for (n2 = 0; n2 < 28; ++n2) {
                if (this._$9672[n2].type == 0) continue;
                Fire fire = this._$9672[n2];
                fire.x += fire.xsp;
                fire.y += fire.ysp;
                fire.cnt = (byte)(fire.cnt - 1);
                if (fire.cnt == 0) {
                    this._$9673(n2);
                    continue;
                }
                n = this.getGridX(fire.x);
                int n9 = this.getGridY(fire.y);
                if (fire.type == 1 && this.setFlame(n, n9, 1, false)) {
                    this._$9673(n2);
                    continue;
                }
                if (fire.type == 4) {
                    if (fire.cnt > 1) {
                        if (fire.xsp != 0) {
                            if (this.isPassable(n, n9 + 1, -1)) {
                                this.addFire((byte)1, fire.x, fire.y, 0, 16, (byte)(fire.cnt - 2));
                            }
                            if (this.isPassable(n, n9 - 1, -1)) {
                                this.addFire((byte)1, fire.x, fire.y, 0, -16, (byte)(fire.cnt - 2));
                            }
                        }
                        if (fire.ysp != 0) {
                            if (this.isPassable(n + 1, n9, -1)) {
                                this.addFire((byte)1, fire.x, fire.y, 16, 0, (byte)(fire.cnt - 2));
                            }
                            if (this.isPassable(n - 1, n9, -1)) {
                                this.addFire((byte)1, fire.x, fire.y, -16, 0, (byte)(fire.cnt - 2));
                            }
                        }
                    }
                    if (this.setFlame(n, n9, 1, false)) {
                        this._$9673(n2);
                        continue;
                    }
                }
                if (fire.type != 3 || !this.setFlame(n, n9, 1, true)) continue;
                this._$9673(n2);
            }
            if (this.levelObjective == 2 && (n3 += this.enemies.update()) == 0) {
                this.levelClear = true;
            }
        }
        catch (Exception exception) {
            System.err.println("exception in update ".concat(String.valueOf(String.valueOf(exception.toString()))));
            exception.printStackTrace();
        }
    }

    public void updateScreen(Graphics graphics) {
        byte by = 0;
        try {
            int n = Font.getFont((int)0, (int)0, (int)8).getHeight();
            int n2 = this.drawHeight - 16;
            graphics.setColor(206, 173, 115);
            graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
            graphics.setColor(17, 17, 17);
            graphics.drawRect(0, 0, this.drawWidth - 1, 15);
            int n3 = this.player.x + 8;
            int n4 = this.player.y + 8;
            int n5 = n3 - this.drawWidth / 2;
            int n6 = n4 - n2 / 2;
            if (n5 <= 0 || this.drawWidth >= this.grid[0].length * 16) {
                n5 = 0;
            } else if (n5 + this.drawWidth > this.grid[0].length * 16) {
                n5 = this.grid[0].length * 16 - this.drawWidth;
            }
            if (n6 <= 0 || n2 >= this.grid.length * 16) {
                n6 = 0;
            } else if (n6 + n2 > this.grid.length * 16) {
                n6 = this.grid.length * 16 - n2;
            }
            int n7 = n5 / 16;
            int n8 = n6 / 16;
            int n9 = -(n5 % 16);
            int n10 = -(n6 % 16);
            int n11 = this.drawWidth / 16 + 2;
            int n12 = n2 / 16 + 2;
            if (n7 + n11 > this.grid[0].length) {
                n11 = this.grid[0].length - n7;
            }
            if (n8 + n12 > this.grid.length) {
                n12 = this.grid.length - n8;
            }
            int n13 = 0;
            int n14 = 0;
            graphics.setClip(0, 16, this.drawWidth, n2);
            for (n13 = 0; n13 < n11; ++n13) {
                for (n14 = 0; n14 < n12; ++n14) {
                    byte by2 = this.grid[n8 + n14][n7 + n13];
                    by = this.cnt[n8 + n14][n7 + n13];
                    if (by < 1) {
                        by = 1;
                    }
                    if (by2 == 36) {
                        graphics.drawImage(this.allImages[0], n13 * 16 + n9, 16 + n14 * 16 + n10, 20);
                        graphics.drawImage(this.allImages[36 + (this.pAnim % 4 == 3 ? 1 : this.pAnim % 4)], n13 * 16 + n9, 16 + n14 * 16 + n10, 20);
                        graphics.drawImage(this.allImages[this.cnt[n8 + n14][n7 + n13]], n13 * 16 + n9, 16 + n14 * 16 + n10, 20);
                        continue;
                    }
                    if (by2 > 12) {
                        graphics.drawImage(this.allImages[0], n13 * 16 + n9, 16 + n14 * 16 + n10, 20);
                    }
                    graphics.drawImage(this.allImages[by2], n13 * 16 + n9, 16 + n14 * 16 + n10, 20);
                }
            }
            graphics.setColor(120, 120, 120);
            this.enemies.updateGraphics(-n5 + 8, 16 + -n6 + 8, this.drawWidth, this.drawHeight + 16, graphics);
            if (this.player.mode != 1 && this.player.invinc % 3 < 2 || this.player.mode == 1 && this.player.step % 3 < 2) {
                graphics.drawImage(this.player.getImage(), this.player.x - n5 + 8, 16 + this.player.y - n6 + 8, 3);
            }
            for (n13 = 0; n13 < n11; ++n13) {
                for (n14 = 0; n14 < n12; ++n14) {
                    if (this.firetype[n8 + n14][n7 + n13] <= 0) continue;
                    graphics.drawImage(this.allImages[this.firetype[n8 + n14][n7 + n13]], n13 * 16 + n9, 16 + n14 * 16 + n10, 20);
                }
            }
            if (GameMidlet.instance.menuScreen.gameScreen.godmode) {
                graphics.setColor(0, 0, 0);
                graphics.setClip(0, 16, this.drawWidth, 30);
                graphics.drawString("Cheater!", 0, 16, 0x10 | 4);
            }
            graphics.setClip(0, 0, this.drawWidth, 16);
            graphics.drawImage(this.icons[0], 2, 8, 6);
            graphics.drawImage(this.icons[1], 26, 8, 6);
            graphics.drawImage(this.icons[2], 50, 8, 6);
            graphics.setColor(17, 17, 17);
            if (this.player.extra != 0) {
                graphics.drawImage(this.allImages[this.player.extra + 6], 74, 8, 6);
                if (this.player.exCnt > 0) {
                    graphics.drawString(Integer.toString(this.player.exCnt), 89, 8 + n / 2, 36);
                }
            }
            graphics.drawString(Integer.toString(this.player.lives - 1), 16, 8 + n / 2, 36);
            graphics.drawString(Integer.toString(this.player.bombs), 40, 8 + n / 2, 36);
            graphics.drawString(Integer.toString(this.player.flames), 64, 8 + n / 2, 36);
            graphics.drawString(Integer.toString(this.player.points), this.drawWidth - 2, 8 + n / 2, 40);
            graphics.setColor(255, 80, 0);
            ++this.pAnim;
            if (this.pAnim == 120) {
                this.pAnim = 0;
            }
        }
        catch (Exception exception) {
            System.err.println("exception in updatescreen ".concat(String.valueOf(String.valueOf(exception.toString()))));
        }
    }

    static {
        EMPTY = 0;
        ROAD1 = 1;
        ROAD2 = (byte)2;
        ROAD3 = (byte)3;
        ROAD4 = (byte)4;
        ROAD5 = (byte)5;
        ROAD6 = (byte)6;
        ROAD7 = (byte)7;
        ROAD8 = (byte)8;
        ROAD9 = (byte)9;
        WALL = (byte)10;
        BRICK = (byte)11;
        ROCK = (byte)12;
        CLOSED_DOOR = (byte)13;
        OPEN_DOOR = (byte)14;
        SPAWNER = (byte)15;
        SWITCH_OFF = (byte)16;
        SWITCH_ON = (byte)17;
        SGATEV_CLOSED = (byte)18;
        SGATEV_OPEN = (byte)19;
        SGATEH_CLOSED = (byte)20;
        SGATEH_OPEN = (byte)21;
        CHEST = (byte)22;
        FLAME = (byte)23;
        TREASURE = (byte)24;
        BOMB = (byte)25;
        RINGBOMB = (byte)26;
        POWERBOMB = (byte)27;
        BRANCHBOMB = (byte)28;
        HUGEBOMB = (byte)29;
        POWER_BOMB = (byte)30;
        POWER_FLAME = (byte)31;
        POWER_RINGBOMB = (byte)32;
        _$9662 = (byte)33;
        _$9663 = (byte)34;
        POWER_HUGEBOMB = (byte)35;
        GOLD = (byte)37;
        POWERUP = (byte)36;
        TILESIZE = 16;
        EFF_NONE = 0;
        EFF_BURN = (byte)10;
        EFF_EXIT = (byte)11;
        _$9665 = 120;
        _$9666 = 0;
        FIRE_STRAIGHT = 1;
        _$9667 = (byte)3;
        _$9668 = (byte)4;
        _$9669 = 28;
        OBJECTIVE_NONE = 0;
        OBJECTIVE_COLLECT = 1;
        OBJECTIVE_CLEAN = (byte)2;
    }

    public class Fire {
        public static final int DATA_LENGTH = 18;
        byte type;
        byte cnt;
        int x;
        int y;
        int xsp;
        int ysp;

        public Fire(Playfield playfield) {
        }

        static {
            DATA_LENGTH = 18;
        }
    }
}

