/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

class GameBullet {
    public Sprite sprite;
    public int type;
    public int power = 0;
    public boolean free;
    public int BulletX = 0;
    public int BulletY = 0;
    public SkyWar midlet;
    public int xMin;
    public int yMin;
    public int xMax;
    public int yMax;
    public int x1 = 0;
    public int y1 = 0;
    public int x2 = 0;
    public int y2 = 0;
    private int dx;
    private int dy;
    private int P;
    public int frameTime = 0;
    public boolean isPlayer;
    public int[] aspectX = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public int[] aspectY = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    public int aspect = 0;
    public boolean scope = false;

    GameBullet(Sprite sprite, int type) {
        this.sprite = sprite;
        this.type = type;
        this.free = false;
    }

    public void addMidlet(SkyWar midlet) {
        this.midlet = midlet;
    }

    private GameObject getPlayer() {
        return this.midlet.gameCanvas.Player;
    }

    private int getSpeed() {
        int speed = 0;
        switch (this.type) {
            case 0: {
                speed = 10;
                break;
            }
            case 1: {
                speed = 3;
                break;
            }
            case 2: {
                speed = 4;
                break;
            }
            case 3: {
                speed = 4;
                break;
            }
            case 4: {
                speed = 3;
                break;
            }
            case 5: {
                speed = 3;
                break;
            }
            case 6: {
                speed = 4;
                break;
            }
            case 7: {
                speed = 5;
            }
        }
        if (this.midlet.gameCanvas.ViewWidth <= 200) {
            speed = speed * 2 / 3;
        }
        return speed;
    }

    public void tickBullet() {
        int speed = this.getSpeed();
        ++this.frameTime;
        if (this.type != 0) {
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    if (this.scope) {
                        this.normalAspect();
                        break;
                    }
                    this.specialAspect();
                    break;
                }
                case 4: {
                    this.specialAspect();
                    break;
                }
                case 6: {
                    this.specialAspect();
                    break;
                }
                case 7: {
                    this.specialAspect();
                }
            }
            if (this.type != 7 && this.frameTime == 2) {
                this.sprite.nextFrame();
                this.frameTime = 0;
                if (this.BulletX == this.x1 && this.BulletY == this.y1) {
                    this.midlet.gameCanvas.layerManager.remove((Layer)this.sprite);
                    this.midlet.gameCanvas.layer[0] = this.midlet.gameCanvas.layer[0] - 1;
                    this.free = true;
                }
            }
        } else {
            this.BulletY -= speed;
        }
    }

    public void extendInit(int x, int y, int width, int height) {
        this.xMin = x;
        this.yMin = y;
        this.xMax = x + width;
        this.yMax = y + height;
    }

    public void calculateAspect(int x, int y) {
        this.x1 = x;
        this.y1 = y;
        int width = this.getPlayer().mainSprite.getWidth();
        int height = this.getPlayer().mainSprite.getHeight();
        int x2 = this.getPlayer().ObjectX;
        int y2 = this.getPlayer().ObjectY;
        x2 += width / 2;
        if (this.midlet.gameCanvas.upKey) {
            y2 -= height / 2;
        }
        if (this.midlet.gameCanvas.downKey) {
            y2 += height / 2;
        }
        if (this.midlet.gameCanvas.leftKey) {
            x2 -= width / 2;
        }
        if (this.midlet.gameCanvas.rightKey) {
            x2 += width / 2;
        }
        this.dx = x2 - this.x1;
        this.dy = y2 - this.y1;
        if (this.dx != 0 && this.dy != 0) {
            this.P = this.dx > 0 && this.dy > 0 ? (this.dx > this.dy ? this.dx - 2 * this.dy : this.dy - 2 * this.dx) : (this.dx > 0 && this.dy < 0 ? (this.dx > Math.abs(this.dy) ? 2 * this.dy + this.dx : this.dy + 2 * this.dx) : (this.dx < 0 && this.dy > 0 ? (Math.abs(this.dx) > this.dy ? this.dx + 2 * this.dy : 2 * this.dx + this.dy) : (Math.abs(this.dx) > Math.abs(this.dy) ? this.dx - 2 * this.dy : this.dy - 2 * this.dx)));
        }
    }

    private void normalAspect() {
        int speed;
        int x = 0;
        int y = 0;
        x = this.BulletX;
        y = this.BulletY;
        if (this.x1 == this.x2) {
            y = this.y1 < this.y2 ? (y += speed) : (y -= speed);
        } else if (this.y1 == this.y2) {
            x = this.x1 < this.x2 ? (x += speed) : (x -= speed);
        } else if (this.dx != 0 && this.dy != 0) {
            if (this.dx > 0 && this.dy > 0) {
                if (this.dx > this.dy) {
                    for (speed = this.getSpeed(); speed > 0; --speed) {
                        if (this.P > 0) {
                            this.P -= 2 * this.dy;
                        } else {
                            this.P = this.P - 2 * this.dy + 2 * this.dx;
                            ++y;
                        }
                        ++x;
                    }
                } else {
                    while (speed > 0) {
                        if (this.P > 0) {
                            this.P -= 2 * this.dx;
                        } else {
                            this.P = this.P - 2 * this.dx + 2 * this.dy;
                            ++x;
                        }
                        ++y;
                        --speed;
                    }
                }
            } else if (this.dx > 0 && this.dy < 0) {
                if (this.dx > Math.abs(this.dy)) {
                    while (speed > 0) {
                        if (this.P > 0) {
                            this.P += 2 * this.dy;
                        } else {
                            this.P = this.P + 2 * this.dx + 2 * this.dy;
                            --y;
                        }
                        ++x;
                        --speed;
                    }
                } else {
                    while (speed > 0) {
                        if (this.P < 0) {
                            this.P += 2 * this.dx;
                        } else {
                            this.P = this.P + 2 * this.dx + 2 * this.dy;
                            ++x;
                        }
                        --y;
                        --speed;
                    }
                }
            } else if (this.dx < 0 && this.dy > 0) {
                if (Math.abs(this.dx) > this.dy) {
                    while (speed > 0) {
                        if (this.P < 0) {
                            this.P += 2 * this.dy;
                        } else {
                            this.P = this.P + 2 * this.dx + 2 * this.dy;
                            ++y;
                        }
                        --x;
                        --speed;
                    }
                } else {
                    while (speed > 0) {
                        if (this.P > 0) {
                            this.P += 2 * this.dx;
                        } else {
                            this.P = this.P + 2 * this.dx + 2 * this.dy;
                            --x;
                        }
                        ++y;
                        --speed;
                    }
                }
            } else if (Math.abs(this.dx) > Math.abs(this.dy)) {
                while (speed > 0) {
                    if (this.P < 0) {
                        this.P -= 2 * this.dy;
                    } else {
                        this.P = this.P + 2 * this.dx - 2 * this.dy;
                        --y;
                    }
                    --x;
                    --speed;
                }
            } else {
                while (speed > 0) {
                    if (this.P < 0) {
                        this.P -= 2 * this.dx;
                    } else {
                        this.P = this.P + 2 * this.dy - 2 * this.dx;
                        --x;
                    }
                    --y;
                    --speed;
                }
            }
        }
        this.BulletX = x;
        this.BulletY = y;
    }

    private void specialAspect() {
        int speed = this.getSpeed();
        if (this.type != 7) {
            this.BulletX += this.aspectX[this.aspect] * speed;
            this.BulletY += this.aspectY[this.aspect] * speed;
        } else {
            this.normalAspect();
            if (this.aspect < 2 && this.frameTime == 40) {
                ++this.aspect;
                this.calculateAspect(this.BulletX, this.BulletY);
            }
            if (this.frameTime > 0 && this.frameTime % 2 == 0 && this.BulletX == this.x1 && this.BulletY == this.y1) {
                this.midlet.gameCanvas.layerManager.remove((Layer)this.sprite);
                this.midlet.gameCanvas.layer[0] = this.midlet.gameCanvas.layer[0] - 1;
                this.free = true;
            }
            if (this.frameTime == 40) {
                this.frameTime = 0;
            }
        }
    }
}

