/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import javax.microedition.m3g.Object3D;

public class AnimationController
extends Object3D {
    private int activeIntervalStart = 0;
    private int activeIntervalEnd = 0;
    private int refWorldTime = 0;
    private float refSequenceTime = 0.0f;
    private float weight = 1.0f;
    private float speed = 1.0f;

    public void setActiveInterval(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        this.activeIntervalStart = start;
        this.activeIntervalEnd = end;
    }

    public int getActiveIntervalStart() {
        return this.activeIntervalStart;
    }

    public int getActiveIntervalEnd() {
        return this.activeIntervalEnd;
    }

    public void setSpeed(float speed, int worldTime) {
        this.refSequenceTime = this.getPosition(worldTime);
        this.refWorldTime = worldTime;
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setPosition(float sequenceTime, int worldTime) {
        this.refSequenceTime = sequenceTime;
        this.refWorldTime = worldTime;
    }

    public float getPosition(int worldTime) {
        return this.refSequenceTime + this.speed * (float)(worldTime - this.refWorldTime);
    }

    public int getRefWorldTime() {
        return this.refWorldTime;
    }

    public void setWeight(float weight) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.weight = weight;
    }

    public float getWeight() {
        return this.weight;
    }

    protected boolean isActive(int worldTime) {
        return this.activeIntervalStart == this.activeIntervalEnd ? true : worldTime >= this.activeIntervalStart && worldTime < this.activeIntervalEnd;
    }

    protected int timeToActivation(int worldTime) {
        return worldTime < this.activeIntervalStart ? this.activeIntervalStart - worldTime : (worldTime >= this.activeIntervalEnd ? Integer.MAX_VALUE : 0);
    }

    protected int timeToDeactivation(int worldTime) {
        return worldTime < this.activeIntervalEnd ? this.activeIntervalEnd - worldTime : Integer.MAX_VALUE;
    }
}

