/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing.policy;

import com.sun.xml.internal.ws.addressing.W3CAddressingMetadataConstants;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.policy.NestedPolicy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionValidator;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class AddressingPolicyValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> supportedAssertions = new ArrayList();
    private static final PolicyLogger LOGGER;

    @Override
    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion policyAssertion) {
        return supportedAssertions.contains(policyAssertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion policyAssertion) {
        NestedPolicy nestedPolicy;
        if (!supportedAssertions.contains(policyAssertion.getName())) {
            return PolicyAssertionValidator.Fitness.UNKNOWN;
        }
        if (policyAssertion.getName().equals(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION) && (nestedPolicy = policyAssertion.getNestedPolicy()) != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (PolicyAssertion policyAssertion2 : nestedPolicy.getAssertionSet()) {
                if (policyAssertion2.getName().equals(W3CAddressingMetadataConstants.WSAM_ANONYMOUS_NESTED_ASSERTION)) {
                    bl = true;
                    continue;
                }
                if (policyAssertion2.getName().equals(W3CAddressingMetadataConstants.WSAM_NONANONYMOUS_NESTED_ASSERTION)) {
                    bl2 = true;
                    continue;
                }
                LOGGER.warning("Found unsupported assertion:\n" + policyAssertion2 + "\nnested into assertion:\n" + policyAssertion);
                return PolicyAssertionValidator.Fitness.UNSUPPORTED;
            }
            if (bl && bl2) {
                LOGGER.warning("Only one among AnonymousResponses and NonAnonymousResponses can be nested in an Addressing assertion");
                return PolicyAssertionValidator.Fitness.INVALID;
            }
        }
        return PolicyAssertionValidator.Fitness.SUPPORTED;
    }

    @Override
    public String[] declareSupportedDomains() {
        return new String[]{AddressingVersion.MEMBER.policyNsUri, AddressingVersion.W3C.policyNsUri, "http://www.w3.org/2007/05/addressing/metadata"};
    }

    static {
        supportedAssertions.add(new QName(AddressingVersion.MEMBER.policyNsUri, "UsingAddressing"));
        supportedAssertions.add(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION);
        supportedAssertions.add(W3CAddressingMetadataConstants.WSAM_ANONYMOUS_NESTED_ASSERTION);
        supportedAssertions.add(W3CAddressingMetadataConstants.WSAM_NONANONYMOUS_NESTED_ASSERTION);
        LOGGER = PolicyLogger.getLogger(AddressingPolicyValidator.class);
    }
}

