/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component$Identifier;
import net.java.games.input.Component$Identifier$Axis;
import net.java.games.input.Controller$Type;
import net.java.games.input.LinuxAbsInfo;
import net.java.games.input.LinuxAxisDescriptor;
import net.java.games.input.LinuxEventDevice;
import net.java.games.input.LinuxNativeTypesMap;

final class LinuxEventComponent {
    private final LinuxEventDevice device;
    private final Component$Identifier identifier;
    private final Controller$Type button_trait;
    private final boolean is_relative;
    private final LinuxAxisDescriptor descriptor;
    private final int min;
    private final int max;
    private final int flat;
    static final boolean $assertionsDisabled = !(class$net$java$games$input$LinuxEventComponent == null ? (class$net$java$games$input$LinuxEventComponent = LinuxEventComponent.class$("net.java.games.input.LinuxEventComponent")) : class$net$java$games$input$LinuxEventComponent).desiredAssertionStatus();
    static Class class$net$java$games$input$LinuxEventComponent;

    public LinuxEventComponent(LinuxEventDevice linuxEventDevice, Component$Identifier component$Identifier, boolean bl2, int n2, int n3) {
        this.device = linuxEventDevice;
        this.identifier = component$Identifier;
        this.button_trait = n2 == 1 ? LinuxNativeTypesMap.guessButtonTrait(n3) : Controller$Type.UNKNOWN;
        this.is_relative = bl2;
        this.descriptor = new LinuxAxisDescriptor();
        this.descriptor.set(n2, n3);
        if (n2 == 3) {
            LinuxAbsInfo linuxAbsInfo = new LinuxAbsInfo();
            this.getAbsInfo(linuxAbsInfo);
            this.min = linuxAbsInfo.getMin();
            this.max = linuxAbsInfo.getMax();
            this.flat = linuxAbsInfo.getFlat();
        } else {
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
            this.flat = 0;
        }
    }

    public final LinuxEventDevice getDevice() {
        return this.device;
    }

    public final void getAbsInfo(LinuxAbsInfo linuxAbsInfo) {
        if (!$assertionsDisabled && this.descriptor.getType() != 3) {
            throw new AssertionError();
        }
        this.device.getAbsInfo(this.descriptor.getCode(), linuxAbsInfo);
    }

    public final Controller$Type getButtonTrait() {
        return this.button_trait;
    }

    public final Component$Identifier getIdentifier() {
        return this.identifier;
    }

    public final LinuxAxisDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final boolean isRelative() {
        return this.is_relative;
    }

    public final boolean isAnalog() {
        return this.identifier instanceof Component$Identifier$Axis && this.identifier != Component$Identifier$Axis.POV;
    }

    final float convertValue(float f2) {
        if (this.identifier instanceof Component$Identifier$Axis && !this.is_relative) {
            if (this.min == this.max) {
                return 0.0f;
            }
            if (f2 > (float)this.max) {
                f2 = this.max;
            } else if (f2 < (float)this.min) {
                f2 = this.min;
            }
            return 2.0f * (f2 - (float)this.min) / (float)(this.max - this.min) - 1.0f;
        }
        return f2;
    }

    final float getDeadZone() {
        return (float)this.flat / (2.0f * (float)(this.max - this.min));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

