/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFOA;
import org.eclipse.swt.internal.win32.NMTTDISPINFOW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    WINDOWPOS[] lpwp;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    static final int TOOLTIP_LIMIT = 4096;

    Composite() {
    }

    public Composite(Composite composite, int n2) {
        super(composite, n2);
    }

    Control[] _getChildren() {
        Control[] controlArray;
        int n2 = 0;
        int n3 = OS.GetWindow(this.handle, 5);
        if (n3 == 0) {
            return new Control[0];
        }
        while (n3 != 0) {
            ++n2;
            n3 = OS.GetWindow(n3, 2);
        }
        Control[] controlArray2 = new Control[n2];
        int n4 = 0;
        n3 = OS.GetWindow(this.handle, 5);
        while (n3 != 0) {
            controlArray = this.display.getControl(n3);
            if (controlArray != null && controlArray != this) {
                controlArray2[n4++] = controlArray;
            }
            n3 = OS.GetWindow(n3, 2);
        }
        if (n2 == n4) {
            return controlArray2;
        }
        controlArray = new Control[n4];
        System.arraycopy(controlArray2, 0, controlArray, 0, n4);
        return controlArray;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabList.length; ++i2) {
            if (this.tabList[i2].isDisposed()) continue;
            ++n2;
        }
        if (n2 == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < this.tabList.length; ++i3) {
            if (this.tabList[i3].isDisposed()) continue;
            controlArray[n3++] = this.tabList[i3];
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    public void changed(Control[] controlArray) {
        this.layout(controlArray, 4);
    }

    @Override
    void checkBuffered() {
        if (OS.IsWinCE || (this.state & 2) == 0) {
            super.checkBuffered();
        }
    }

    @Override
    void checkComposited() {
        if ((this.state & 2) != 0 && (this.style & 0x40000000) != 0) {
            int n2 = this.parent.handle;
            int n3 = OS.GetWindowLong(n2, -20);
            OS.SetWindowLong(n2, -20, n3 |= 0x2000000);
        }
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    Widget[] computeTabList() {
        Widget[] widgetArray = super.computeTabList();
        if (widgetArray.length == 0) {
            return widgetArray;
        }
        Control[] controlArray = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            Widget[] widgetArray2 = control.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        return widgetArray;
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        Point point;
        this.display.runSkin();
        if (this.layout != null) {
            if (n2 == -1 || n3 == -1) {
                boolean bl3 = (this.state & 0x40) != 0;
                this.state &= 0xFFFFFFBF;
                point = DPIUtil.autoScaleUp(this.layout.computeSize(this, DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(n3), bl2 |= bl3));
            } else {
                point = new Point(n2, n3);
            }
        } else {
            point = this.minimumSize(n2, n3, bl2);
            if (point.x == 0) {
                point.x = 64;
            }
            if (point.y == 0) {
                point.y = 64;
            }
        }
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.computeTrim(0, 0, DPIUtil.autoScaleDown(point.x), DPIUtil.autoScaleDown(point.y)));
        return new Point(rectangle.width, rectangle.height);
    }

    void copyArea(GC gC, int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        int n6 = gC.handle;
        int n7 = OS.SaveDC(n6);
        OS.IntersectClipRect(n6, 0, 0, n4, n5);
        POINT pOINT = new POINT();
        int n8 = OS.GetParent(this.handle);
        OS.MapWindowPoints(this.handle, n8, pOINT, 1);
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        POINT pOINT2 = new POINT();
        POINT pOINT3 = new POINT();
        OS.SetWindowOrgEx(n6, n2 += pOINT.x - rECT.left, n3 += pOINT.y - rECT.top, pOINT2);
        OS.SetBrushOrgEx(n6, n2, n3, pOINT3);
        int n9 = OS.GetWindowLong(this.handle, -16);
        if ((n9 & 0x10000000) == 0) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
        }
        OS.RedrawWindow(this.handle, null, 0, 384);
        OS.PrintWindow(this.handle, n6, 0);
        if ((n9 & 0x10000000) == 0) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        OS.RestoreDC(n6, n7);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 2;
        if ((this.style & 0x300) == 0 || this.findThemeControl() == this.parent) {
            this.state |= 0x100;
        }
        if ((this.style & 0x40000000) != 0) {
            int n2 = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, n2 |= 0x20);
        }
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0x300) == 0 || this.findThemeControl() == this.parent ? 1 : 0;
    }

    public void drawBackground(GC gC, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        n7 = DPIUtil.autoScaleUp(n7);
        this.drawBackgroundInPixels(gC, n2, n3, n4, n5, n6, n7);
    }

    void drawBackgroundInPixels(GC gC, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n8 = gC.handle;
        int n9 = this.background == -1 ? gC.getBackground().handle : -1;
        this.drawBackground(n8, rECT, n9, n6, n7);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    @Override
    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control2 = controlArray[i2];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length == 0) continue;
            Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
            System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
            System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
            menuArray = menuArray3;
        }
        return menuArray;
    }

    @Override
    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabList.length; ++i2) {
            if (this.tabList[i2] != control) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n2;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            for (int i3 = 0; i3 < this.tabList.length; ++i3) {
                if (this.tabList[i3] == control) continue;
                controlArray[n4++] = this.tabList[i3];
            }
        }
        this.tabList = controlArray;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int n2 = 0;
        int n3 = OS.GetWindow(this.handle, 5);
        while (n3 != 0) {
            ++n2;
            n3 = OS.GetWindow(n3, 2);
        }
        return n2;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n2;
            int n3 = 0;
            Control[] controlArray2 = this._getChildren();
            for (n2 = 0; n2 < controlArray2.length; ++n2) {
                if (!controlArray2[n2].isTabGroup()) continue;
                ++n3;
            }
            controlArray = new Control[n3];
            n2 = 0;
            for (int i2 = 0; i2 < controlArray2.length; ++i2) {
                if (!controlArray2[i2].isTabGroup()) continue;
                controlArray[n2++] = controlArray2[i2];
            }
        }
        return controlArray;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl2) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl2, false);
    }

    public void layout(boolean bl2, boolean bl3) {
        this.checkWidget();
        if (this.layout == null && !bl3) {
            return;
        }
        this.markLayout(bl2, bl3);
        this.updateLayout(bl3);
    }

    public void layout(Control[] controlArray) {
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        this.layout(controlArray, 0);
    }

    public void layout(Control[] controlArray, int n2) {
        this.checkWidget();
        if (controlArray != null) {
            Control control;
            int n3;
            Composite[] compositeArray;
            int n4;
            for (n4 = 0; n4 < controlArray.length; ++n4) {
                compositeArray = controlArray[n4];
                if (compositeArray == null) {
                    this.error(5);
                }
                if (compositeArray.isDisposed()) {
                    this.error(5);
                }
                n3 = 0;
                control = compositeArray.parent;
                while (control != null) {
                    int n5 = n3 = control == this ? 1 : 0;
                    if (n3 != 0) break;
                    control = ((Composite)control).parent;
                }
                if (n3 != 0) continue;
                this.error(32);
            }
            n4 = 0;
            compositeArray = new Composite[16];
            for (n3 = 0; n3 < controlArray.length; ++n3) {
                control = controlArray[n3];
                Composite composite = control.parent;
                control.markLayout(false, false);
                while (control != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x20;
                        if (!composite.layout.flushCache(control)) {
                            composite.state |= 0x40;
                        }
                    }
                    if (n4 == compositeArray.length) {
                        Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                        System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                        compositeArray = compositeArray2;
                    }
                    int n6 = n4++;
                    Composite composite2 = composite;
                    compositeArray[n6] = composite2;
                    control = composite2;
                    composite = control.parent;
                }
            }
            if ((n2 & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                compositeArray[n3].updateLayout(false);
            }
        } else {
            if (this.layout == null && (n2 & 1) == 0) {
                return;
            }
            this.markLayout((n2 & 2) != 0, (n2 & 1) != 0);
            if ((n2 & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((n2 & 1) != 0);
        }
    }

    @Override
    void markLayout(boolean bl2, boolean bl3) {
        if (this.layout != null) {
            this.state |= 0x20;
            if (bl2) {
                this.state |= 0x40;
            }
        }
        if (bl3) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                controlArray[i2].markLayout(bl2, bl3);
            }
        }
    }

    Point minimumSize(int n2, int n3, boolean bl2) {
        Control[] controlArray = this._getChildren();
        Rectangle rectangle = DPIUtil.autoScaleUp(this.getClientArea());
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Rectangle rectangle2 = DPIUtil.autoScaleUp(controlArray[i2].getBounds());
            n4 = Math.max(n4, rectangle2.x - rectangle.x + rectangle2.width);
            n5 = Math.max(n5, rectangle2.y - rectangle.y + rectangle2.height);
        }
        return new Point(n4, n5);
    }

    @Override
    boolean redrawChildren() {
        if (!super.redrawChildren()) {
            return false;
        }
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].redrawChildren();
        }
        return true;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if ((this.state & 2) != 0 && (this.style & 0x40000000) != 0) {
            int n2;
            int n3 = this.parent.handle;
            int n4 = OS.GetWindow(n3, 5);
            while (n4 != 0) {
                if (n4 != this.handle && ((n2 = OS.GetWindowLong(n3, -20)) & 0x20) != 0) {
                    return;
                }
                n4 = OS.GetWindow(n4, 2);
            }
            n2 = OS.GetWindowLong(n3, -20);
            OS.SetWindowLong(n3, -20, n2 &= 0xFDFFFFFF);
        }
    }

    @Override
    void releaseChildren(boolean bl2) {
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (control == null || control.isDisposed()) continue;
            control.release(false);
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseWidget() {
        int n2;
        int n3;
        super.releaseWidget();
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0 && (n3 = OS.GetWindow(this.handle, 5)) != 0 && (n2 = OS.GetWindowThreadProcessId(n3, null)) != OS.GetCurrentThreadId()) {
            OS.ShowWindow(n3, 0);
            OS.SetParent(n3, 0);
        }
        this.layout = null;
        this.tabList = null;
        this.lpwp = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
        this.resizeChildren();
    }

    @Override
    void reskinChildren(int n2) {
        super.reskinChildren(n2);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (control == null) continue;
            control.reskin(n2);
        }
    }

    void resizeChildren() {
        if (this.lpwp == null) {
            return;
        }
        do {
            WINDOWPOS[] wINDOWPOSArray = this.lpwp;
            this.lpwp = null;
            if (this.resizeChildren(true, wINDOWPOSArray)) continue;
            this.resizeChildren(false, wINDOWPOSArray);
        } while (this.lpwp != null);
    }

    boolean resizeChildren(boolean bl2, WINDOWPOS[] wINDOWPOSArray) {
        if (wINDOWPOSArray == null) {
            return true;
        }
        int n2 = 0;
        if (bl2 && (n2 = OS.BeginDeferWindowPos(wINDOWPOSArray.length)) == 0) {
            return false;
        }
        for (int i2 = 0; i2 < wINDOWPOSArray.length; ++i2) {
            WINDOWPOS wINDOWPOS = wINDOWPOSArray[i2];
            if (wINDOWPOS == null) continue;
            if (bl2) {
                if ((n2 = this.DeferWindowPos(n2, wINDOWPOS.hwnd, 0, wINDOWPOS.x, wINDOWPOS.y, wINDOWPOS.cx, wINDOWPOS.cy, wINDOWPOS.flags)) != 0) continue;
                return false;
            }
            this.SetWindowPos(wINDOWPOS.hwnd, 0, wINDOWPOS.x, wINDOWPOS.y, wINDOWPOS.cx, wINDOWPOS.cy, wINDOWPOS.flags);
        }
        if (bl2) {
            return OS.EndDeferWindowPos(n2);
        }
        return true;
    }

    void resizeEmbeddedHandle(int n2, int n3, int n4) {
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int n5 = OS.GetWindowThreadProcessId(n2, nArray);
        if (n5 != OS.GetCurrentThreadId()) {
            if (nArray[0] == OS.GetCurrentProcessId() && this.display.msgHook == 0 && !OS.IsWinCE) {
                this.display.getMsgCallback = new Callback(this.display, "getMsgProc", 3);
                this.display.getMsgProc = this.display.getMsgCallback.getAddress();
                if (this.display.getMsgProc == 0) {
                    this.error(3);
                }
                this.display.msgHook = OS.SetWindowsHookEx(3, this.display.getMsgProc, OS.GetLibraryHandle(), n5);
                OS.PostThreadMessage(n5, 0, 0, 0);
            }
            int n6 = 16436;
            OS.SetWindowPos(n2, 0, 0, 0, n3, n4, n6);
        }
    }

    @Override
    void sendResize() {
        this.setResizeChildren(false);
        super.sendResize();
        if (this.isDisposed()) {
            return;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false, false);
        }
        this.setResizeChildren(true);
    }

    public void setBackgroundMode(int n2) {
        this.checkWidget();
        this.backgroundMode = n2;
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].updateBackgroundMode();
        }
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        if (this.display.resizeCount > 4) {
            bl2 = false;
        }
        if (!bl2 && (this.state & 2) != 0) {
            this.state &= 0xFFFAFFFF;
            this.state |= 0xA0000;
        }
        super.setBoundsInPixels(n2, n3, n4, n5, n6, bl2);
        if (!bl2 && (this.state & 2) != 0) {
            boolean bl3 = (this.state & 0x10000) != 0;
            boolean bl4 = (this.state & 0x40000) != 0;
            this.state &= 0xFFF5FFFF;
            if (bl3 && !this.isDisposed()) {
                this.sendMove();
            }
            if (bl4 && !this.isDisposed()) {
                this.sendResize();
            }
        }
    }

    @Override
    public boolean setFocus() {
        Control control;
        int n2;
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.setRadioFocus(false)) continue;
            return true;
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl2) {
        this.checkWidget();
        if (!bl2) {
            if (--this.layoutCount == 0 && ((this.state & 0x80) != 0 || (this.state & 0x20) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    void setResizeChildren(boolean bl2) {
        if (bl2) {
            this.resizeChildren();
        } else {
            if (this.display.resizeCount > 4) {
                return;
            }
            int n2 = this.getChildrenCount();
            if (n2 > 1 && this.lpwp == null) {
                this.lpwp = new WINDOWPOS[n2];
            }
        }
    }

    @Override
    boolean setTabGroupFocus() {
        Control control;
        int n2;
        boolean bl2;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl3 = bl2 = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl2 = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                bl2 = true;
            }
        }
        if (bl2 && this.setTabItemFocus()) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.isTabItem() || !control.setRadioFocus(true)) continue;
            return true;
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.isTabItem() || control.isTabGroup() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean updateTextDirection(int n2) {
        super.updateTextDirection(n2);
        Control[] controlArray = this._getChildren();
        int n3 = controlArray.length;
        while (n3-- > 0) {
            if (controlArray[n3] == null || controlArray[n3].isDisposed()) continue;
            controlArray[n3].updateTextDirection(n2);
        }
        return true;
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        Shell shell = this.getShell();
        if ((nMTTDISPINFO.uFlags & 1) == 0) {
            String string = null;
            ToolTip toolTip = shell.findToolTip(nMTTDISPINFO.idFrom);
            if (toolTip != null) {
                string = toolTip.message;
                if (string == null || string.length() == 0) {
                    string = " ";
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && string.length() > 1024) {
                    string = this.display.wrapText(string, this.handle, toolTip.getWidth());
                }
            }
            return string;
        }
        shell.setToolTipTitle(nMTTDISPINFO.hwndFrom, null, 0);
        OS.SendMessage(nMTTDISPINFO.hwndFrom, 1048, 0, Short.MAX_VALUE);
        Control control = this.display.getControl(nMTTDISPINFO.idFrom);
        return control != null ? control.toolTipText : null;
    }

    @Override
    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control2 = controlArray[i2];
                if (!control2.translateMnemonic(event, control)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    boolean translateTraversal(MSG mSG) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x1000000) != 0) {
                return false;
            }
            switch (mSG.wParam) {
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    int n2 = OS.SendMessage(mSG.hwnd, 297, 0, 0);
                    if ((n2 & 1) == 0) break;
                    OS.SendMessage(mSG.hwnd, 296, OS.MAKEWPARAM(2, 1), 0);
                }
            }
        }
        return super.translateTraversal(mSG);
    }

    @Override
    void updateBackgroundColor() {
        super.updateBackgroundColor();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if ((controlArray[i2].state & 0x400) == 0) continue;
            controlArray[i2].updateBackgroundColor();
        }
    }

    @Override
    void updateBackgroundImage() {
        super.updateBackgroundImage();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if ((controlArray[i2].state & 0x400) == 0) continue;
            controlArray[i2].updateBackgroundImage();
        }
    }

    @Override
    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].updateBackgroundMode();
        }
    }

    @Override
    void updateFont(Font font, Font font2) {
        super.updateFont(font, font2);
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (control.isDisposed()) continue;
            control.updateFont(font, font2);
        }
    }

    void updateLayout(boolean bl2) {
        this.updateLayout(true, bl2);
    }

    @Override
    void updateLayout(boolean bl2, boolean bl3) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x80;
            return;
        }
        if ((this.state & 0x20) != 0) {
            boolean bl4 = (this.state & 0x40) != 0;
            this.state &= 0xFFFFFF9F;
            this.display.runSkin();
            if (bl2) {
                this.setResizeChildren(false);
            }
            this.layout.layout(this, bl4);
            if (bl2) {
                this.setResizeChildren(true);
            }
        }
        if (bl3) {
            this.state &= 0xFFFFFF7F;
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                controlArray[i2].updateLayout(bl2, bl3);
            }
        }
    }

    @Override
    void updateOrientation() {
        Object object;
        int n2;
        Control[] controlArray = this._getChildren();
        RECT[] rECTArray = new RECT[controlArray.length];
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            Control control = controlArray[n2];
            rECTArray[n2] = new RECT();
            object = rECTArray[n2];
            control.forceResize();
            OS.GetWindowRect(control.topHandle(), (RECT)object);
            OS.MapWindowPoints(0, this.handle, (RECT)object, 2);
        }
        n2 = this.style & 0x6000000;
        super.updateOrientation();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            object = controlArray[i2];
            RECT rECT = rECTArray[i2];
            ((Control)object).setOrientation(n2);
            int n3 = 21;
            this.SetWindowPos(((Control)object).topHandle(), 0, rECT.left, rECT.top, 0, 0, n3);
        }
    }

    void updateUIState() {
        int n2 = this.getShell().handle;
        int n3 = OS.SendMessage(n2, 297, 0, 0);
        if ((n3 & 1) != 0) {
            OS.SendMessage(n2, 295, OS.MAKEWPARAM(2, 1), 0);
        }
    }

    @Override
    int widgetStyle() {
        return super.widgetStyle() | 0x2000000;
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.state & 2) != 0 && (this.style & 0x40040000) != 0) {
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.state & 2) != 0) {
            int n4 = 0;
            if (this.hooksKeys()) {
                n4 |= 7;
            }
            if ((this.style & 0x80000) != 0) {
                n4 |= 0x100;
            }
            if (OS.GetWindow(this.handle, 5) != 0) {
                n4 |= 0x100;
            }
            if (n4 != 0) {
                return new LRESULT(n4);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETFONT(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETFONT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = this.callWindowProc(this.handle, 49, n2, n3);
        if (n4 != 0) {
            return new LRESULT(n4);
        }
        return new LRESULT(this.font != null ? this.font.handle : this.defaultFont());
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys() && OS.GetWindow(this.handle, 5) == 0) {
            this.setFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_NCHITTEST(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCHITTEST(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.state & 2) != 0) {
            int n4 = this.callWindowProc(this.handle, 132, n2, n3);
            if (n4 == 1) {
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                POINT pOINT = new POINT();
                pOINT.x = OS.GET_X_LPARAM(n3);
                pOINT.y = OS.GET_Y_LPARAM(n3);
                OS.MapWindowPoints(0, this.handle, pOINT, 1);
                if (!OS.PtInRect(rECT, pOINT)) {
                    int n5 = 1025;
                    OS.RedrawWindow(this.handle, null, 0, n5);
                }
            }
            return new LRESULT(n4);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_PARENTNOTIFY(int n2, int n3) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0 && OS.LOWORD(n2) == 1) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.resizeEmbeddedHandle(n3, rECT.right - rECT.left, rECT.bottom - rECT.top);
        }
        return super.WM_PARENTNOTIFY(n2, n3);
    }

    @Override
    LRESULT WM_PAINT(int n2, int n3) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        if ((this.state & 2) == 0 || (this.state & 0x4000) != 0) {
            return super.WM_PAINT(n2, n3);
        }
        int n4 = 0;
        int n5 = 0;
        if (!OS.IsWinCE && (n5 = (n4 = OS.GetWindowLong(this.handle, -16)) | 0x4000000 | 0x2000000) != n4) {
            OS.SetWindowLong(this.handle, -16, n5);
        }
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        if (this.hooks(9) || this.filters(9)) {
            boolean bl2 = false;
            if ((this.style & 0x20000000) != 0 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (this.style & 0x4200000) == 0 && (this.style & 0x40000000) == 0) {
                bl2 = true;
            }
            if (bl2) {
                int n6 = OS.BeginPaint(this.handle, pAINTSTRUCT);
                int n7 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n8 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n7 != 0 && n8 != 0) {
                    Object object;
                    int[] nArray = new int[1];
                    int n9 = 0;
                    RECT rECT = new RECT();
                    OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                    int n10 = OS.BeginBufferedPaint(n6, rECT, n9, null, nArray);
                    GCData gCData = new GCData();
                    gCData.device = this.display;
                    gCData.foreground = this.getForegroundPixel();
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    gCData.background = control.getBackgroundPixel();
                    gCData.font = Font.win32_new(this.display, OS.SendMessage(this.handle, 49, 0, 0));
                    gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
                    if ((this.style & 0x40000) == 0) {
                        object = new RECT();
                        OS.SetRect((RECT)object, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                        this.drawBackground(nArray[0], (RECT)object);
                    }
                    object = GC.win32_new(nArray[0], gCData);
                    Event event = new Event();
                    event.gc = object;
                    event.setBoundsInPixels(new Rectangle(pAINTSTRUCT.left, pAINTSTRUCT.top, n7, n8));
                    this.sendEvent(9, event);
                    if (gCData.focusDrawn && !this.isDisposed()) {
                        this.updateUIState();
                    }
                    ((Resource)object).dispose();
                    OS.EndBufferedPaint(n10, true);
                }
                OS.EndPaint(this.handle, pAINTSTRUCT);
            } else {
                GCData gCData = new GCData();
                gCData.ps = pAINTSTRUCT;
                gCData.hwnd = this.handle;
                GC gC = GC.win32_new(this, gCData);
                int n11 = 0;
                if (((this.style & 0x60000000) != 0 || (this.style & 0x200000) != 0) && OS.GetRandomRgn(gC.handle, n11 = OS.CreateRectRgn(0, 0, 0, 0), 4) == 1) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (OS.GetLayout(gC.handle) & 1) != 0) {
                        int n12 = OS.GetRegionData(n11, 0, null);
                        int[] nArray = new int[n12 / 4];
                        OS.GetRegionData(n11, n12, nArray);
                        int n13 = OS.ExtCreateRegion(new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, n12, nArray);
                        OS.DeleteObject(n11);
                        n11 = n13;
                    }
                    if (OS.IsWinNT) {
                        POINT pOINT = new POINT();
                        OS.MapWindowPoints(0, this.handle, pOINT, 1);
                        OS.OffsetRgn(n11, pOINT.x, pOINT.y);
                    }
                }
                int n14 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n15 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n14 != 0 && n15 != 0) {
                    RECT rECT;
                    Object object;
                    GC gC2 = null;
                    Image image = null;
                    if ((this.style & 0x60000000) != 0) {
                        image = new Image((Device)this.display, n14, n15);
                        gC2 = gC;
                        gC = new GC(image, gC2.getStyle() & 0x4000000);
                        object = gC.getGCData();
                        ((GCData)object).uiState = gCData.uiState;
                        gC.setForeground(this.getForeground());
                        gC.setBackground(this.getBackground());
                        gC.setFont(this.getFont());
                        if ((this.style & 0x40000000) != 0) {
                            OS.BitBlt(gC.handle, 0, 0, n14, n15, gC2.handle, pAINTSTRUCT.left, pAINTSTRUCT.top, 0xCC0020);
                        }
                        OS.OffsetRgn(n11, -pAINTSTRUCT.left, -pAINTSTRUCT.top);
                        OS.SelectClipRgn(gC.handle, n11);
                        OS.OffsetRgn(n11, pAINTSTRUCT.left, pAINTSTRUCT.top);
                        OS.SetMetaRgn(gC.handle);
                        OS.SetWindowOrgEx(gC.handle, pAINTSTRUCT.left, pAINTSTRUCT.top, null);
                        OS.SetBrushOrgEx(gC.handle, pAINTSTRUCT.left, pAINTSTRUCT.top, null);
                        if ((this.style & 0x40040000) == 0) {
                            rECT = new RECT();
                            OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                            this.drawBackground(gC.handle, rECT);
                        }
                    }
                    object = new Event();
                    ((Event)object).gc = gC;
                    rECT = null;
                    if ((this.style & 0x200000) != 0 && OS.GetRgnBox(n11, rECT = new RECT()) == 3) {
                        int n16 = OS.GetRegionData(n11, 0, null);
                        int[] nArray = new int[n16 / 4];
                        OS.GetRegionData(n11, n16, nArray);
                        int n17 = nArray[2];
                        for (int i2 = 0; i2 < n17; ++i2) {
                            int n18 = 8 + (i2 << 2);
                            OS.SetRect(rECT, nArray[n18], nArray[n18 + 1], nArray[n18 + 2], nArray[n18 + 3]);
                            if ((this.style & 0x60040000) == 0) {
                                this.drawBackground(gC.handle, rECT);
                            }
                            ((Event)object).setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
                            ((Event)object).count = n17 - 1 - i2;
                            this.sendEvent(9, (Event)object);
                        }
                    } else {
                        if ((this.style & 0x60040000) == 0) {
                            if (rECT == null) {
                                rECT = new RECT();
                            }
                            OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                            this.drawBackground(gC.handle, rECT);
                        }
                        ((Event)object).setBoundsInPixels(new Rectangle(pAINTSTRUCT.left, pAINTSTRUCT.top, n14, n15));
                        this.sendEvent(9, (Event)object);
                    }
                    ((Event)object).gc = null;
                    if ((this.style & 0x60000000) != 0) {
                        if (!gC.isDisposed()) {
                            GCData gCData2 = gC.getGCData();
                            if (gCData2.focusDrawn && !this.isDisposed()) {
                                this.updateUIState();
                            }
                        }
                        gC.dispose();
                        if (!this.isDisposed()) {
                            gC2.drawImage(image, DPIUtil.autoScaleDown(pAINTSTRUCT.left), DPIUtil.autoScaleDown(pAINTSTRUCT.top));
                        }
                        image.dispose();
                        gC = gC2;
                    }
                }
                if (n11 != 0) {
                    OS.DeleteObject(n11);
                }
                if (gCData.focusDrawn && !this.isDisposed()) {
                    this.updateUIState();
                }
                gC.dispose();
            }
        } else {
            int n19 = OS.BeginPaint(this.handle, pAINTSTRUCT);
            if ((this.style & 0x40040000) == 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawBackground(n19, rECT);
            }
            OS.EndPaint(this.handle, pAINTSTRUCT);
        }
        if (!(OS.IsWinCE || this.isDisposed() || n5 == n4 || this.isDisposed())) {
            OS.SetWindowLong(this.handle, -16, n4);
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PRINTCLIENT(int n2, int n3) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.state & 2) != 0) {
            this.forceResize();
            int n4 = OS.SaveDC(n2);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if ((this.style & 0x40040000) == 0) {
                this.drawBackground(n2, rECT);
            }
            if (this.hooks(9) || this.filters(9)) {
                GCData gCData = new GCData();
                gCData.device = this.display;
                gCData.foreground = this.getForegroundPixel();
                Control control = this.findBackgroundControl();
                if (control == null) {
                    control = this;
                }
                gCData.background = control.getBackgroundPixel();
                gCData.font = Font.win32_new(this.display, OS.SendMessage(this.handle, 49, 0, 0));
                gCData.uiState = OS.SendMessage(this.handle, 297, 0, 0);
                GC gC = GC.win32_new(n2, gCData);
                Event event = new Event();
                event.gc = gC;
                event.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
                this.sendEvent(9, event);
                event.gc = null;
                gC.dispose();
            }
            OS.RestoreDC(n2, n4);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFONT(int n2, int n3) {
        if (n3 != 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
        return super.WM_SETFONT(n2, n3);
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = null;
        if ((this.state & 0x80000) != 0) {
            lRESULT = super.WM_SIZE(n2, n3);
        } else {
            this.setResizeChildren(false);
            lRESULT = super.WM_SIZE(n2, n3);
            if (this.isDisposed()) {
                return lRESULT;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false, false);
            }
            this.setResizeChildren(true);
        }
        if (OS.IsWindowVisible(this.handle)) {
            if ((this.state & 2) != 0 && (this.style & 0x100000) == 0 && this.hooks(9)) {
                OS.InvalidateRect(this.handle, null, true);
            }
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
                this.redrawChildren();
            }
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.resizeEmbeddedHandle(OS.GetWindow(this.handle, 5), OS.LOWORD(n3), OS.HIWORD(n3));
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SYSCOLORCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = OS.GetWindow(this.handle, 5);
        while (n4 != 0) {
            OS.SendMessage(n4, 21, 0, 0);
            n4 = OS.GetWindow(n4, 2);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SYSCOMMAND(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOMMAND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((n2 & 0xF000) == 0) {
            return lRESULT;
        }
        if (!OS.IsWinCE) {
            int n4 = n2 & 0xFFF0;
            switch (n4) {
                case 61552: 
                case 61568: {
                    boolean bl2 = this.horizontalBar != null && this.horizontalBar.getVisible();
                    boolean bl3 = this.verticalBar != null && this.verticalBar.getVisible();
                    int n5 = this.callWindowProc(this.handle, 274, n2, n3);
                    if (bl2 != (this.horizontalBar != null && this.horizontalBar.getVisible()) || bl3 != (this.verticalBar != null && this.verticalBar.getVisible())) {
                        int n6 = 1281;
                        OS.RedrawWindow(this.handle, null, 0, n6);
                    }
                    if (n5 == 0) {
                        return LRESULT.ZERO;
                    }
                    return new LRESULT(n5);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(int n2, int n3) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.state & 2) != 0 && this.hooks(9)) {
            OS.InvalidateRect(this.handle, null, true);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNCPaint(int n2, int n3, int n4) {
        int n5;
        LRESULT lRESULT = super.wmNCPaint(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n6 = this.borderHandle();
        if (((this.state & 2) != 0 || n2 == n6 && this.handle != n6) && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && ((n5 = OS.GetWindowLong(n2, -20)) & 0x200) != 0) {
            int n7 = 0;
            int n8 = OS.GetWindowLong(n2, -16);
            if ((n8 & 0x300000) != 0) {
                n7 = this.callWindowProc(n2, 133, n3, n4);
            }
            int n9 = OS.GetWindowDC(n2);
            RECT rECT = new RECT();
            OS.GetWindowRect(n2, rECT);
            rECT.right -= rECT.left;
            rECT.bottom -= rECT.top;
            rECT.top = 0;
            rECT.left = 0;
            int n10 = OS.GetSystemMetrics(45);
            OS.ExcludeClipRect(n9, n10, n10, rECT.right - n10, rECT.bottom - n10);
            OS.DrawThemeBackground(this.display.hEditTheme(), n9, 1, 1, rECT, null);
            OS.ReleaseDC(n2, n9);
            return new LRESULT(n7);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNotify(NMHDR nMHDR, int n2, int n3) {
        if (!OS.IsWinCE) {
            switch (nMHDR.code) {
                case -522: 
                case -521: {
                    int n4;
                    int n5 = nMHDR.hwndFrom;
                    while ((n5 = OS.GetParent(n5)) != 0 && ((n4 = OS.GetWindowLong(n5, -20)) & 8) == 0) {
                    }
                    if (n5 != 0) break;
                    if (this.display.getActiveShell() == null) {
                        return LRESULT.ONE;
                    }
                    this.display.lockActiveWindow = true;
                    n4 = 19;
                    int n6 = nMHDR.code == -521 ? -1 : -2;
                    this.SetWindowPos(nMHDR.hwndFrom, n6, 0, 0, 0, 0, n4);
                    this.display.lockActiveWindow = false;
                    break;
                }
                case -530: 
                case -520: {
                    NMTTDISPINFO nMTTDISPINFO;
                    if (nMHDR.code == -520) {
                        nMTTDISPINFO = new NMTTDISPINFOA();
                        OS.MoveMemory(nMTTDISPINFO, n3, NMTTDISPINFOA.sizeof);
                    } else {
                        nMTTDISPINFO = new NMTTDISPINFOW();
                        OS.MoveMemory((NMTTDISPINFOW)nMTTDISPINFO, n3, NMTTDISPINFOW.sizeof);
                    }
                    String string = this.toolTipText(nMTTDISPINFO);
                    if (string == null) break;
                    Shell shell = this.getShell();
                    string = Display.withCrLf(string);
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && string.length() > 4096) {
                        string = string.substring(0, 4096);
                    }
                    char[] cArray = this.fixMnemonic(string);
                    Widget widget = null;
                    int n7 = nMHDR.idFrom;
                    if ((nMTTDISPINFO.uFlags & 1) != 0) {
                        widget = this.display.getControl(n7);
                    } else if (nMHDR.hwndFrom == shell.toolTipHandle || nMHDR.hwndFrom == shell.balloonTipHandle) {
                        widget = shell.findToolTip(nMHDR.idFrom);
                    }
                    if (widget != null) {
                        int n8;
                        int n9 = widget.getStyle();
                        nMTTDISPINFO.uFlags = (n9 & (n8 = -2080374784)) != 0 && (n9 & n8) != n8 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
                    }
                    if (nMHDR.code == -520) {
                        byte[] byArray = new byte[cArray.length * 2];
                        OS.WideCharToMultiByte(this.getCodePage(), 0, cArray, cArray.length, byArray, byArray.length, null, null);
                        shell.setToolTipText(nMTTDISPINFO, byArray);
                        OS.MoveMemory(n3, nMTTDISPINFO, NMTTDISPINFOA.sizeof);
                    } else {
                        shell.setToolTipText(nMTTDISPINFO, cArray);
                        OS.MoveMemory(n3, (NMTTDISPINFOW)nMTTDISPINFO, NMTTDISPINFOW.sizeof);
                    }
                    return LRESULT.ZERO;
                }
            }
        }
        return super.wmNotify(nMHDR, n2, n3);
    }
}

