/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.EpollData$Buffer;

public class EpollData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int FD;
    public static final int U32;
    public static final int U64;

    protected EpollData(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected EpollData create(long l2, ByteBuffer byteBuffer) {
        return new EpollData(l2, byteBuffer);
    }

    public EpollData(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), EpollData.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long ptr() {
        return EpollData.nptr(this.address());
    }

    public int fd() {
        return EpollData.nfd(this.address());
    }

    public int u32() {
        return EpollData.nu32(this.address());
    }

    public long u64() {
        return EpollData.nu64(this.address());
    }

    public EpollData ptr(long l2) {
        EpollData.nptr(this.address(), l2);
        return this;
    }

    public EpollData fd(int n2) {
        EpollData.nfd(this.address(), n2);
        return this;
    }

    public EpollData u32(int n2) {
        EpollData.nu32(this.address(), n2);
        return this;
    }

    public EpollData u64(long l2) {
        EpollData.nu64(this.address(), l2);
        return this;
    }

    public EpollData set(EpollData epollData) {
        MemoryUtil.memCopy(epollData.address(), this.address(), SIZEOF);
        return this;
    }

    public static EpollData malloc() {
        return new EpollData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static EpollData calloc() {
        return new EpollData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static EpollData create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new EpollData(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static EpollData create(long l2) {
        return new EpollData(l2, null);
    }

    public static EpollData createSafe(long l2) {
        return l2 == 0L ? null : new EpollData(l2, null);
    }

    public static EpollData$Buffer malloc(int n2) {
        return new EpollData$Buffer(MemoryUtil.nmemAllocChecked(EpollData.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static EpollData$Buffer calloc(int n2) {
        return new EpollData$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static EpollData$Buffer create(int n2) {
        ByteBuffer byteBuffer = EpollData.__create(n2, SIZEOF);
        return new EpollData$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static EpollData$Buffer create(long l2, int n2) {
        return new EpollData$Buffer(l2, n2);
    }

    public static EpollData$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new EpollData$Buffer(l2, n2);
    }

    public static EpollData malloc(MemoryStack memoryStack) {
        return new EpollData(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EpollData calloc(MemoryStack memoryStack) {
        return new EpollData(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static EpollData$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new EpollData$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static EpollData$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new EpollData$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nptr(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)PTR);
    }

    public static int nfd(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FD);
    }

    public static int nu32(long l2) {
        return UNSAFE.getInt(null, l2 + (long)U32);
    }

    public static long nu64(long l2) {
        return UNSAFE.getLong(null, l2 + (long)U64);
    }

    public static void nptr(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)PTR, Checks.check(l3));
    }

    public static void nfd(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FD, n2);
    }

    public static void nu32(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)U32, n2);
    }

    public static void nu64(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)U64, l3);
    }

    static {
        Struct$Layout struct$Layout = EpollData.__union(EpollData.__member(POINTER_SIZE), EpollData.__member(4), EpollData.__member(4), EpollData.__member(8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        PTR = struct$Layout.offsetof(0);
        FD = struct$Layout.offsetof(1);
        U32 = struct$Layout.offsetof(2);
        U64 = struct$Layout.offsetof(3);
    }
}

