/*
 * Decompiled with CFR 0.152.
 */
package org.pigler.api;

import com.nokia.mid.ui.DirectUtils;
import com.nokia.mj.impl.rt.legacy.LegacyRtPort;
import com.nokia.mj.impl.rt.legacy.MIDEventServer;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import javax.microedition.lcdui.Image;
import org.pigler.api.IPiglerTapHandler;
import org.pigler.api.ImageUtils;
import org.pigler.api.PiglerException;

public final class PiglerAPI {
    private static final MIDEventServer eventServer;
    private Finalizer finalizer = this.registerFinalize();
    private int eventSourceHandle = this._createEventSource(eventServer.getHandle());
    private int apiHandle = this._createAPI(this.eventSourceHandle);
    private boolean closed;
    private IPiglerTapHandler listener;
    private boolean initialized;
    private String appName;

    static {
        try {
            Jvm.loadSystemLibrary((String)"piglerjavaapi");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        eventServer = new MIDEventServer("java-piglerapi");
    }

    public int init() throws Exception {
        String appName;
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.appName = appName = "JavaApp_" + Integer.toHexString(LegacyRtPort.getMidletUid());
        int res = this._init(this.eventSourceHandle, this.apiHandle, LegacyRtPort.getMidletUid(), appName);
        if (res < 0) {
            throw new PiglerException("Init error: " + res);
        }
        this.initialized = true;
        return res;
    }

    public int init(String appName) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (appName == null) {
            throw new NullPointerException("appName");
        }
        if (appName.length() > 63) {
            appName = appName.substring(0, 63);
        }
        this.appName = appName;
        int res = this._init(this.eventSourceHandle, this.apiHandle, LegacyRtPort.getMidletUid(), appName);
        if (res < 0) {
            throw new PiglerException("Init error: " + res);
        }
        this.initialized = true;
        return res;
    }

    public int getAPIVersion() throws Exception {
        this.checkClosed();
        return this._getAPIVersion(this.eventSourceHandle, this.apiHandle);
    }

    public int createNotification(String title, String text, Image icon, boolean removeOnTap) throws Exception {
        int res;
        this.checkClosed();
        if (title == null) {
            title = "";
        }
        if (text == null) {
            text = "";
        }
        if (title.length() > 63) {
            title = title.substring(0, 63);
        }
        if (text.length() > 63) {
            text = text.substring(0, 63);
        }
        if ((res = this._setNotification(this.eventSourceHandle, this.apiHandle, 0, String.valueOf(title) + "\n" + text)) < 0) {
            throw new PiglerException("Create notification error: " + res);
        }
        this._setRemoveNotificationOnTap(this.eventSourceHandle, this.apiHandle, 0, removeOnTap);
        if (icon != null) {
            this.setNotificationIcon(res, icon);
        }
        return res;
    }

    public void updateNotification(int uid, String title, String text, Image icon) throws Exception {
        this.updateNotification(uid, title, text);
        this.updateNotification(uid, icon);
    }

    public void updateNotification(int uid, String title, String text) throws Exception {
        int res;
        if (uid <= 0) {
            throw new IllegalArgumentException();
        }
        this.checkClosed();
        if (title == null) {
            title = "";
        }
        if (text == null) {
            text = "";
        }
        if (title.length() > 63) {
            title = title.substring(0, 63);
        }
        if (text.length() > 63) {
            text = text.substring(0, 63);
        }
        if ((res = this._setNotification(this.eventSourceHandle, this.apiHandle, uid, String.valueOf(title) + "\n" + text)) < 0) {
            throw new PiglerException("Update notification text error:" + res);
        }
    }

    public void updateNotification(int uid, Image icon) throws Exception {
        if (uid <= 0) {
            throw new IllegalArgumentException();
        }
        this.checkClosed();
        if (icon == null) {
            throw new NullPointerException("icon");
        }
        int res = this.setNotificationIcon(uid, icon);
        if (res < 0) {
            throw new PiglerException("Update notification icon error: " + res);
        }
    }

    public void removeNotification(int uid) throws Exception {
        this.checkClosed();
        int res = this._removeNotification(this.eventSourceHandle, this.apiHandle, uid);
        if (res < 0) {
            throw new PiglerException("Remove notification error: " + res);
        }
    }

    public int removeAllNotifications() {
        this.checkClosed();
        return this._removeAllNotifications(this.eventSourceHandle, this.apiHandle);
    }

    public int getLastTappedNotification() {
        this.checkClosed();
        return this._getLastTappedNotification(this.eventSourceHandle, this.apiHandle);
    }

    public void setRemoveNotificationOnTap(int uid, boolean remove) throws Exception {
        this.checkClosed();
        int res = this._setRemoveNotificationOnTap(this.eventSourceHandle, this.apiHandle, uid, remove);
        if (res < 0) {
            throw new PiglerException("Update notification error: " + res);
        }
    }

    public void setLaunchAppOnTap(int uid, boolean launch) throws Exception {
        this.checkClosed();
        int res = this._setLaunchAppOnTap(this.eventSourceHandle, this.apiHandle, uid, launch);
        if (res < 0) {
            throw new PiglerException("Update notification error: " + res);
        }
    }

    public void setListener(IPiglerTapHandler listener) {
        this.listener = listener;
    }

    public void close() {
        if (this.closed || this.apiHandle == 0) {
            return;
        }
        this.closed = true;
        this._close(this.eventSourceHandle, this.apiHandle);
    }

    public String getAppName() {
        return this.appName;
    }

    public int getMaxNotificationsCount() {
        return 100;
    }

    public int getNotificationsCount() {
        this.checkClosed();
        return this._getNotificationsCount(this.eventSourceHandle, this.apiHandle);
    }

    private void checkClosed() {
        if (!this.initialized || this.closed || this.apiHandle == 0) {
            throw new IllegalStateException();
        }
    }

    private void notificationCallback(int uid) {
        if (this.listener != null) {
            this.listener.handleNotificationTap(uid);
        }
    }

    private int setNotificationIcon(int uid, Image icon) {
        if (icon == null) {
            return 0;
        }
        Image scaledIcon = DirectUtils.createImage((int)68, (int)68, (int)0);
        int targetSize = 52;
        int w = icon.getWidth();
        int h = icon.getHeight();
        if (w > 52 || h > 52) {
            icon = w > h ? ImageUtils.resize(icon, 52, 52 * h / w) : ImageUtils.resize(icon, 52 * w / h, 52);
        }
        scaledIcon.getGraphics().drawImage(icon, 68 - icon.getWidth() >> 1, 68 - icon.getHeight() >> 1, 20);
        icon = null;
        int[] rgb = new int[4624];
        scaledIcon.getRGB(rgb, 0, 68, 0, 0, 68, 68);
        return this._setNotificationIcon(this.eventSourceHandle, this.apiHandle, uid, rgb);
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                PiglerAPI.this.close();
                PiglerAPI.this._dispose(PiglerAPI.this.eventSourceHandle, PiglerAPI.this.apiHandle);
                PiglerAPI.this.apiHandle = 0;
                PiglerAPI.this.eventSourceHandle = 0;
            }
        };
    }

    private native int _createEventSource(int var1);

    private native int _createAPI(int var1);

    private native void _dispose(int var1, int var2);

    private native int _initRandom(int var1, int var2, int var3);

    private native int _init(int var1, int var2, int var3, String var4);

    private native int _setNotification(int var1, int var2, int var3, String var4);

    private native int _removeNotification(int var1, int var2, int var3);

    private native int _removeAllNotifications(int var1, int var2);

    private native int _getLastTappedNotification(int var1, int var2);

    private native int _setRemoveNotificationOnTap(int var1, int var2, int var3, boolean var4);

    private native int _setNotificationIcon(int var1, int var2, int var3, int[] var4);

    private native void _close(int var1, int var2);

    private native int _getAPIVersion(int var1, int var2);

    private native int _setLaunchAppOnTap(int var1, int var2, int var3, boolean var4);

    private native int _getNotificationsCount(int var1, int var2);
}

