/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.NPC;
import com.AI.Player;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.Character;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.misc.Asset;
import com.misc.Main;

public abstract class GameObject
extends RoomObject {
    private static Fps fps;
    protected static final Matrix matrix;
    private int frame;
    private int intframe;
    private float friction = 4.0f;
    public final Character character = new Character(0, 0);
    private int hp;
    public long DeathTime = 0L;

    public final void setCharacterSize(int modelHeight) {
        this.character.set((int)((float)modelHeight / 2.5f), (int)((float)modelHeight * 0.75f));
    }

    public final void setCharacterSize(int w, int h) {
        this.character.set(w, h);
    }

    public final void setCharacterSize(int w, int wz, int h) {
        this.character.set(w, wz, h);
    }

    protected final void moveZ(int d) {
        this.character.moveZ(d);
    }

    protected final void jump(int jump, float force) {
        this.character.jump(jump, force);
    }

    public void update(Scene scene, Player player) {
        if (this.character.isUpdatable()) {
            this.character.update();
            this.character.collisionTest(this.getPart(), scene.getHouse());
            if (this.character.isOnFloor() || this.character.fly) {
                Vector3D speed = this.character.getSpeed();
                speed.x = (int)((float)speed.x / this.friction);
                speed.y = (int)((float)speed.y / this.friction);
                speed.z = (int)((float)speed.z / this.friction);
            }
        }
        ++this.frame;
        this.intframe += 20000 / Fps.getFps();
    }

    public boolean damage(GameObject obj, int dmg) {
        return this.damage(dmg);
    }

    public boolean damage(int dmg) {
        boolean oldDead = this.isDead();
        this.hp -= dmg;
        if (this.hp < 0) {
            this.hp = 0;
        }
        if (oldDead != this.isDead()) {
            this.frame = 0;
            this.intframe = 0;
            this.DeathTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public final Character getCharacter() {
        return this.character;
    }

    public final int getHp() {
        return this.hp;
    }

    public final boolean isDead() {
        return this.hp <= 0;
    }

    public boolean isTimeToRenew() {
        if (this instanceof NPC) {
            NPC npc = (NPC)this;
            if (npc.currentSprite != null) {
                if (npc.currentSprite != npc.deathFront && npc.currentSprite != npc.deathSide && npc.currentSprite != npc.deathBack && this.isDead()) {
                    npc.setSprite(npc.deathFront, npc.deathSide, npc.deathBack);
                }
                if ((float)(npc.currentSprite.animationBegin - System.currentTimeMillis()) < (float)(-npc.currentSprite.textures.length * 1000) / npc.currentSprite.animation_speed && (npc.currentSprite == npc.deathFront || npc.currentSprite == npc.deathSide || npc.currentSprite == npc.deathBack)) {
                    return this.isDead();
                }
                return false;
            }
        }
        return this.isDead() && this.frame > 25 * Fps.getFps() / 200;
    }

    public final void setHp(int hpn) {
        this.hp = hpn;
    }

    public final int getFrame() {
        return this.frame;
    }

    public final void setFriction(float f) {
        this.friction = f;
    }

    public final float getFriction() {
        return this.friction;
    }

    public final int getFrameInter() {
        return this.intframe;
    }

    public final int getFrameInterDiv() {
        return this.intframe / 100;
    }

    public final int getPosX() {
        return this.character.getTransform().m03;
    }

    public final int getPosZ() {
        return this.character.getTransform().m23;
    }

    public final int getPosY() {
        return this.character.getTransform().m13;
    }

    public final void setPos(int x, int y, int z) {
        this.character.getTransform().m03 = x;
        this.character.getTransform().m13 = y;
        this.character.getTransform().m23 = z;
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = GameScreen.time;
            }
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }

    static {
        matrix = new Matrix();
    }
}

