/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingPers;
import code.Rendering.Vertex;
import code.utils.Main;

public class ColorLightedPolygon3V
extends Polygon3V {
    public volatile int ar;
    public volatile int ag;
    public volatile int ab;
    public volatile int br;
    public volatile int bg;
    public volatile int bb;
    public volatile int cr;
    public volatile int cg;
    public volatile int cb;
    private static int q;
    private static int sz2;
    private static int sizex;
    private static int sizey;
    private static int sizeu;
    private static int sizev;
    private static int addmip;
    private static int fog;

    public ColorLightedPolygon3V(ColorLightedPolygon3V p) {
        super(p);
        this.ar = p.ar;
        this.ag = p.ag;
        this.ab = p.ab;
        this.br = p.br;
        this.bg = p.bg;
        this.bb = p.bb;
        this.cr = p.cr;
        this.cg = p.cg;
        this.cb = p.cb;
    }

    public ColorLightedPolygon3V(Vertex a2, Vertex b2, Vertex c2, byte au, byte av, byte bu, byte bv, byte cu, byte cv) {
        super(a2, b2, c2, au, av, bu, bv, cu, cv);
        this.cb = 255;
        this.cg = 255;
        this.cr = 255;
        this.bb = 255;
        this.bg = 255;
        this.br = 255;
        this.ab = 255;
        this.ag = 255;
        this.ar = 255;
    }

    public final void render(DirectX7 g3d, Texture texture) {
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = ColorLightedPolygon3V.size(this.a.sx, this.b.sx, this.c.sx);
        sizey = ColorLightedPolygon3V.size(this.a.sy, this.b.sy, this.c.sy);
        int[] al = this.getLight(this.a, this.ar, this.ag, this.ab, g3d);
        int[] bl = this.getLight(this.b, this.br, this.bg, this.bb, g3d);
        int[] cl = this.getLight(this.c, this.cr, this.cg, this.cb, g3d);
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            texture.rImg = texture.mip[0];
            if (texture.drawmode < 10 || texture.drawmode > 12) {
                addmip = q > 999 ? 2 : 3;
                if ((sizex + sizey >> 1) * addmip < (sizeu = ColorLightedPolygon3V.size(this.au, this.bu, this.cu) * texture.rImg.w >> 8) + (sizev = ColorLightedPolygon3V.size(this.av, this.bv, this.cv) * texture.rImg.h >> 8)) {
                    texture.rImg = texture.mip[1];
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu >>= 1) + (sizev >>= 1)) {
                        texture.rImg = texture.mip[2];
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture.rImg = texture.mip[1];
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture.rImg = texture.mip[2];
                }
            }
        }
        if (texture.perspectiveCorrection && (sizex > 30 - (Main.persQ < 3 ? 0 : 15) || sizey > 30 - (Main.persQ < 3 ? 0 : 15)) && Main.persQ != 0 || Main.persQ == 4) {
            TexturingPers.paint(g3d, texture, this.a, this.au, this.av & 0xFF, this.b, this.bu, this.bv & 0xFF, this.c, this.cu, this.cv & 0xFF, DirectX7.fogc, fog, sz2, q, al[0], bl[0], cl[0], al[1], bl[1], cl[1], al[2], bl[2], cl[2], this.nx, this.ny, this.nz);
        } else {
            TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, DirectX7.fogc, fog, sz2, al[0], bl[0], cl[0], al[1], bl[1], cl[1], al[2], bl[2], cl[2], this.nx, this.ny, this.nz);
        }
    }

    public void renderFast(DirectX7 g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1 && fog == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.c, this.cu, this.cv, DirectX7.fogc, texture.drawmode, sz2, this.ar, this.br, this.cr, this.ag, this.bg, this.cg, this.ab, this.bb, this.cb, this.nx, this.ny, this.nz);
    }

    private static final int size(int a, int b, int c) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        return c - a;
    }
}

