/*
 * Decompiled with CFR 0.152.
 */
package code.HUD.Base;

import code.utils.Keyboard;
import code.utils.Main;

public class GameKeyboard
extends Keyboard {
    private int[] pressedNums = new int[10];
    private boolean[] pressed = new boolean[10];
    public static int[] keyCodes;
    public static boolean[] hasKeyCodes;

    public GameKeyboard() {
        super(Main.mainCanvas);
        if (keyCodes == null) {
            this.initKeycodes();
        }
        if (keyCodes != null && keyCodes.length != 48) {
            this.initKeycodes();
        }
    }

    public void reset() {
        super.reset();
        if (this.pressed != null) {
            for (int i = 0; i < this.pressed.length; ++i) {
                this.pressed[i] = false;
            }
        }
    }

    public void keyInput(int key, boolean action) {
        for (int i = 0; i < this.pressed.length; ++i) {
            if (this.pressed[i] != !action) continue;
            if (!action && this.pressedNums[i] == key) {
                this.pressed[i] = false;
            }
            if (!action) continue;
            this.pressedNums[i] = key;
            this.pressed[i] = true;
            break;
        }
        super.keyInput(key, action);
    }

    public boolean isPressed(int key) {
        for (int i = 0; i < this.pressed.length; ++i) {
            if (!this.pressed[i] || this.pressedNums[i] != key) continue;
            return true;
        }
        return false;
    }

    public void initKeycodes() {
        keyCodes = new int[]{this.UP, 50, this.DOWN, 56, 55, 0, 57, 0, this.LEFT, 52, this.RIGHT, 54, 51, 0, 49, 0, this.FIRE, 53, 48, 0, this.SOFT_LEFT, 0, 35, 0, 0, 0, 42, 0, 51, 0, 49, 0, 55, 0, 57, 0, this.LEFT, 52, this.RIGHT, 54, this.UP, 50, this.DOWN, 56, 0, 0, this.SOFT_LEFT, 0};
        hasKeyCodes = new boolean[]{true, true, true, true, true, false, true, false, true, true, true, true, true, false, true, false, true, true, true, false, true, false, true, false, false, false, true, false, true, false, true, false, true, false, true, false, true, true, true, true, true, true, true, true, false, false, true, false};
    }

    public boolean isWalkForward(boolean sight) {
        if (!sight && hasKeyCodes[0] && this.isPressed(keyCodes[0])) {
            return true;
        }
        if (!sight && hasKeyCodes[1] && this.isPressed(keyCodes[1])) {
            return true;
        }
        if (sight && hasKeyCodes[28] && this.isPressed(keyCodes[28])) {
            return true;
        }
        return sight && hasKeyCodes[29] && this.isPressed(keyCodes[29]);
    }

    public boolean isWalkBackward(boolean sight) {
        if (!sight && hasKeyCodes[2] && this.isPressed(keyCodes[2])) {
            return true;
        }
        if (!sight && hasKeyCodes[3] && this.isPressed(keyCodes[3])) {
            return true;
        }
        if (sight && hasKeyCodes[30] && this.isPressed(keyCodes[30])) {
            return true;
        }
        return sight && hasKeyCodes[31] && this.isPressed(keyCodes[31]);
    }

    public boolean isWalkLeft(boolean sight) {
        if (!sight && hasKeyCodes[4] && this.isPressed(keyCodes[4])) {
            return true;
        }
        if (!sight && hasKeyCodes[5] && this.isPressed(keyCodes[5])) {
            return true;
        }
        if (sight && hasKeyCodes[32] && this.isPressed(keyCodes[32])) {
            return true;
        }
        return sight && hasKeyCodes[33] && this.isPressed(keyCodes[33]);
    }

    public boolean isWalkRight(boolean sight) {
        if (!sight && hasKeyCodes[6] && this.isPressed(keyCodes[6])) {
            return true;
        }
        if (!sight && hasKeyCodes[7] && this.isPressed(keyCodes[7])) {
            return true;
        }
        if (sight && hasKeyCodes[34] && this.isPressed(keyCodes[34])) {
            return true;
        }
        return sight && hasKeyCodes[35] && this.isPressed(keyCodes[35]);
    }

    public boolean isLookLeft(boolean sight) {
        if (!sight && hasKeyCodes[8] && this.isPressed(keyCodes[8])) {
            return true;
        }
        if (!sight && hasKeyCodes[9] && this.isPressed(keyCodes[9])) {
            return true;
        }
        if (sight && hasKeyCodes[36] && this.isPressed(keyCodes[36])) {
            return true;
        }
        return sight && hasKeyCodes[37] && this.isPressed(keyCodes[37]);
    }

    public boolean isLookRight(boolean sight) {
        if (!sight && hasKeyCodes[10] && this.isPressed(keyCodes[10])) {
            return true;
        }
        if (!sight && hasKeyCodes[11] && this.isPressed(keyCodes[11])) {
            return true;
        }
        if (sight && hasKeyCodes[38] && this.isPressed(keyCodes[38])) {
            return true;
        }
        return sight && hasKeyCodes[39] && this.isPressed(keyCodes[39]);
    }

    public boolean isLookUp(boolean sight) {
        if (!sight && hasKeyCodes[12] && this.isPressed(keyCodes[12])) {
            return true;
        }
        if (!sight && hasKeyCodes[13] && this.isPressed(keyCodes[13])) {
            return true;
        }
        if (sight && hasKeyCodes[40] && this.isPressed(keyCodes[40])) {
            return true;
        }
        return sight && hasKeyCodes[41] && this.isPressed(keyCodes[41]);
    }

    public boolean isLookDown(boolean sight) {
        if (!sight && hasKeyCodes[14] && this.isPressed(keyCodes[14])) {
            return true;
        }
        if (!sight && hasKeyCodes[15] && this.isPressed(keyCodes[15])) {
            return true;
        }
        if (sight && hasKeyCodes[42] && this.isPressed(keyCodes[42])) {
            return true;
        }
        return sight && hasKeyCodes[43] && this.isPressed(keyCodes[43]);
    }

    public boolean isPlayerShooting() {
        if (hasKeyCodes[16] && this.isPressed(keyCodes[16])) {
            return true;
        }
        return hasKeyCodes[17] && this.isPressed(keyCodes[17]);
    }

    public void releasePlayerShoot() {
        if (hasKeyCodes[16]) {
            this.keyInput(keyCodes[16], false);
        }
        if (hasKeyCodes[17]) {
            this.keyInput(keyCodes[17], false);
        }
    }

    public static boolean isSightKey(int key) {
        if (hasKeyCodes[26] && keyCodes[26] == key) {
            return true;
        }
        return hasKeyCodes[27] && keyCodes[27] == key;
    }

    public static boolean isUseKey(int key) {
        if (hasKeyCodes[46] && keyCodes[46] == key) {
            return true;
        }
        return hasKeyCodes[47] && keyCodes[47] == key;
    }

    public static boolean isInventoryKey(int key) {
        if (hasKeyCodes[20] && keyCodes[20] == key) {
            return true;
        }
        return hasKeyCodes[21] && keyCodes[21] == key;
    }

    public static boolean isJumpKey(int key) {
        if (hasKeyCodes[18] && keyCodes[18] == key) {
            return true;
        }
        return hasKeyCodes[19] && keyCodes[19] == key;
    }

    public static boolean isNextWeaponKey(int key) {
        if (hasKeyCodes[22] && keyCodes[22] == key) {
            return true;
        }
        return hasKeyCodes[23] && keyCodes[23] == key;
    }

    public static boolean isPreviousWeaponKey(int key) {
        if (hasKeyCodes[24] && keyCodes[24] == key) {
            return true;
        }
        return hasKeyCodes[25] && keyCodes[25] == key;
    }
}

