/*
 * Decompiled with CFR 0.152.
 */
package code.utils.canvas;

import code.utils.canvas.MyCanvas;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class MainCanvas
extends Canvas {
    private static MainCanvas mainCanvas;
    public static int pointerX;
    public static int pointerY;
    public static int pointerMovedX;
    public static int pointerMovedY;
    public static int mouseX;
    public static int mouseY;
    public static int emulatorScreenWidth;
    public static int emulatorScreenHeight;
    public static boolean pstros;
    private MyCanvas screen;

    public MainCanvas(MIDlet midlet) {
        this.setFullScreenMode(true);
        mainCanvas = this;
        Display.getDisplay((MIDlet)midlet).setCurrent((Displayable)this);
    }

    public void setScreen(MyCanvas newScreen) {
        if (this.screen != null) {
            this.screen.hideNotify();
        }
        this.screen = newScreen;
        this.screen.showNotify();
    }

    public MyCanvas getScreen() {
        return this.screen;
    }

    static int getMainWidth() {
        return mainCanvas.getWidth();
    }

    static String getMainKeyName(int key) {
        return mainCanvas.getKeyName(key);
    }

    static int getMainKeyCode(int action) {
        return mainCanvas.getKeyCode(action);
    }

    static int getMainHeight() {
        return mainCanvas.getHeight();
    }

    static void mainRepaint(MyCanvas screen) {
        if (MainCanvas.mainCanvas.screen == screen) {
            mainCanvas.repaint();
        }
    }

    static void mainRepaint(MyCanvas screen, int x, int y, int width, int height) {
        if (MainCanvas.mainCanvas.screen == screen) {
            mainCanvas.repaint(x, y, width, height);
        }
    }

    static void mainServiceRepaints(MyCanvas screen) {
        if (MainCanvas.mainCanvas.screen == screen) {
            mainCanvas.serviceRepaints();
        }
    }

    protected void paint(Graphics g) {
        if (this.screen != null) {
            this.screen.paint(g);
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.screen != null) {
            this.screen.keyPressed(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.screen != null) {
            this.screen.keyRepeated(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.screen != null) {
            this.screen.keyReleased(keyCode);
        }
    }

    protected void pointerPressed(int x, int y) {
        pointerX = x;
        pointerY = y;
        pointerMovedY = 0;
        pointerMovedX = 0;
        if (this.screen != null) {
            this.screen.pointerPressed(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.screen != null) {
            this.screen.pointerReleased(x, y);
        }
        if (pointerMovedX <= 4 && pointerMovedY <= 4 && this.screen != null) {
            this.screen.pointerClicked(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        pointerMovedX += Math.abs(x - pointerX);
        pointerMovedY += Math.abs(y - pointerY);
        pointerX = x;
        pointerY = y;
        if (this.screen != null) {
            this.screen.pointerDragged(x, y);
        }
    }

    protected void sizeChanged(int x, int y) {
        if (this.screen != null) {
            this.screen.sizeChanged(x, y);
        }
    }

    protected void updateMousePos(int x, int y) {
        mouseX = x;
        mouseY = y;
    }

    protected void mouseScrollDown() {
        if (this.screen != null) {
            this.screen.mouseScrollDown();
        }
    }

    protected void mouseScrollUp() {
        if (this.screen != null) {
            this.screen.mouseScrollUp();
        }
    }

    protected void thisIsPstros() {
        pstros = true;
    }

    protected void updateScreenSize(int w, int h) {
        emulatorScreenWidth = w;
        emulatorScreenHeight = h;
    }
}

