/*
 * Decompiled with CFR 0.152.
 */
package com.AI;

import com.AI.BigZombie;
import com.AI.NPC;
import com.AI.Zombie;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Gameplay.Weapon;
import com.HUD.Base.HUDInfo;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshClone;
import com.Rendering.Meshes.Morphing;
import com.Rendering.MultyTexture;
import com.misc.Asset;
import com.misc.Main;
import com.misc.Stringer;
import java.util.Vector;

public final class Player
extends GameObject {
    private static Fps fps;
    public static int money;
    public static String[] sndWalk;
    public static String sndJump;
    public static int stepIndex;
    public static Arsenal arsenal;
    public static Vector usedPoints;
    public static Vector toAdd;
    public boolean zoom = false;
    public int fov = Main.minZoom;
    public int minFov = Main.minZoom;
    public int maxFov = Main.maxZoom;
    public long lastZoomAction = 0L;
    public int frags = 0;
    private boolean damage = false;
    private int falldist = 0;
    private Morphing anim = null;
    private MultyTexture mt = null;
    private int fr = 0;
    private long step = 0L;
    public boolean fly = false;
    private long lastJump = 0L;
    private long lastYCheck = 0L;
    private int lastY = 0;
    public float rotateY = 0.0f;
    public float rotateX = 0.0f;

    public Player(int width_g3d, int height_g3d, Vector3D pos, Object hudInfo) {
        this.set(width_g3d, height_g3d, pos, hudInfo);
    }

    public final void set(int width_g3d, int height_g3d, Vector3D pos, Object hudInfo) {
        this.name = "PLAYER";
        this.character.reset();
        this.character.getTransform().setPosition(0, 0, 0);
        if (pos != null) {
            this.character.getTransform().setPosition(pos.x, pos.y, pos.z);
        }
        this.setHp(100);
        this.frags = 0;
        this.setCharacterSize(400, 1503);
        this.falldist = 0;
        money = 0;
        arsenal = new Arsenal(width_g3d, height_g3d);
        if (hudInfo != null) {
            money = ((HUDInfo)hudInfo).money;
            int[] ammos = ((HUDInfo)hudInfo).ammo;
            Weapon[] weapons = Arsenal.getWeapons();
            for (int i = 0; i < weapons.length; ++i) {
                if (weapons[i] != null) {
                    weapons[i].reset();
                }
                if (ammos[i] == -1) {
                    weapons[i] = null;
                    continue;
                }
                weapons[i] = Stringer.createWeapon(i);
                weapons[i].setAmmo(ammos[i]);
            }
            if (Arsenal.current != -1) {
                Arsenal.currentWeapon().createSprite(width_g3d, height_g3d);
            }
        }
    }

    public Morphing getAnim() {
        return this.anim;
    }

    public void setModel(String modelPath, String textures, float scale) {
        Mesh[] meshes = Asset.getMeshes(modelPath, scale, scale, scale);
        Mesh mesh = meshes[0];
        this.anim = new Morphing(Morphing.create(meshes), new MeshClone(mesh).copy());
        this.mt = Asset.getMultyTexture(textures);
        this.anim.getMesh().setTexture(this.mt);
    }

    public final void destroy() {
        if (this.anim != null) {
            this.anim.getMesh().destroy();
            this.anim.destroy();
        }
        this.anim = null;
        money = 0;
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (Main.stepSound != null && Main.isFootsteps && Main.footsteps != 0 && (this.character.speed.x != 0 || this.character.speed.z != 0) && this.character.onFloor && System.currentTimeMillis() - this.step > 450L) {
            String[] soundz = Main.stepSound;
            if (sndWalk != null) {
                soundz = sndWalk;
            }
            if (stepIndex >= soundz.length) {
                stepIndex = 0;
            }
            if (soundz != null) {
                try {
                    Asset.getSound(soundz[stepIndex]).stopND();
                    Asset.getSound(soundz[stepIndex]).start(Main.footsteps);
                    ++stepIndex;
                }
                catch (Exception var2) {
                    System.err.println("ERROR in Step sound: " + var2);
                }
            }
            this.step = System.currentTimeMillis();
        }
        if (this.anim == null && Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().renderSplinter(g3d);
        }
        if (this.anim != null) {
            Matrix mat = new Matrix();
            mat.set(this.character.getTransform());
            if (this.character.speed.x != 0 || this.character.speed.z != 0) {
                this.anim.setFrame(this.fr * 170 / 100);
                this.fr += 20000 / Fps.getFps();
                if (this.fr * 170 / 100 > 2048) {
                    this.fr = 0;
                }
            }
            g3d.transformAndProjectVertices(this.anim.getMesh(), g3d.computeFinalMatrix(mat));
            g3d.addMesh(this.anim.getMesh(), x1, y1, x2, y2, this.mt);
        }
    }

    public final void update(Scene scene, Player player) {
        super.update(scene, player);
        sndWalk = scene.getHouse().getRooms()[this.getPart()].stepSound;
        sndJump = scene.getHouse().getRooms()[this.getPart()].jumpSound;
        if (Main.fallDamage) {
            if (!this.character.onFloor && System.currentTimeMillis() - this.lastYCheck < 1000L) {
                this.falldist += this.lastY - this.getPosY();
            }
            if (this.falldist > 7000 && this.character.onFloor) {
                this.damage = true;
                this.damage((this.falldist - 7000) / 40);
            }
            if (this.falldist > 11000 && !this.character.onFloor) {
                this.damage = true;
                this.damage(100);
            }
            this.lastYCheck = System.currentTimeMillis();
            this.lastY = this.getPosY();
            if (this.character.onFloor) {
                this.falldist = 0;
            }
        }
        if (Arsenal.current != -1 && Arsenal.currentWeapon() != null) {
            GameObject obj = Arsenal.currentWeapon().update(scene.getHouse(), this);
            if (obj instanceof Zombie) {
                money += Main.zombieprice;
                ++this.frags;
            } else if (obj instanceof BigZombie) {
                money += Main.bigzombieprice;
                ++this.frags;
            } else if (obj instanceof NPC) {
                NPC npc = (NPC)obj;
                this.frags += npc.fragsOnDeath;
                money += npc.moneyOnDeath;
            }
        }
    }

    public final boolean damage(GameObject obj, int dmg) {
        if (Main.debug && dmg > 0) {
            return true;
        }
        if (dmg > 0) {
            this.damage = true;
        }
        if (dmg < 0 && this.getHp() - dmg > 100) {
            return super.damage(obj, -(100 - this.getHp()));
        }
        return super.damage(obj, dmg);
    }

    public final boolean isDamaged() {
        boolean tmp = this.damage;
        this.damage = false;
        return tmp;
    }

    public final void pay(int price) {
        money -= price;
    }

    public final boolean isTimeToRenew() {
        return this.isDead() && System.currentTimeMillis() - this.DeathTime > 3000L;
    }

    public final void fire(Graphics3D g3d) {
        if (Arsenal.current != -1) {
            Arsenal.currentWeapon().fire(g3d);
        }
    }

    public final void jump() {
        if (Main.debug && System.currentTimeMillis() - this.lastJump < 400L) {
            this.fly = !this.fly;
            this.lastJump = System.currentTimeMillis();
        }
        if (!Main.arcadeJumpPhysics) {
            this.jump(150, 1.2f);
        }
        if (Main.arcadeJumpPhysics) {
            this.character.jumpArcade(150, 1.2f);
        }
        if (this.character.onFloor && Main.isFootsteps && Main.footsteps != 0) {
            try {
                String snd = Main.jumpSound;
                if (sndJump != null) {
                    snd = sndJump;
                }
                Asset.getSound(snd).stopND();
                Asset.getSound(snd).start(Main.footsteps);
            }
            catch (Exception var2) {
                System.err.println("ERROR in Step sound: " + var2);
            }
        }
    }

    public void updateMatrix() {
        int x = this.character.transform.m03;
        int y = this.character.transform.m13;
        int z = this.character.transform.m23;
        if (this.rotateX < -80.0f) {
            this.rotateX = -80.0f;
        }
        if (this.rotateX > 80.0f) {
            this.rotateX = 80.0f;
        }
        while (this.rotateY > 360.0f) {
            this.rotateY -= 360.0f;
        }
        while (this.rotateY < 0.0f) {
            this.rotateY += 360.0f;
        }
        this.character.transform.setIdentity();
        this.character.transform.setRotX((int)this.rotateX);
        this.character.transform.setPosition(x, y, z);
        this.character.transform.rotY((int)this.rotateY);
    }

    public final void rotYn(float i) {
        this.rotateY += i;
        this.updateMatrix();
    }

    public final void rotXn(float i) {
        this.rotateX += i;
        this.updateMatrix();
    }

    public final void rotX(float i) {
        this.rotateX += i * 200.0f / (float)Fps.getFps();
        this.updateMatrix();
    }

    public final void rotLeft() {
        this.rotateY += (!this.zoom ? 7.0f : 5.0f) * (float)Main.mouseSpeed / 50.0f * 200.0f / (float)Fps.getFps();
        this.updateMatrix();
    }

    public final void rotRight() {
        this.rotateY -= (!this.zoom ? 7.0f : 5.0f) * (float)Main.mouseSpeed / 50.0f * 200.0f / (float)Fps.getFps();
        this.updateMatrix();
    }

    public final void rotUp() {
        this.rotateX += (!this.zoom ? 7.0f : 5.0f) * (float)Main.mouseSpeed / 100.0f * 200.0f / (float)Fps.getFps();
        this.updateMatrix();
    }

    public final void rotDown() {
        this.rotateX -= (!this.zoom ? 7.0f : 5.0f) * (float)Main.mouseSpeed / 100.0f * 200.0f / (float)Fps.getFps();
        this.updateMatrix();
    }

    public final void moveForward() {
        this.moveZ(-150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final void moveBackward() {
        this.moveZ(150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final void moveLeft() {
        this.getCharacter().moveX(-150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final void moveRight() {
        this.getCharacter().moveX(150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final Object getHUDInfo() {
        Weapon[] weapons = Arsenal.getWeapons();
        int[] ammos = new int[weapons.length];
        for (int i = 0; i < weapons.length; ++i) {
            ammos[i] = weapons[i] != null ? weapons[i].getAmmo() + weapons[i].getRounds() : -1;
        }
        return new HUDInfo(money, ammos);
    }

    public void activate(House house, Player player, GameScreen gs) {
    }

    public static void copyNewToUsed() {
        if (toAdd.isEmpty()) {
            return;
        }
        while (!toAdd.isEmpty()) {
            if (!RoomObject.containsSimple(usedPoints, (String)toAdd.firstElement())) {
                usedPoints.addElement(toAdd.firstElement());
            }
            toAdd.removeElementAt(0);
        }
    }

    static {
        money = 0;
        sndWalk = null;
        sndJump = null;
        stepIndex = 0;
        usedPoints = new Vector();
        toAdd = new Vector();
    }
}

