/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Rendering.Meshes.Mesh;
import code.Rendering.Vertex;

public final class Morphing {
    public static final int fp = 10;
    public static final int FP = 1024;
    private short[][] animation;
    private Mesh mesh;
    private int frame = 0;
    public boolean morphEnabled = true;

    public static short[][] create(Mesh[] meshes, int start, int end) {
        short[][] anim = new short[end - start][];
        int c = 0;
        for (int i = start; i < end; ++i) {
            Mesh mesh = meshes[i];
            Vertex[] verts = mesh.getVertices();
            short[] meshVerts = new short[verts.length * 3];
            for (int x = 0; x < verts.length; ++x) {
                Vertex vert = verts[x];
                meshVerts[x * 3] = (short)vert.x;
                meshVerts[x * 3 + 1] = (short)vert.y;
                meshVerts[x * 3 + 2] = (short)vert.z;
            }
            anim[c] = meshVerts;
            ++c;
        }
        return anim;
    }

    public Morphing() {
    }

    public Morphing(short[][] animation, Mesh mesh) {
        this.animation = animation;
        this.mesh = mesh;
    }

    public final void destroy() {
        this.animation = null;
        this.mesh = null;
    }

    public short[][] getVertices() {
        return this.animation;
    }

    public int getMaxFrame() {
        return 1024 * this.animation.length;
    }

    public int getFrame() {
        return this.frame;
    }

    public final void setFrameNI(int frame) {
        int maxFrame = this.getMaxFrame();
        while (frame < 0) {
            frame += maxFrame;
        }
        frame = maxFrame != 0 ? (frame %= maxFrame) : 0;
        this.frame = frame;
    }

    public final void setFrame(int frame) {
        this.setFrameNI(frame);
        this.interpolation(this.mesh.getVertices());
    }

    void interpolation(Vertex[] versRes) {
        int aFrame = this.frame / 1024;
        int af1 = 0;
        int af2 = 0;
        if (this.animation.length != 0) {
            af1 = aFrame % this.animation.length;
            af2 = (aFrame + 1) % this.animation.length;
        }
        short[] versA = this.animation[af1];
        short[] versB = this.animation[af2];
        int kinv = this.frame % 1024;
        int k = 1024 - kinv;
        boolean morphEnabled = this.morphEnabled;
        for (int i = 0; i < versRes.length; ++i) {
            int n = i * 3;
            short ax = versA[n];
            short ay = versA[n + 1];
            short az = versA[n + 2];
            if (morphEnabled) {
                short bx = versB[n];
                short by = versB[n + 1];
                short bz = versB[n + 2];
                versRes[i].set((ax * k >> 10) + (bx * kinv >> 10), (ay * k >> 10) + (by * kinv >> 10), (az * k >> 10) + (bz * kinv >> 10));
                continue;
            }
            versRes[i].set(ax, ay, az);
        }
    }

    public final Mesh getMesh() {
        return this.mesh;
    }

    public final short[][] getAnimation() {
        return this.animation;
    }
}

