/*
 * Decompiled with CFR 0.152.
 */
package code.HUD;

import code.HUD.Base.Selectable;
import code.HUD.Benchmark;
import code.HUD.DeveloperMenu;
import code.HUD.Help;
import code.HUD.LevelSelection;
import code.HUD.Setting;
import code.utils.ImageResize;
import code.utils.IniFile;
import code.utils.Main;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Menu
extends Selectable {
    private Main main;
    public Image backgroundMain;
    public Image background;
    public static int w = 240;
    public static int h = 320;
    public static boolean hasSave;
    private int newGameIndex;
    private int continueIndex;
    private int levelSelectIndex;
    private int helpIndex;
    private int optionsIndex;
    private int exitIndex;

    public Menu(Main main) {
        hasSave = Main.hasSave();
        this.main = main;
        w = this.getWidth();
        h = this.getHeight();
        this.backgroundMain = this.background = ImageResize.createImage(Main.background, w, h);
        if (Main.background_logo != null && !Main.background_logo.equals(Main.background)) {
            this.backgroundMain = ImageResize.createImage(Main.background_logo, w, h);
        }
        if (Main.isMusic && Main.menuMusic != null) {
            try {
                Main.musicPlayer.loadFile(Main.menuMusic);
                Main.musicPlayer.setVolume(Main.music);
                Main.musicPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.levelSelectIndex = -1;
        this.continueIndex = -1;
        this.newGameIndex = -1;
        this.reloadText();
    }

    public final void reloadText() {
        IniFile lang = Main.getGameText();
        Vector<String> newList = new Vector<String>();
        int levels = this.main.getAvailableLevelCount();
        if (!hasSave) {
            if (levels == 1) {
                newList.addElement(lang.get("NEW_GAME"));
                this.newGameIndex = 0;
            } else {
                newList.addElement(lang.get("SELECT_LEVEL"));
                this.levelSelectIndex = 0;
            }
        } else {
            newList.addElement(lang.get("CONTINUE"));
            this.continueIndex = 0;
            this.newGameIndex = 1;
            if (levels > 1 && Main.canSelectLevel) {
                newList.addElement(lang.get("SELECT_LEVEL"));
                this.levelSelectIndex = 1;
                this.newGameIndex = 2;
            }
            newList.addElement(lang.get("NEW_GAME"));
        }
        newList.addElement(lang.get("HELP"));
        this.helpIndex = newList.size() - 1;
        newList.addElement(lang.get("OPTIONS"));
        this.optionsIndex = newList.size() - 1;
        newList.addElement(lang.get("EXIT"));
        this.exitIndex = newList.size() - 1;
        if (DeveloperMenu.debugMode) {
            newList.addElement("Benchmark");
            newList.addElement("AE-Mods");
            newList.addElement("Developer menu");
        }
        this.set(Main.getFont(), newList, lang.get("SELECT"), (String)null);
    }

    public final void destroy() {
        super.destroy();
        Main.musicPlayer.destroy();
        this.backgroundMain = null;
        this.background = null;
    }

    protected final void paint(Graphics g) {
        this.drawBackgroundLogo(g);
        super.paint(g);
    }

    public final void drawBackgroundLogo(Graphics g) {
        g.drawImage(this.backgroundMain, 0, 0, 0);
    }

    public final void drawBackground(Graphics g) {
        g.drawImage(this.background, 0, 0, 0);
    }

    protected final void onLeftSoftKey() {
        this.onKey5();
    }

    protected final void onKey5() {
        int index = this.itemIndex();
        if (index == this.newGameIndex) {
            this.newGame();
        } else if (index == this.continueIndex) {
            this.continueGame();
        } else if (index == this.levelSelectIndex) {
            this.selectLevel();
        } else if (index == this.helpIndex) {
            Help help = new Help(this.main, this);
            Main.setCurrent(help);
        } else if (index == this.optionsIndex) {
            Main.setCurrent(new Setting(this.main, this, this.background));
        } else if (index == this.exitIndex) {
            this.main.notifyDestroyed();
        } else if (index == this.list.getItems().length - 3 && DeveloperMenu.debugMode) {
            Main.setCurrent(new Benchmark(this.main, this));
        } else if (index == this.list.getItems().length - 2 && DeveloperMenu.debugMode) {
            try {
                this.main.platformRequest("http://ae-mods.ru");
            }
            catch (Exception exception) {}
        } else if (index == this.list.getItems().length - 1 && DeveloperMenu.debugMode) {
            Main.setCurrent(new DeveloperMenu(this.main, this, this.background));
        }
        this.repaint();
    }

    private void selectLevel() {
        Main.setCurrent(new LevelSelection(this.main, this));
    }

    private void continueGame() {
        int levelNumber = Main.getContinueLevel();
        Main.loadLevel(true, true, levelNumber, null, this.main, this, 1, true);
    }

    private void newGame() {
        Main.removeSave();
        Main.loadLevel(false, false, 1, null, this.main, this, 1, true);
    }
}

