/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import javax.microedition.lcdui.Image;

public class ImageResize {
    public static Image createImage(String file, int w, int h) {
        try {
            return ImageResize.bilinearResizeImage(Image.createImage((String)file), w, h);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    public static Image createImage(String file, float w, float h) {
        try {
            return ImageResize.bilinearScaleImage(Image.createImage((String)file), w, h);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    public static Image createImage(Image file, int w, int h) {
        return ImageResize.bilinearResizeImage(file, w, h);
    }

    public static Image createImage(Image file, float w, float h) {
        return ImageResize.bilinearScaleImage(file, w, h);
    }

    public static Image createImageProportional(String file, int w, int h) {
        try {
            if (w < h) {
                return ImageResize.bilinearResizeImage(Image.createImage((String)file), w, w);
            }
            return ImageResize.bilinearResizeImage(Image.createImage((String)file), h, h);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    public static Image createImageProportional(String file, float w, float h) {
        try {
            if (w < h) {
                return ImageResize.bilinearScaleImage(Image.createImage((String)file), w, w);
            }
            return ImageResize.bilinearScaleImage(Image.createImage((String)file), h, h);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    public static Image bilinearScaleImage(Image img, float scaleX, float scaleY) {
        return ImageResize.bilinearResizeImage(img, (int)((float)img.getWidth() * scaleX), (int)((float)img.getHeight() * scaleY));
    }

    public static Image bilinearResizeImage(Image img, int nw, int nh) {
        if (img.getWidth() == nw && img.getHeight() == nh) {
            return img;
        }
        int[] src = new int[img.getWidth() * img.getHeight()];
        img.getRGB(src, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        int[] dest = new int[nw * nh];
        ImageResize.bilinearResizeRGB(src, dest, img.getWidth(), img.getHeight(), nw, nh, true);
        return Image.createRGBImage((int[])dest, (int)nw, (int)nh, (boolean)true);
    }

    public static void bilinearResizeRGB(int[] srcPixels, int[] destPixels, int srcw, int srch, int destw, int desth, boolean alpha) {
        int FP_SHIFT = 16;
        int FP_MASK = 65535;
        try {
            if (alpha) {
                for (int x = 0; x < destw; ++x) {
                    for (int y = 0; y < desth; ++y) {
                        int idx4;
                        int rx = (x << 16) / destw * srcw;
                        int ry = (y << 16) / desth * srch;
                        int ix = rx >>> 16;
                        int iy = ry >>> 16;
                        int fx = rx & 0xFFFF;
                        int fy = ry & 0xFFFF;
                        int idx3 = idx4 = ix + iy * srcw;
                        int idx2 = idx4;
                        int idx1 = idx4++;
                        if (ix < srcw - 1) {
                            ++idx2;
                        }
                        if (iy < srch - 1) {
                            idx3 += srcw;
                            idx4 += srcw;
                        }
                        int a = ((srcPixels[idx1] >> 24 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 24 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 24 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 24 & 0xFF) * fx >>> 16) * fy >>> 16;
                        int r = ((srcPixels[idx1] >> 16 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 16 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 16 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 16 & 0xFF) * fx >>> 16) * fy >>> 16;
                        int g = ((srcPixels[idx1] >> 8 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 8 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 8 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 8 & 0xFF) * fx >>> 16) * fy >>> 16;
                        int b = ((srcPixels[idx1] & 0xFF) * (65535 - fx) + (srcPixels[idx2] & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] & 0xFF) * (65535 - fx) + (srcPixels[idx4] & 0xFF) * fx >>> 16) * fy >>> 16;
                        destPixels[x + y * destw] = a << 24 | r << 16 | g << 8 | b;
                    }
                }
            } else {
                for (int x = 0; x < destw; ++x) {
                    for (int y = 0; y < desth; ++y) {
                        int idx4;
                        int rx = (x << 16) / destw * srcw;
                        int ry = (y << 16) / desth * srch;
                        int ix = rx >>> 16;
                        int iy = ry >>> 16;
                        int fx = rx & 0xFFFF;
                        int fy = ry & 0xFFFF;
                        int idx3 = idx4 = ix + iy * srcw;
                        int idx2 = idx4;
                        int idx1 = idx4++;
                        if (ix < srcw - 1) {
                            ++idx2;
                        }
                        if (iy < srch - 1) {
                            idx3 += srcw;
                            idx4 += srcw;
                        }
                        int r = ((srcPixels[idx1] >> 16 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 16 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 16 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 16 & 0xFF) * fx >>> 16) * fy >>> 16;
                        int g = ((srcPixels[idx1] >> 8 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 8 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 8 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 8 & 0xFF) * fx >>> 16) * fy >>> 16;
                        int b = ((srcPixels[idx1] & 0xFF) * (65535 - fx) + (srcPixels[idx2] & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] & 0xFF) * (65535 - fx) + (srcPixels[idx4] & 0xFF) * fx >>> 16) * fy >>> 16;
                        destPixels[x + y * destw] = r << 16 | g << 8 | b;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public static void bilinearResizeRGBnA(int[] srcPixels, int[] destPixels, int srcw, int srch, int destw, int desth) {
        int FP_SHIFT = 16;
        int FP_MASK = 65535;
        try {
            for (int x = 0; x < destw; ++x) {
                for (int y = 0; y < desth; ++y) {
                    int idx4;
                    int rx = (x << 16) / destw * srcw;
                    int ry = (y << 16) / desth * srch;
                    int ix = rx >>> 16;
                    int iy = ry >>> 16;
                    int fx = rx & 0xFFFF;
                    int fy = ry & 0xFFFF;
                    int idx3 = idx4 = ix + iy * srcw;
                    int idx2 = idx4;
                    int idx1 = idx4++;
                    if (ix < srcw - 1) {
                        ++idx2;
                    }
                    if (iy < srch - 1) {
                        idx3 += srcw;
                        idx4 += srcw;
                    }
                    int r = ((srcPixels[idx1] >> 16 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 16 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 16 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 16 & 0xFF) * fx >>> 16) * fy >>> 16;
                    int g = ((srcPixels[idx1] >> 8 & 0xFF) * (65535 - fx) + (srcPixels[idx2] >> 8 & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] >> 8 & 0xFF) * (65535 - fx) + (srcPixels[idx4] >> 8 & 0xFF) * fx >>> 16) * fy >>> 16;
                    int b = ((srcPixels[idx1] & 0xFF) * (65535 - fx) + (srcPixels[idx2] & 0xFF) * fx >>> 16) * (65535 - fy) + ((srcPixels[idx3] & 0xFF) * (65535 - fx) + (srcPixels[idx4] & 0xFF) * fx >>> 16) * fy >>> 16;
                    destPixels[x + y * destw] = r << 16 | g << 8 | b;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public static void bilinearResizeRGBnA_toLow(int[] srcPixels, int[] destPixels, int srcw, int srch, int destw, int desth) {
        int FP_SHIFT = 16;
        int FP_MASK = 65535;
        try {
            for (int x = 0; x < destw; ++x) {
                for (int y = 0; y < desth; ++y) {
                    int xx;
                    int b = 0;
                    int g = 0;
                    int r = 0;
                    int a = 1;
                    int yy = y * srch / desth;
                    int xxf = xx + srcw / destw;
                    int yyf = yy + srch / desth;
                    for (xx = x * srcw / destw; xx < xxf; xx += 2) {
                        while (yy < yyf) {
                            int rx = xx;
                            int ry = yy;
                            if (rx > srcw) {
                                rx = srcw;
                            }
                            if (ry > srch) {
                                rx = srch;
                            }
                            int idx1 = rx + ry * srcw;
                            r += srcPixels[idx1] >> 16 & 0xFF;
                            g += srcPixels[idx1] >> 8 & 0xFF;
                            b += srcPixels[idx1] & 0xFF;
                            ++a;
                            yy += 2;
                        }
                    }
                    if ((r /= a) > 255) {
                        r = 255;
                    }
                    if ((g /= a) > 255) {
                        g = 255;
                    }
                    if ((b /= a) > 255) {
                        b = 255;
                    }
                    destPixels[x + y * destw] = 0xFF000000 | r << 16 | g << 8 | b;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public static int[] mipMap(int[] original, int w, int h) {
        int nw = w / 2;
        int nh = h / 2;
        int[] out = new int[nw * nh];
        for (int y = 0; y < nh; ++y) {
            for (int x = 0; x < nw; ++x) {
                int col = original[x * 2 + y * 2 * w];
                int aa = col >> 24 & 0xFF;
                int ar = col >> 16 & 0xFF;
                int ag = col >> 8 & 0xFF;
                int ab = col & 0xFF;
                col = original[x * 2 + y * 2 * w + 1 & original.length - 1];
                int br = col >> 16 & 0xFF;
                int bg = col >> 8 & 0xFF;
                int bb = col & 0xFF;
                col = original[x * 2 + y * 2 * w + 1 + w & original.length - 1];
                int cr = col >> 16 & 0xFF;
                int cg = col >> 8 & 0xFF;
                int cb = col & 0xFF;
                col = original[x * 2 + y * 2 * w + w & original.length - 1];
                int dr = col >> 16 & 0xFF;
                int dg = col >> 8 & 0xFF;
                int db = col & 0xFF;
                int or = (ar + br + cr + dr) / 4;
                int og = (ag + bg + cg + dg) / 4;
                int ob = (ab + bb + cb + db) / 4;
                out[x + y * nw] = aa << 24 | or << 16 | og << 8 | ob;
            }
        }
        return out;
    }

    public static int[] cubic2XDesize(int[] original, int w, int h) {
        int nw = w / 2;
        int nh = h / 2;
        int[] out = new int[nw * nh];
        for (int y = 0; y < nh; ++y) {
            for (int x = 0; x < nw; ++x) {
                int col = original[x * 2 % w + y * 2 % h * w];
                int aa = col >> 24 & 0xFF;
                int ar = col >> 16 & 0xFF;
                int ag = col >> 8 & 0xFF;
                int ab = col & 0xFF;
                col = original[x * 2 % w + (y * 2 + 1) % h * w];
                int br = col >> 16 & 0xFF;
                int bg = col >> 8 & 0xFF;
                int bb = col & 0xFF;
                col = original[(x * 2 + 1) % w + (y * 2 + 1) % h * w];
                int cr = col >> 16 & 0xFF;
                int cg = col >> 8 & 0xFF;
                int cb = col & 0xFF;
                col = original[(x * 2 + 1) % w + y * 2 % h * w];
                int dr = col >> 16 & 0xFF;
                int dg = col >> 8 & 0xFF;
                int db = col & 0xFF;
                int or = (ar + br + cr + dr) / 4;
                int og = (ag + bg + cg + dg) / 4;
                int ob = (ab + bb + cb + db) / 4;
                out[x + y * nw] = aa << 24 | or << 16 | og << 8 | ob;
            }
        }
        return out;
    }

    public static int[] cubic2XVertDesize(int[] original, int w, int h) {
        int nw = w;
        int nh = h / 2;
        int[] out = new int[nw * nh];
        for (int y = 0; y < nh; ++y) {
            for (int x = 0; x < nw; ++x) {
                int col = original[x + y * 2 % h * w];
                int aa = col >> 24 & 0xFF;
                int ar = col >> 16 & 0xFF;
                int ag = col >> 8 & 0xFF;
                int ab = col & 0xFF;
                col = original[x + (y * 2 + 1) % h * w];
                int br = col >> 16 & 0xFF;
                int bg = col >> 8 & 0xFF;
                int bb = col & 0xFF;
                int or = (ar + br) / 2;
                int og = (ag + bg) / 2;
                int ob = (ab + bb) / 2;
                out[x + y * nw] = aa << 24 | or << 16 | og << 8 | ob;
            }
        }
        return out;
    }

    public static int[] cubic2XHorDesize(int[] original, int w, int h) {
        int nw = w / 2;
        int nh = h;
        int[] out = new int[nw * nh];
        for (int y = 0; y < nh; ++y) {
            for (int x = 0; x < nw; ++x) {
                int col = original[x + y % h * (w * 2)];
                int aa = col >> 24 & 0xFF;
                int ar = col >> 16 & 0xFF;
                int ag = col >> 8 & 0xFF;
                int ab = col & 0xFF;
                col = original[x + y % h * (w * 2 + 1)];
                int br = col >> 16 & 0xFF;
                int bg = col >> 8 & 0xFF;
                int bb = col & 0xFF;
                int or = (ar + br) / 2;
                int og = (ag + bg) / 2;
                int ob = (ab + bb) / 2;
                out[x + y * nw] = aa << 24 | or << 16 | og << 8 | ob;
            }
        }
        return out;
    }
}

