/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.Matrix;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Morphing;
import code.Rendering.Vertex;

public class BoundingBox {
    private static Vertex[] vertices = new Vertex[]{new Vertex(0, 0, 0), new Vertex(0, 0, 0), new Vertex(0, 0, 0), new Vertex(0, 0, 0), new Vertex(0, 0, 0), new Vertex(0, 0, 0), new Vertex(0, 0, 0), new Vertex(0, 0, 0)};
    public int minx;
    public int miny;
    public int maxx;
    public int maxy;
    public int minz;
    public int maxz;
    private static int minpx;
    private static int minpy;
    private static int maxpx;
    private static int maxpy;
    private static int minpz;
    private static int maxpz;

    public BoundingBox(Mesh mesh) {
        this.minx = mesh.minX();
        this.miny = mesh.minY();
        this.minz = mesh.minZ();
        this.maxx = mesh.maxX();
        this.maxy = mesh.maxY();
        this.maxz = mesh.maxZ();
    }

    public BoundingBox(Morphing anim) {
        this.minx = Integer.MAX_VALUE;
        this.miny = Integer.MAX_VALUE;
        this.minz = Integer.MAX_VALUE;
        this.maxx = Integer.MIN_VALUE;
        this.maxy = Integer.MIN_VALUE;
        this.maxz = Integer.MIN_VALUE;
        short[][] vertices = anim.getVertices();
        for (int j = 0; j < vertices.length; ++j) {
            short[] vers = vertices[j];
            for (int i = 0; i < vers.length / 3; ++i) {
                short x = vers[i * 3];
                short y = vers[i * 3 + 1];
                short z = vers[i * 3 + 2];
                this.minx = Math.min(this.minx, x);
                this.miny = Math.min(this.miny, y);
                this.minz = Math.min(this.minz, z);
                this.maxx = Math.max(this.maxx, x);
                this.maxy = Math.max(this.maxy, y);
                this.maxz = Math.max(this.maxz, z);
            }
        }
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        vertices[0].set(minX, minY, minZ);
        vertices[1].set(maxX, minY, minZ);
        vertices[2].set(minX, minY, maxZ);
        vertices[3].set(maxX, minY, maxZ);
        vertices[4].set(minX, maxY, minZ);
        vertices[5].set(maxX, maxY, minZ);
        vertices[6].set(minX, maxY, maxZ);
        vertices[7].set(maxX, maxY, maxZ);
    }

    public boolean isVisible(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        return this.isVisible(g3d, g3d.invCamera, x1, y1, x2, y2);
    }

    public boolean isVisible(DirectX7 g3d, Matrix matrix, int x1, int y1, int x2, int y2) {
        int maxZ;
        int maxY;
        int maxX;
        this.set(this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
        g3d.transformAndProjectVertices(vertices, matrix);
        Vertex v = vertices[0];
        int minX = maxX = v.sx;
        int minY = maxY = v.sy;
        int minZ = maxZ = v.rz;
        for (int i = 1; i < vertices.length; ++i) {
            v = vertices[i];
            if (v.sx < minX) {
                minX = v.sx;
            }
            if (v.sy < minY) {
                minY = v.sy;
            }
            if (v.rz < minZ) {
                minZ = v.rz;
            }
            if (v.rz > maxZ) {
                maxZ = v.rz;
            }
            if (v.sx > maxX) {
                maxX = v.sx;
            }
            if (v.sy <= maxY) continue;
            maxY = v.sy;
        }
        return maxX >= x1 && minX <= x2 && maxY >= y1 && minY <= y2 && minZ < 0 && -maxZ <= DirectX7.drDist;
    }

    public void reSort(Matrix matrix) {
        this.set(this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
        DirectX7.transformSave(vertices, matrix);
        Vertex v = vertices[0];
        minpx = maxpx = v.x;
        minpy = maxpy = v.y;
        minpz = maxpz = v.z;
        for (int i = 1; i < vertices.length; ++i) {
            v = vertices[i];
            if (v.x < minpx) {
                minpx = v.x;
            }
            if (v.y < minpy) {
                minpy = v.y;
            }
            if (v.z < minpz) {
                minpz = v.z;
            }
            if (v.x > maxpx) {
                maxpx = v.x;
            }
            if (v.y > maxpy) {
                maxpy = v.y;
            }
            if (v.z <= maxpz) continue;
            maxpz = v.z;
        }
    }

    public int getMinX() {
        return minpx;
    }

    public int getMinY() {
        return minpy;
    }

    public int getMinZ() {
        return minpz;
    }

    public int getMaxZ() {
        return maxpz;
    }

    public int getMaxX() {
        return maxpx;
    }

    public int getMaxY() {
        return maxpy;
    }
}

