/*
 * Decompiled with CFR 0.152.
 */
package code.AI.misc;

import code.Gameplay.Objects.GameObject;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Sprite;
import code.Rendering.Texture;
import code.utils.Main;
import code.utils.QFPS;

public class Blood {
    public static Texture blood = null;
    private static byte mir = 0;
    private int frame = 255;
    private Sprite sprite = new Sprite(5);

    public Blood(GameObject obj) {
        this.sprite.setTextures(new Texture[]{blood});
        this.sprite.setScale(5);
        this.sprite.mode = (byte)(Blood.blood.rImg.alphaMixing ? 3 : 0);
        this.sprite.mirX = mir >= 2;
        this.sprite.mirY = mir == 1 || mir == 2;
        mir = (byte)((mir + 1) % 4);
    }

    public final void reset() {
        this.sprite.setScale(5);
        this.frame = 255;
    }

    public final void destroy() {
        this.sprite.destroy();
        this.sprite = null;
    }

    public final void bleed() {
        this.frame = 0;
        this.sprite.mirX = !this.sprite.mirX;
        this.sprite.mirY = !this.sprite.mirX;
    }

    public final void render(DirectX7 g3d, int sz, Vector3D pos) {
        this.sprite.getPosition().set(pos.x, pos.y, pos.z);
        this.frame += QFPS.frameTime / 5;
        this.sprite.setScale((int)((float)(this.frame / 2) * Main.bloodscale));
        this.sprite.setOffset(0, -this.sprite.getHeight() / 2 - this.frame * 4);
        this.sprite.project(g3d.getInvCamera(), g3d);
        g3d.addRenderObject(this.sprite);
        this.sprite.sz += sz;
    }

    public final boolean isBleeding() {
        return this.frame < 70;
    }
}

