/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.Gameplay.Map.House;
import code.Gameplay.Map.LightMapper;
import code.Gameplay.Map.Portal;
import code.Gameplay.Map.Room;
import code.Math.MathUtils2;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.RenderObject;
import code.Rendering.Vertex;
import java.util.Vector;

public class HouseCreator {
    public static House create(Mesh[] meshes, boolean np, String lightdataFile, boolean optimizeLevel) {
        House house;
        if (optimizeLevel) {
            for (int i = 0; i < meshes.length; ++i) {
                meshes[i].optimize();
            }
        }
        if (lightdataFile != null && (DirectX7.standartDrawmode == 9 || DirectX7.standartDrawmode == 13)) {
            LightMapper.loadLightMap(meshes, lightdataFile);
        }
        if (meshes.length > 1) {
            int i;
            RenderObject[] portalPols = meshes[meshes.length - 1].getPolygons();
            Room[] rooms = new Room[meshes.length - 1];
            for (i = 0; i < meshes.length - 1; ++i) {
                rooms[i] = new Room(meshes[i], i);
            }
            for (i = 0; i < rooms.length; ++i) {
                Room room = rooms[i];
                Vector<Portal> portalsList = new Vector<Portal>();
                for (int t = 0; t < portalPols.length; ++t) {
                    Vertex[] portalVerts;
                    RenderObject portal = portalPols[t];
                    if (portal instanceof Polygon4V) {
                        Polygon4V var35 = (Polygon4V)portal;
                        portalVerts = new Vertex[]{var35.a, var35.b, var35.c, var35.d};
                    } else if (portal instanceof Polygon3V) {
                        Polygon3V var10 = (Polygon3V)portal;
                        portalVerts = new Vertex[]{var10.a, var10.b, var10.c};
                    } else {
                        portalVerts = null;
                    }
                    if (!HouseCreator.isExistsCommonCoords(room.getMesh(), portalVerts)) continue;
                    Mesh mesh = room.getMesh();
                    Vector3D roomCenter = HouseCreator.computeCentre(mesh.getVertices());
                    Vector3D portalCenter = HouseCreator.computeCentre(portalVerts);
                    Vector3D var32 = MathUtils2.calcNormal((Vertex)portalVerts[0], portalVerts[1], portalVerts[2]);
                    roomCenter.add(-portalCenter.x, -portalCenter.y, -portalCenter.z);
                    if (var32.dot(roomCenter) >= 0) {
                        HouseCreator.reverse(portalVerts);
                    }
                    portalsList.addElement(new Portal(portalVerts));
                }
                Object[] portals = new Portal[portalsList.size()];
                portalsList.copyInto(portals);
                room.setPortals((Portal[])portals);
                HouseCreator.findRooms(room, rooms);
            }
            HouseCreator.countPortals(rooms);
            Room[][] neighbours = HouseCreator.createNeighbours(rooms);
            house = new House(rooms, neighbours);
        } else {
            RenderObject[] polygons = meshes[0].getPolygons();
            Room[] rooms = new Room[1];
            Room[][] neighbours = new Room[1][1];
            rooms[0] = new Room(meshes[0], 0);
            neighbours[0][0] = rooms[0];
            house = new House(rooms, neighbours);
        }
        if (lightdataFile == null && (DirectX7.standartDrawmode == 9 || DirectX7.standartDrawmode == 13)) {
            LightMapper.generateLightMapSaveThread(house, meshes, lightdataFile);
        }
        return house;
    }

    private static void countPortals(Room[] roomsList) {
        int portalsFound = 0;
        int roomsFound = 0;
        for (int i = 0; i < roomsList.length; ++i) {
            Portal[] portals = roomsList[i].getPortals();
            if (portals == null || portals.length == 0) {
                ++roomsFound;
            }
            for (int t = 0; t < portals.length; ++t) {
                if (portals[t].getRoom() != null) continue;
                ++portalsFound;
            }
        }
        if (portalsFound > 0) {
            System.out.println("HouseCreator: " + portalsFound + " \u043f\u043e\u0440\u0442\u0430\u043b\u0430\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u043c\u043d\u0430\u0442\u044b");
        }
        if (roomsFound > 0) {
            System.out.println("HouseCreator: " + roomsFound + " \u043a\u043e\u043c\u043d\u0430\u0442\u0430\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u043e\u0440\u0442\u0430\u043b\u044b");
        }
    }

    private static Vector3D computeCentre(Vertex[] vertices) {
        long x = 0L;
        long y = 0L;
        long z = 0L;
        for (int i = 0; i < vertices.length; ++i) {
            Vertex v = vertices[i];
            x += (long)v.x;
            y += (long)v.y;
            z += (long)v.z;
        }
        return new Vector3D((int)(x /= (long)vertices.length), (int)(y /= (long)vertices.length), (int)(z /= (long)vertices.length));
    }

    private static void reverse(Vertex[] vertices) {
        Vertex[] newList = new Vertex[vertices.length];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = vertices[vertices.length - 1 - i];
        }
        System.arraycopy(newList, 0, vertices, 0, newList.length);
    }

    private static void findRooms(Room room, Room[] rooms) {
        Portal[] portals = room.getPortals();
        block0: for (int i = 0; i < portals.length; ++i) {
            Portal portal = portals[i];
            for (int t = 0; t < rooms.length; ++t) {
                Room var6 = rooms[t];
                if (var6 == room || !HouseCreator.isExistsCommonCoords(var6.getMesh(), portal.getVertices())) {
                    continue;
                }
                portal.setRoom(var6);
                continue block0;
            }
        }
    }

    private static Room[][] createNeighbours(Room[] rooms) {
        Room[][] neighbours = new Room[rooms.length][];
        for (int i = 0; i < neighbours.length; ++i) {
            Vector vRooms = HouseCreator.getRooms(rooms[i]);
            neighbours[i] = new Room[vRooms.size()];
            vRooms.copyInto(neighbours[i]);
        }
        return neighbours;
    }

    private static Vector getRooms(Room room) {
        Portal[] portals = room.getPortals();
        Vector<Room> rooms = new Vector<Room>();
        for (int i = 0; i < portals.length; ++i) {
            Portal p = portals[i];
            Room secondRoom = p.getRoom();
            if (secondRoom == null || rooms.contains(secondRoom)) continue;
            rooms.addElement(secondRoom);
        }
        return rooms;
    }

    private static boolean isExistsCommonCoords(Mesh mesh, Vertex[] poly) {
        for (int i = 0; i < poly.length; ++i) {
            boolean var10000;
            block3: {
                Vertex v = poly[i];
                Vertex[] verts = mesh.getVertices();
                for (int var5 = 0; var5 < verts.length; ++var5) {
                    Vertex var6 = verts[var5];
                    if (var6.x / 50 != v.x / 50 || var6.y / 50 != v.y / 50 || var6.z / 50 != v.z / 50) {
                        continue;
                    }
                    var10000 = true;
                    break block3;
                }
                var10000 = false;
            }
            if (!var10000) continue;
            return true;
        }
        return false;
    }
}

