/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.AI.BigZombie;
import code.AI.Bot;
import code.AI.NPC;
import code.AI.Player;
import code.AI.TPPose;
import code.AI.Zombie;
import code.AI.misc.Corpse;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.Character;
import code.Gameplay.Map.Dijkstra;
import code.Gameplay.Map.House;
import code.Gameplay.Map.Room;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Objects.GameObject;
import code.Gameplay.Objects.ItemsBag;
import code.Gameplay.Objects.NPCSpawner;
import code.Gameplay.Respawn;
import code.HUD.DeveloperMenu;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Sprite;
import code.utils.Main;
import code.utils.QFPS;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Scene {
    private final Random random;
    private Vector respawns;
    public String[] need = null;
    private Bot[] bots;
    private int frame = 0;
    public boolean exitWithoutWait;
    public int[] botLimiter;
    public DirectX7 g3d;
    public House house;
    private int miny;
    private Respawn start;
    private Vector tVec = new Vector();
    private Respawn finish;
    private Respawn[] enemies;
    private int frequency;
    private int max_enemy_count;
    private int enemy_count;
    private int part;
    public boolean deleteAnPart;
    public boolean alwaysExit = false;
    public static int gravity = -20;
    public Vector rmsBots;
    public boolean[] rmsBotsKilled;
    public Vector rmsObjects;
    public boolean[] rmsObjectsDestroyed;
    public Dijkstra ways;
    public Vector scriptsToExec;
    public TPPose camPose;

    public Scene(int width, int height, House house, Respawn start, Respawn finish, Respawn[] enemies, int max_enemy_count, int frequency, Main main, int zombie_count, boolean genWays) {
        this.random = new Random();
        this.respawns = new Vector();
        this.scriptsToExec = new Vector();
        this.g3d = new DirectX7(width, height);
        this.house = house;
        this.start = start;
        this.finish = finish;
        this.enemies = enemies;
        this.max_enemy_count = max_enemy_count;
        this.frequency = frequency;
        this.countWorldSize(house);
        if (genWays) {
            this.ways = new Dijkstra(house);
        }
        if (max_enemy_count < zombie_count) {
            zombie_count = max_enemy_count;
        }
        if (zombie_count < 1) {
            zombie_count = 1;
        }
        this.bots = new Bot[zombie_count];
        this.bots[0] = new BigZombie(new Vector3D());
        this.exitWithoutWait = false;
        if (this.bots.length > 1) {
            for (width = 1; width < this.bots.length; ++width) {
                this.bots[width] = new Zombie(new Vector3D());
            }
        }
        this.botLimiter = null;
    }

    public final void reset() {
        Vector var1 = this.house.getObjects();
        int var2 = 0;
        if (this.rmsBots != null) {
            this.rmsBots.removeAllElements();
        }
        if (this.rmsObjects != null) {
            this.rmsObjects.removeAllElements();
        }
        while (var2 < var1.size()) {
            this.house.removeObject((RoomObject)var1.elementAt(var2));
            ++var2;
        }
        if (this.enemies != null) {
            for (var2 = 0; var2 < this.enemies.length; ++var2) {
                Respawn resp = this.enemies[var2];
                if (resp.mode < -127) continue;
                resp.mode = (byte)-127;
            }
        }
        this.frame = 0;
        this.enemy_count = 0;
        this.part = -1;
    }

    public final void destroy() {
        this.g3d.destroy();
        this.g3d = null;
        this.house.destroy();
        this.scriptsToExec.removeAllElements();
        this.scriptsToExec = null;
        this.house = null;
        this.need = null;
        if (this.bots.length > 0) {
            for (int i = 0; i < this.bots.length; ++i) {
                this.bots[i].destroy();
                this.bots[i] = null;
            }
        }
        this.bots = null;
        this.botLimiter = null;
        if (this.rmsBots != null) {
            this.rmsBots.removeAllElements();
        }
        if (this.rmsObjects != null) {
            this.rmsBots.removeAllElements();
        }
        this.rmsObjects = null;
        this.rmsBots = null;
    }

    private void countWorldSize(House house) {
        int var2 = Integer.MAX_VALUE;
        int var3 = Integer.MIN_VALUE;
        int var4 = Integer.MAX_VALUE;
        int var5 = Integer.MIN_VALUE;
        int var6 = Integer.MAX_VALUE;
        int var7 = Integer.MIN_VALUE;
        Room[] var11 = house.getRooms();
        for (int var8 = 0; var8 < var11.length; ++var8) {
            Room var9 = var11[var8];
            var2 = Math.min(var2, var9.getMinX());
            var4 = Math.min(var4, var9.getMinY());
            var6 = Math.min(var6, var9.getMinZ());
            var3 = Math.max(var3, var9.getMaxX());
            var5 = Math.max(var5, var9.getMaxY());
            var7 = Math.max(var7, var9.getMaxZ());
        }
        System.out.println("World size:");
        System.out.println("Size X " + (var3 - var2));
        System.out.println("Size Y " + (var5 - var4));
        System.out.println("Size Z " + (var7 - var6));
        this.miny = var4;
    }

    private int random(int x) {
        return Math.abs(this.random.nextInt()) % x;
    }

    public final Vector3D getStartPoint() {
        if (this.start == null) {
            return null;
        }
        return this.start.point;
    }

    public final Vector3D getFinishPoint() {
        if (this.finish == null) {
            return null;
        }
        return this.finish.point;
    }

    private void addRespawn(int part, Vector respawns) {
        if (this.enemies != null) {
            for (int var3 = 0; var3 < this.enemies.length; ++var3) {
                Respawn var4 = this.enemies[var3];
                if (var4.part == part) {
                    if (var4.mode != -128 && var4.mode >= var4.cmode) continue;
                    respawns.addElement(var4);
                    continue;
                }
                if (!this.enemies[var3].respa) continue;
                this.enemies[var3].mode = (byte)-127;
            }
        }
    }

    public final int render(Graphics g, int[] parts, Player player) {
        int count = this.house.render(g, this.g3d, parts, player.getCharacter().getTransform().m03, player.getCharacter().getTransform().m23);
        return count;
    }

    public final int render(Graphics g, int part, Player player) {
        int count = this.house.render(g, this.g3d, part, player.getCharacter().getTransform().m03, player.getCharacter().getTransform().m23);
        return count;
    }

    public final void flush(Graphics g, int x, int y) {
        this.g3d.flush(g, 0, y);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void update(Player player, GameScreen gs) {
        GameObject obj;
        int i;
        Vector objects;
        int playerPart;
        block24: {
            while (!this.scriptsToExec.isEmpty()) {
                Object[] mass = (Object[])this.scriptsToExec.elementAt(0);
                if (mass[0] != null) {
                    ((RoomObject)mass[0]).give((String[])mass[1], player, this.house, gs);
                }
                this.scriptsToExec.removeElementAt(0);
            }
            playerPart = player.getPart();
            objects = Main.updateOnlyNear ? this.house.getNearObjects(player.getPart()) : this.house.getObjects();
            if (this.frame % 5 != 0) break block24;
            for (i = 0; i < objects.size(); ++i) {
                boolean near;
                block27: {
                    int tmppart;
                    block26: {
                        block25: {
                            if (!(objects.elementAt(i) instanceof GameObject)) continue;
                            obj = (GameObject)objects.elementAt(i);
                            tmppart = obj.getPart();
                            if (tmppart == -1 || playerPart == -1) break block25;
                            if (playerPart != tmppart) break block26;
                            near = true;
                            break block27;
                        }
                        near = false;
                        break block27;
                    }
                    Room[] var12 = this.house.getNeighbourRooms(playerPart);
                    int i2 = 0;
                    while (true) {
                        if (i2 >= var12.length) {
                            near = false;
                            break;
                        }
                        if (var12[i2].getId() == tmppart) {
                            near = true;
                            break;
                        }
                        ++i2;
                    }
                }
                if (!(obj instanceof Zombie) && !(obj instanceof BigZombie) || !this.deleteAnPart) {
                    near = true;
                }
                if (near && obj.getPart() != -1 && obj.getCharacter().getTransform().m13 >= this.miny << 1) continue;
                if (obj instanceof Zombie || obj instanceof BigZombie) {
                    if (obj.isDead()) continue;
                    --this.enemy_count;
                    this.house.removeObject(obj);
                    continue;
                }
                if (obj instanceof Player) continue;
                this.house.removeObject(obj);
            }
        }
        objects = Main.updateOnlyNear ? this.house.getNearObjects(player.getPart()) : this.house.getObjects();
        for (i = 0; i < objects.size(); ++i) {
            if (!(objects.elementAt(i) instanceof GameObject) || !(obj = (GameObject)objects.elementAt(i)).isTimeToRenew()) continue;
            if (Main.corpses) {
                Corpse corpse;
                Bot zom;
                if (obj instanceof Zombie) {
                    zom = (Zombie)obj;
                    corpse = new Corpse(((Zombie)zom).meshImage.getAnimation().getFrame(), zom.getCharacter().getTransform(), ((Zombie)zom).meshImage, Zombie.texture);
                    this.house.addObject(corpse);
                }
                if (obj instanceof BigZombie) {
                    zom = (BigZombie)obj;
                    corpse = new Corpse(((BigZombie)zom).meshImage.getAnimation().getFrame(), zom.getCharacter().getTransform(), ((BigZombie)zom).meshImage, BigZombie.texture);
                    this.house.addObject(corpse);
                }
                if (obj instanceof NPC) {
                    NPC npc = (NPC)obj;
                    if (npc.currentSprite != null) {
                        corpse = new Corpse(0, npc.getCharacter().getTransform(), null, null);
                        corpse.spr = new Sprite(npc.currentSprite.textures[npc.currentSprite.textures.length - 1], npc.currentSprite.scale);
                        corpse.spr.mirX = npc.currentSprite.mirX;
                        this.house.addObject(corpse);
                    } else if (npc.meshImage != null) {
                        corpse = new Corpse(npc.meshImage.getAnimation().getFrame(), npc.getCharacter().getTransform(), npc.meshImage, npc.mt);
                        this.house.addObject(corpse);
                    }
                }
            }
            this.house.removeObject(obj);
        }
        objects = Main.updateOnlyNear ? this.house.getNearObjects(player.getPart()) : this.house.getObjects();
        if (this.part != playerPart || this.frame % this.frequency == 0) {
            int px = player.getPosX();
            int pz = player.getPosZ();
            int rad = player.getCharacter().getRadius() * 7;
            if (this.enemy_count < this.max_enemy_count) {
                for (int i2 = 0; i2 < this.bots.length && this.enemy_count < this.max_enemy_count; ++i2) {
                    Respawn respawn;
                    Bot bot = this.bots[i2];
                    if (bot instanceof BigZombie && this.random(8) != 0 || objects.contains(bot)) continue;
                    if (playerPart == -1) {
                        respawn = null;
                    } else {
                        this.respawns.removeAllElements();
                        this.addRespawn(playerPart, this.respawns);
                        Room[] rooms = this.house.getNeighbourRooms(playerPart);
                        if (rooms != null && rooms.length > 0) {
                            for (int i3 = 0; i3 < rooms.length; ++i3) {
                                if (rooms[i3] == null) continue;
                                this.addRespawn(rooms[i3].getId(), this.respawns);
                            }
                        }
                        Respawn respawn2 = respawn = this.respawns.isEmpty() ? null : (Respawn)this.respawns.elementAt(this.random(this.respawns.size()));
                    }
                    if (respawn == null || respawn.mode != -128 && respawn.mode >= respawn.cmode) continue;
                    Vector3D point = respawn.point;
                    int z = point.z;
                    int x = point.x;
                    if ((z = pz - z) * z + (x = px - x) * x <= rad * rad) continue;
                    bot.set(point);
                    if (respawn.mode > -128 && respawn.cmode < 127) {
                        respawn.mode = (byte)(respawn.mode + 1);
                    }
                    this.house.addObject(bot);
                    ++this.enemy_count;
                }
            }
            this.part = playerPart;
        }
        this.recomputePart(player, gs);
        ++this.frame;
    }

    public final void recomputePart(Player player, GameScreen gs) {
        this.house.recomputePart(player);
        Vector objects = Main.updateOnlyNear ? this.house.getNearObjects(player.getPart()) : this.house.getObjects();
        if (objects.size() > 0) {
            for (int i = 0; i < objects.size(); ++i) {
                RoomObject ob = (RoomObject)objects.elementAt(i);
                if (!(ob instanceof Player)) {
                    this.house.recomputePart(ob);
                }
                Vector nearObjects = null;
                if (Main.updateOnlyNearPhysics) {
                    nearObjects = this.house.getNearObjects(ob.getPart());
                }
                if (objects.elementAt(i) instanceof GameObject) {
                    GameObject obj = (GameObject)objects.elementAt(i);
                    for (int i2 = i + 1; i2 < objects.size(); ++i2) {
                        if (!(objects.elementAt(i2) instanceof GameObject)) continue;
                        GameObject obj2 = (GameObject)objects.elementAt(i2);
                        if (Main.updateOnlyNearPhysics && !nearObjects.contains(obj2) || obj2 == obj) continue;
                        Character.collisionTest(obj2.getCharacter(), obj.getCharacter());
                    }
                    Vector3D speed = obj.getCharacter().getSpeed();
                    if (!(obj.getPart() == -1 || !obj.getCharacter().isCollider() || obj instanceof Player && DeveloperMenu.debugMode && obj.character.fly)) {
                        speed.y += gravity * QFPS.frameTime / 50;
                    }
                    obj.update(this, player);
                    continue;
                }
                if (!(objects.elementAt(i) instanceof NPCSpawner)) continue;
                ((NPCSpawner)objects.elementAt(i)).update(this, player, gs);
            }
        }
    }

    public final House getHouse() {
        return this.house;
    }

    public final DirectX7 getG3D() {
        return this.g3d;
    }

    public final int getFrame() {
        return this.frame;
    }

    public final int getEnemyCount() {
        return this.max_enemy_count;
    }

    public final boolean isLevelCompleted(Player player) {
        if (this.finish == null) {
            return false;
        }
        Character var3 = player.getCharacter();
        Matrix var4 = var3.getTransform();
        Vector3D var2 = this.finish.point;
        int var10000 = var4.m03;
        int var10001 = var4.m13;
        int var10002 = var4.m23;
        int var10003 = var2.x;
        int var10004 = var2.y;
        int var10005 = var2.z;
        int var8 = var3.getRadius() * 2;
        int var7 = var10005;
        int var6 = var10004;
        int var5 = var10003;
        int var11 = var10002;
        int var10 = var10001;
        int var9 = var10000;
        var9 = var5 - var9;
        var10 = var6 - var10;
        var11 = var7 - var11;
        return Math.abs(var9) <= var8 && Math.abs(var10) <= var8 && Math.abs(var11) <= var8 && var9 * var9 + var10 * var10 + var11 * var11 <= var8 * var8 && this.isWinner(player);
    }

    public final boolean isWinner(Player player) {
        if (!this.isAllCollected(Player.usedPoints)) {
            return false;
        }
        if (player.frags >= this.max_enemy_count) {
            return true;
        }
        return this.alwaysExit;
    }

    public boolean isAllCollected(Vector points) {
        if (this.need == null) {
            return true;
        }
        for (int i = 0; i < this.need.length; ++i) {
            if (this.contains(points, this.need[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Vector points, String name) {
        for (int i = 0; i < points.size(); ++i) {
            String pName = (String)points.elementAt(i);
            if (pName == null || !pName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public RoomObject findObject(boolean isclickable2, Player player, int yy, GameScreen gs) {
        Vector objs = Main.updateOnlyNear ? this.house.getNearObjects(player.getPart()) : this.house.getObjects();
        for (int i = 0; i < objs.size(); ++i) {
            RoomObject obj = (RoomObject)objs.elementAt(i);
            if (!obj.activable || obj.clickable != isclickable2) continue;
            if (!(this.distance(obj, player) > obj.radius * obj.radius || !obj.clickable && obj.near || obj.activated && obj.singleUse || !obj.check(this.g3d, yy))) {
                obj.near = true;
                boolean ret = true;
                if (obj.need != null && !obj.isAllCollected(Player.usedPoints, player, this.house, gs) && obj.errMessage == null) {
                    ret = false;
                }
                if (ret && (obj.lastActivate < 0L || obj.lastActivate + obj.timeToReset <= GameScreen.time)) {
                    return obj;
                }
            }
            if (this.distance(obj, player) <= obj.radius * obj.radius) continue;
            obj.near = false;
        }
        return null;
    }

    public RoomObject activateObject(boolean isclickable2, Player player, int yy, GameScreen gs) {
        Vector objs = Main.updateOnlyNear ? this.house.getNearObjects(player.getPart()) : this.house.getObjects();
        RoomObject used = null;
        for (int i = 0; i < objs.size(); ++i) {
            RoomObject obj = (RoomObject)objs.elementAt(i);
            if (!obj.activable || obj.clickable != isclickable2) continue;
            if (!(this.distance(obj, player) > obj.radius * obj.radius || !obj.clickable && obj.near && !obj.alwaysActivate || obj.activated && obj.singleUse || !obj.check(this.g3d, yy))) {
                obj.near = true;
                boolean ret = true;
                if (obj.need != null && !obj.isAllCollected(Player.usedPoints, player, this.house, gs) && obj.errMessage == null) {
                    ret = false;
                }
                if (ret && (obj.lastActivate < 0L || obj.lastActivate + obj.timeToReset <= GameScreen.time)) {
                    obj.activate(this.house, player, gs);
                    used = obj;
                    if (obj.activateOnlyOne) {
                        return used;
                    }
                }
            }
            if (this.distance(obj, player) <= obj.radius * obj.radius) continue;
            obj.near = false;
        }
        return used;
    }

    public void deleteUsedObjects(Player player) {
        RoomObject obj;
        int i;
        Vector objs = this.house.getObjects();
        for (i = 0; i < objs.size(); ++i) {
            obj = (RoomObject)objs.elementAt(i);
            if (!RoomObject.containsSimple(Player.usedPoints, obj.name) || !obj.reloadDestroy || !obj.destroyOnUse) continue;
            this.house.removeObject(obj);
        }
        if (this.rmsObjectsDestroyed != null && this.rmsObjects != null && !this.rmsObjects.isEmpty()) {
            for (i = 0; i < this.rmsObjectsDestroyed.length; ++i) {
                if (!this.rmsObjectsDestroyed[i] || this.rmsObjectsDestroyed.length > this.rmsObjects.size()) continue;
                obj = (RoomObject)this.rmsObjects.elementAt(i);
                this.house.removeObject(obj);
            }
        }
    }

    public void drawPoints(Graphics g, int yy, Player player) {
        Vector objs = this.house.getNearObjects(player.getPart());
        for (int i = 0; i < objs.size(); ++i) {
            RoomObject obj = (RoomObject)objs.elementAt(i);
            long dist = this.distance(obj, player);
            if (dist >= 1600000000L || !this.house.isNear(obj.getPart(), player.getPart())) continue;
            obj.drawDebug(g, this.g3d, yy, dist <= obj.radius * obj.radius, this.house);
        }
    }

    public final long distance(RoomObject obj1, RoomObject obj2) {
        int var3 = obj1.getPosX() - obj2.getPosX();
        int var4 = obj1.getPosY() - obj2.getPosY();
        int var6 = obj1.getPosZ() - obj2.getPosZ();
        return (long)var3 * (long)var3 + (long)var4 * (long)var4 + (long)var6 * (long)var6;
    }

    public void removeKilledBots() {
        if (this.rmsBotsKilled != null && this.rmsBots != null && !this.rmsBots.isEmpty()) {
            for (int i = 0; i < this.rmsBotsKilled.length; ++i) {
                if (!this.rmsBotsKilled[i] || this.rmsBotsKilled.length > this.rmsBots.size()) continue;
                RoomObject obj = (RoomObject)this.rmsBots.elementAt(i);
                this.house.removeObject(obj);
            }
        }
    }

    public int getNext(int start, int finish) {
        if (this.ways == null) {
            return finish;
        }
        return this.ways.getNext(start, finish);
    }

    public Vector getItemBags() {
        Vector<ItemsBag> items = new Vector<ItemsBag>();
        Vector objs = this.house.getObjects();
        for (int i = 0; i < objs.size(); ++i) {
            RoomObject obj = (RoomObject)objs.elementAt(i);
            if (!(obj instanceof ItemsBag)) continue;
            items.addElement((ItemsBag)obj);
        }
        return items;
    }

    public Player findPlayer() {
        Vector objects = this.house.getObjects();
        for (int i = 0; i < objects.size(); ++i) {
            RoomObject obj = (RoomObject)objects.elementAt(i);
            if (!(obj instanceof Player)) continue;
            return (Player)obj;
        }
        return null;
    }

    public void dropItem(String name, int count, Player player) {
        this.dropItem(name, count, player.getPosX(), player.getPosY(), player.getPosZ(), player.getPart());
    }

    public void dropItem(String name, int count, int x, int y, int z) {
        this.dropItem(name, count, x, y, z, -1);
    }

    public void dropItem(String name, int count, int x, int y, int z, int part) {
        if (count <= 0) {
            return;
        }
        Vector objs = this.house.getObjects();
        ItemsBag bag = null;
        for (int i = 0; i < objs.size(); ++i) {
            RoomObject obj = (RoomObject)objs.elementAt(i);
            int dist = (x - obj.getPosX()) * (x - obj.getPosX()) + (y - obj.getPosY()) * (y - obj.getPosY()) + (z - obj.getPosZ()) * (z - obj.getPosZ());
            if (dist > 640000 || !(obj instanceof ItemsBag)) continue;
            bag = (ItemsBag)obj;
            break;
        }
        if (bag == null) {
            bag = new ItemsBag(new Vector3D(x, y, z));
            this.house.addObject(bag);
        }
        bag.items.addItem(name, count);
    }

    public void runScript(Object[] obj) {
        this.scriptsToExec.addElement(obj);
    }
}

