/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.Audio.MusicPlayer;
import com.Gameplay.Arsenal;
import com.Gameplay.DialogScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Gameplay.Respawn;
import com.Gameplay.Shop;
import com.Gameplay.Weapon;
import com.HUD.Base.Font;
import com.HUD.Base.Keyboard;
import com.HUD.GUIScreen;
import com.HUD.Menu;
import com.HUD.MyCanvas.MainCanvas;
import com.HUD.MyCanvas.MyCanvas;
import com.HUD.PauseScreen;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Camera;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.misc.Asset;
import com.misc.DelayedDialog;
import com.misc.ImageResize;
import com.misc.Main;
import com.misc.Stringer;
import com.misc.WeatherGenerator;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Player;

public final class GameScreen
extends MyCanvas {
    public float x_counter = 0.0f;
    public float y_counter = 0.0f;
    private boolean finishDraw = true;
    public static Vector lines = new Vector();
    public static Camera cam = null;
    private Object sear = null;
    public long musTime = 0L;
    public Main main;
    private static int icohei;
    private long usmem = 0L;
    public Vector3D newPos;
    public static String mus;
    public static String levelFile;
    private final Font font;
    private GameObject camera;
    public final int levelNumber;
    private final Object hudInfo;
    public static int width;
    public static int height;
    private static int widtho;
    private static int heighto;
    private static int pst;
    public int[] shopItems;
    private boolean changed = true;
    private Keyboard keys;
    private int key;
    private int x;
    private int y;
    private int dirX;
    private int dirY;
    private boolean run;
    public boolean paused = false;
    private int framesToEnd = 0;
    private int framesToExit = 0;
    private int hp;
    private int rounds;
    private int money;
    public static Vector delayDialogs;
    private int frags;
    public com.AI.Player player;
    public Scene scene;
    private Image imgSight;
    private Image imgLife;
    private Image imgPatron;
    private Image imgMoney;
    private Image imgSkull;
    private Image imgHand;
    private int frs = 0;
    public static boolean bloom;
    private int renderedRooms = 0;
    private int parts = 0;
    public String customMessage = null;
    public boolean customMessagePause = false;
    public long customMessageEndTime = 0L;
    public DialogScreen dialogScreen;
    public WeatherGenerator wg;
    public Image overlay;
    public long overlayStart = 0L;
    public long overlayTimeOut = 0L;

    public GameScreen(Main main, int levelNumber, Object hudInfo) {
        levelFile = "/level" + levelNumber + ".txt";
        this.levelNumber = levelNumber;
        this.font = Main.getFont();
        this.main = main;
        this.hudInfo = hudInfo;
        this.shopItems = Shop.allitems;
        width = this.getWidth();
        height = this.getHeight();
        widtho = this.getWidth();
        heighto = this.getHeight();
        this.finishDraw = true;
        try {
            this.sear = null;
            delayDialogs.removeAllElements();
            this.musTime = 0L;
            pst = 0;
            bloom = false;
            Fps.reset();
            this.keys = new Keyboard(this);
            String path = Main.life_icon;
            if (Main.getGameText().getString2(path) != null) {
                path = Main.getGameText().getString2(path);
            }
            this.imgLife = this.createImage2(path);
            path = Main.patron_icon;
            if (Main.getGameText().getString2(path) != null) {
                path = Main.getGameText().getString2(path);
            }
            this.imgPatron = this.createImage2(path);
            path = Main.money_icon;
            if (Main.getGameText().getString2(path) != null) {
                path = Main.getGameText().getString2(path);
            }
            this.imgMoney = this.createImage2(path);
            path = Main.skull_icon;
            if (Main.getGameText().getString2(path) != null) {
                path = Main.getGameText().getString2(path);
            }
            this.scene = Respawn.createScene(width, (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)), levelFile, main, this);
            path = Main.sight_icon;
            if (Main.getGameText().getString2(path) != null) {
                path = Main.getGameText().getString2(path);
            }
            this.imgSight = !Main.originalSight ? (!Main.fullScreenSight ? this.createImage2(path) : this.createImageFullScr(path)) : Image.createImage((String)path);
            path = Main.hand_icon;
            if (Main.getGameText().getString2(path) != null) {
                path = Main.getGameText().getString2(path);
            }
            this.imgHand = !Main.originalUseIcon ? this.createImage2(path) : Image.createImage((String)path);
            icohei = Main.getDisplaySize() <= 80 ? (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)) : height * 8 / 10;
            this.player = new com.AI.Player(this.scene.getG3D().getnWidth(), (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)), this.scene.getStartPoint(), this.hudInfo);
            this.camera = this.player;
            if (!Main.isLastLevel(levelNumber)) {
                String st = new Stringer(Mesh.getStringFromResource("/level" + (levelNumber + 1) + ".txt")).getString("START");
                if (st != null) {
                    int[] ps = Mesh.cutOnInts(st, ',');
                    this.newPos = new Vector3D(ps[0], ps[1], ps[2]);
                } else {
                    this.newPos = new Vector3D(0, 0, 0);
                }
            }
            com.AI.Player.usedPoints.removeAllElements();
            Respawn.loadObjects(levelFile, this.scene, this.player, false);
            this.scene.getHouse().addObject(this.player);
            this.scene.deleteUsedObjects(this.player);
            this.dialogScreen = new DialogScreen(this.font, this.scene.getG3D(), main, this);
            Player oldpl = MusicPlayer.player;
            this.init();
            if (oldpl == null) {
                this.startMus(0L);
            }
            this.changed = true;
            Fps.reset();
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }

    private Image createImageFullScr(String file) {
        try {
            return Arsenal.resize(Image.createImage((String)file), width, height * Main.displaySize / 100);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    private Image createImage(String file) {
        try {
            return Arsenal.resize(Image.createImage((String)file), (float)width / 240.0f, (float)height / 320.0f);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    private Image createImage2(String file) {
        try {
            if (width < height) {
                return Arsenal.resize(Image.createImage((String)file), (float)width / 240.0f, (float)width / 240.0f);
            }
            return Arsenal.resize(Image.createImage((String)file), (float)height / 320.0f, (float)height / 320.0f);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    private final void drawMessage2(Graphics g, String str) {
        Graphics3D var3 = this.scene.getG3D();
        int var4 = height / 2 - var3.getHeight() / 2;
        var4 = var3.getHeight() / 2 + this.imgSight.getHeight() + var4;
        Main.drawBck(g, var4 - this.font.height() / 2, var4 + this.font.height() / 2);
        this.font.drawString(g, str, var3.getWidth() / 2, var4, 3);
    }

    public void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean destroyMus) {
        try {
            this.newPos = null;
            this.sear = null;
            delayDialogs.removeAllElements();
            this.scene.destroy();
            Asset.clear();
            this.scene = null;
            this.player.destroy();
            this.player = null;
            Main.zombiemod = null;
            Main.zombietex = null;
            Main.bigzombiemod = null;
            Main.bigzombietex = null;
            this.dialogScreen = null;
            pst = 0;
            cam = null;
            this.imgSkull = null;
            this.imgMoney = null;
            this.imgPatron = null;
            this.imgHand = null;
            this.imgLife = null;
            this.imgSight = null;
            if (destroyMus) {
                this.destroyMusic();
            }
            Mesh.resetBuffer();
            System.gc();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    private final void drawMessage(Graphics g, String str) {
        Graphics3D var3 = this.scene.getG3D();
        int var4 = height / 2 + height * Math.min(Main.getDisplaySize(), 80) / 100 / 2 - this.font.height() / 2;
        int x = var3.getnWidth() / 2;
        int y = var4;
        Main.drawBck(g, var4 - this.font.height() / 2, var4 + this.font.height() / 2);
        this.font.drawString(g, str, x, y, 3);
    }

    private final void drawMessageCustom(Graphics g) {
        Graphics3D var3 = this.scene.getG3D();
        int lsize = lines.size();
        int var4 = height / 2 + height * Math.min(Main.getDisplaySize(), 80) / 100 / 2 - this.font.height() / 2;
        int x = var3.getnWidth() / 2;
        int y = var4 - this.font.height() * (lsize - 1);
        Main.drawBck(g, y - this.font.height() / 2, y + lsize * this.font.height() - this.font.height() / 2);
        for (int i = 0; i < lsize; ++i) {
            String str = (String)lines.elementAt(i);
            this.font.drawString(g, str, x, y + i * this.font.height(), 3);
        }
    }

    public void fillLines(String str, Vector lines) {
        int var3 = 0;
        int var4 = 0;
        int var5 = -1;
        int var6 = 0;
        while (var6 < str.length()) {
            char var7 = str.charAt(var6);
            if (var7 == ' ') {
                var5 = var6;
            }
            if (var7 != '\n' && var3 + this.font.widthOf(var7) <= width) {
                var3 += this.font.widthOf(var7);
                ++var6;
                continue;
            }
            int var8 = var4;
            if (var7 == '\n') {
                var8 = var6++;
            } else if (var3 + this.font.widthOf(var7) > width) {
                if (var5 != -1) {
                    var8 = var5;
                    var6 = var5;
                } else {
                    var8 = var6;
                }
            }
            String var9 = str.substring(var4, var8);
            lines.addElement(var9);
            var3 = 0;
            var4 = var6;
        }
        if (var4 < str.length()) {
            lines.addElement(str.substring(var4, str.length()));
        }
    }

    public final void paint(Graphics g) {
        int heightz;
        int var4;
        boolean var3;
        long begintime;
        block78: {
            block77: {
                Graphics3D var2;
                block76: {
                    if (this.paused || !this.run || !this.finishDraw) {
                        return;
                    }
                    this.finishDraw = false;
                    begintime = System.currentTimeMillis();
                    this.frs = Fps.fps() / 10;
                    if ((MainCanvas.mouse_x != MainCanvas.scrWidth / 2 || MainCanvas.mouse_y != MainCanvas.scrHeight / 2) && MainCanvas.ignoreSensor) {
                        float mouse_speed = (!this.player.zoom ? 0.4f : 0.175f) * (float)Main.mouseSpeed / 50.0f;
                        this.x_counter += (float)(MainCanvas.mouse_x - MainCanvas.scrWidth / 2) * mouse_speed;
                        this.y_counter += (float)(MainCanvas.mouse_y - MainCanvas.scrHeight / 2) * mouse_speed;
                        int xr = 0;
                        int yr = 0;
                        while (this.x_counter > 1.0f) {
                            this.x_counter -= 1.0f;
                            ++xr;
                        }
                        while (this.y_counter > 1.0f) {
                            this.y_counter -= 1.0f;
                            ++yr;
                        }
                        while (this.x_counter < 1.0f) {
                            this.x_counter += 1.0f;
                            --xr;
                        }
                        while (this.y_counter < 1.0f) {
                            this.y_counter += 1.0f;
                            --yr;
                        }
                        this.player.getCharacter().getTransform().rotY(-xr);
                        this.player.rotXn(-yr);
                        if (this.wg != null) {
                            this.wg.moveY(-yr, Fps.getFps());
                        }
                        if (this.wg != null) {
                            this.wg.moveX2(-xr, Fps.getFps());
                        }
                        if (cam != null) {
                            cam.addAngle(-yr);
                        }
                    }
                    var2 = this.scene.getG3D();
                    if (this.wg != null) {
                        this.wg.update(Fps.getFps(), -(Graphics3D.camera.m12 * 90 / Matrix.FP));
                    }
                    g.setClip(0, 0, this.getWidth(), this.getHeight());
                    g.translate(0, 0);
                    var3 = this.player.isDead();
                    var4 = this.camera.getCharacter().getHeight();
                    if (var3 && (var4 = (int)((float)var4 / Math.max(0.4f * (float)this.camera.getFrame(), 1.0f))) < this.camera.getCharacter().getRadius()) {
                        var4 = this.camera.getCharacter().getRadius();
                    }
                    Matrix var5 = this.camera.getCharacter().getTransform();
                    if (cam == null) {
                        var5.m13 += var4;
                        var2.setCamera(var5);
                    }
                    if (cam != null) {
                        cam.set(var5);
                        cam.calcPart(this.scene.getHouse());
                        var2.setCamera(cam.getCamera());
                    }
                    try {
                        if (Arsenal.currentWeapon() != null && !Arsenal.currentWeapon().hasZoom) {
                            this.player.zoom = false;
                        }
                        if (Arsenal.currentWeapon() != null) {
                            this.player.minFov = Arsenal.currentWeapon().minZoom;
                            this.player.maxFov = Arsenal.currentWeapon().maxZoom;
                        }
                        if (this.player.zoom && Arsenal.currentWeapon() == null && !Main.hasZoom) {
                            this.player.zoom = false;
                        }
                        if (Arsenal.currentWeapon() == null && Main.hasZoom) {
                            this.player.minFov = Main.minZoom;
                            this.player.maxFov = Main.maxZoom;
                        }
                        if (this.player.zoom && this.player.fov != this.player.maxFov || this.player.fov != this.player.minFov && !this.player.zoom) {
                            if (this.player.zoom) {
                                this.player.fov = (int)((long)this.player.fov + (System.currentTimeMillis() - this.player.lastZoomAction) * (long)(this.player.maxFov - this.player.minFov) / 200L);
                            }
                            if (!this.player.zoom) {
                                this.player.fov = (int)((long)this.player.fov - (System.currentTimeMillis() - this.player.lastZoomAction) * (long)(this.player.maxFov - this.player.minFov) / 200L);
                            }
                            if (this.player.zoom && this.player.fov > this.player.maxFov) {
                                this.player.fov = this.player.maxFov;
                            }
                            if (!this.player.zoom && this.player.fov < this.player.minFov) {
                                this.player.fov = this.player.minFov;
                            }
                            this.scene.getG3D().updateFov(this.player.fov);
                        }
                        this.player.lastZoomAction = System.currentTimeMillis();
                        this.parts = House.getParts(this.scene.getHouse(), this.camera.getPart(), var5).length;
                        this.renderedRooms = this.scene.render(House.getParts(this.scene.getHouse(), this.camera.getPart(), var5), this.player);
                        if (cam == null) {
                            var5.m13 -= var4;
                        }
                    }
                    catch (Exception ext) {
                        if (!Main.debug) break block76;
                        ext.printStackTrace();
                    }
                }
                var4 = height / 2 - var2.getnHeight() / 2;
                try {
                    if (var3) {
                        int[] var12 = var2.getDisplay();
                        this.deathScr(var12);
                    }
                    if (this.player.isDamaged()) {
                        this.damageScr(var2.getDisplay());
                    }
                    if (bloom) {
                        this.fastbloomScr(var2);
                    }
                }
                catch (Exception ext) {
                    if (!Main.debug) break block77;
                    ext.printStackTrace();
                }
            }
            try {
                this.scene.flush(g, 0, var4);
            }
            catch (Exception ext) {
                if (!Main.debug) break block78;
                ext.printStackTrace();
            }
        }
        if (this.wg != null) {
            Graphics3D g3d = this.scene.getG3D();
            heightz = height / 2 - g3d.getnHeight() / 2;
            g.clipRect(0, heightz, g3d.getnWidth(), g3d.getnHeight());
            this.wg.paint(g, height * (100 - Main.getDisplaySize()) / 200);
            g.clipRect(0, 0, width, height);
        }
        if (this.overlay != null && System.currentTimeMillis() - this.overlayStart < this.overlayTimeOut) {
            g.drawImage(this.overlay, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        if (this.overlay != null && System.currentTimeMillis() - this.overlayStart >= this.overlayTimeOut) {
            this.overlay = null;
        }
        if (!Main.hideHud) {
            RoomObject tmps;
            if (!var3) {
                g.setClip(0, var4, this.scene.getG3D().getnWidth(), this.scene.getG3D().getnHeight());
                if (cam == null && Arsenal.current != -1) {
                    Arsenal.drawWeapon(g, var4, this.scene.getG3D().getnWidth(), this.scene.getG3D().getnHeight(), this);
                }
                g.setClip(0, 0, width, height);
            }
            if (!(cam != null || Arsenal.currentWeapon() == null && Main.hidesight || (Arsenal.currentWeapon() == null || this.player.zoom) && Arsenal.currentWeapon() != null || this.imgHand != null && this.sear != null && MainCanvas.ignoreSensor)) {
                g.drawImage(this.imgSight, this.scene.getG3D().getnWidth() / 2, var4 + this.scene.getG3D().getnHeight() / 2, 3);
            }
            if (var3) {
                this.drawMessage2(g, Main.getGameText$6783a6a7().getString2("GAME_OVER"));
            } else if (this.framesToEnd > 0) {
                if (!Main.isLastLevel(this.levelNumber)) {
                    if (!this.scene.ne && Main.getGameText$6783a6a7().getString2("LEVEL_COMPLETE") != null) {
                        this.drawMessage2(g, Main.getGameText$6783a6a7().getString2("LEVEL_COMPLETE"));
                    }
                } else {
                    System.out.println("Levels:" + this.levelNumber + "/" + Main.lastLevel);
                    if (Main.getGameText$6783a6a7().getString2("GAME_COMPLETE") != null) {
                        this.drawMessage2(g, Main.getGameText$6783a6a7().getString2("GAME_COMPLETE"));
                    }
                }
            } else if (this.framesToExit > 0 && this.framesToExit < 45) {
                if (Main.getGameText$6783a6a7().getString2("FIND_EXIT") != null) {
                    this.drawMessage2(g, Main.getGameText$6783a6a7().getString2("FIND_EXIT"));
                }
            } else if (this.player.getHp() <= 15 && this.customMessage == null) {
                if (this.scene.getFrame() / 8 % 2 == 0) {
                    this.drawMessage(g, Main.getGameText$6783a6a7().getString2("BUY_MEDICINE_CHEST"));
                }
            } else if (Arsenal.current != -1 && Arsenal.currentWeapon() != null && Arsenal.currentWeapon().patronbuy && Arsenal.currentWeapon().getAmmo() <= 20 && this.scene.getFrame() / 8 % 2 == 0 && this.customMessage == null) {
                this.drawMessage(g, Main.getGameText$6783a6a7().getString2("BUY_PATRONS"));
            }
            if (Fps.nFrame == 1) {
                this.usmem = Runtime.getRuntime().totalMemory() / 1024L - Runtime.getRuntime().freeMemory() / 1024L;
            }
            if (this.changed || Main.getDisplaySize() > 80) {
                g.setColor(0);
                g.fillRect(0, 0, width, var4);
                g.fillRect(0, var4 + this.scene.getG3D().getnHeight(), width, height - (var4 + this.scene.getG3D().getnHeight()));
                int var10 = (height - icohei) / 4;
                if (this.imgMoney != null) {
                    g.drawImage(this.imgMoney, 4, var10, 6);
                    this.font.drawString(g, " " + this.player.getMoney(), 4 + this.imgMoney.getWidth(), var10, 6);
                }
                if (!this.scene.alwaysExit && this.imgSkull != null) {
                    g.drawImage(this.imgSkull, width - 4, var10, 10);
                    this.font.drawString(g, this.player.getFrags() + "/" + this.scene.getEnemyCount(), width - 4 - this.imgSkull.getWidth(), var10, 10);
                }
                if (this.imgLife != null) {
                    var10 = height - (height - icohei) / 4;
                    if (this.imgHand != null && this.sear != null && !MainCanvas.ignoreSensor) {
                        if (Main.displaySize > 80) {
                            g.drawImage(this.imgHand, 4, var10 - this.imgLife.getHeight(), 6);
                        } else {
                            g.drawImage(this.imgHand, 4, (height + height * Main.displaySize / 100) / 2 - this.imgHand.getHeight() - 4, 20);
                        }
                    }
                    g.drawImage(this.imgLife, 4, var10, 6);
                    this.font.drawString(g, " " + this.player.getHp(), this.imgLife.getWidth(), var10, 6);
                } else if (this.imgHand != null && this.sear != null && !MainCanvas.ignoreSensor) {
                    var10 = height - (height - icohei) / 4;
                    g.drawImage(this.imgHand, 4, var10, 6);
                }
                if (Arsenal.current != -1 && Arsenal.currentWeapon() != null && Arsenal.currentWeapon().patronbuy && this.imgPatron != null) {
                    g.drawImage(this.imgPatron, width - 4, var10, 10);
                    Weapon var13 = Arsenal.currentWeapon();
                    this.font.drawString(g, var13.getRounds() + "/" + var13.getAmmo() + " ", width - this.imgPatron.getWidth(), var10, 10);
                }
                this.changed = false;
            }
            if (this.imgHand != null && this.sear != null && MainCanvas.ignoreSensor) {
                g.drawImage(this.imgHand, width / 2, height / 2, 3);
            }
            if ((tmps = this.scene.findObject(true, this.player, height / 2 - this.scene.getG3D().getnHeight() / 2, this)) != this.sear || tmps != null) {
                this.changed = true;
                this.sear = tmps;
            }
            if (!this.paused && Main.debug) {
                this.font.drawString(g, ":" + Fps.realFps + ":", 44 + this.imgMoney.getWidth(), (height - icohei) / 4, 6);
                this.font.drawString(g, ":" + this.renderedRooms + ":", 74 + this.imgMoney.getWidth(), (height - icohei) / 4, 6);
                this.font.drawString(g, ":" + this.parts + ":", 94 + this.imgMoney.getWidth(), (height - icohei) / 4, 6);
                this.font.drawString(g, ":" + this.player.getPart() + ":", 114 + this.imgMoney.getWidth(), (height - icohei) / 4, 6);
                this.font.drawString(g, ":" + Long.toString(this.usmem) + ":", 144 + this.imgMoney.getWidth(), (height - icohei) / 4, 6);
                Matrix var44 = this.player.getCharacter().getTransform();
                this.changed = true;
            }
            if (this.customMessage != null) {
                this.drawMessageCustom(g);
                if (this.customMessagePause) {
                    try {
                        Thread.sleep(this.customMessageEndTime);
                        Fps.reset();
                    }
                    catch (Exception var55) {
                        var55.printStackTrace();
                    }
                    this.customMessagePause = false;
                    this.customMessage = null;
                    return;
                }
                if (System.currentTimeMillis() > this.customMessageEndTime) {
                    this.customMessage = null;
                }
            }
            if (Main.debug) {
                this.scene.drawPoints(g, height / 2 - this.scene.getG3D().getnHeight() / 2, this.player);
            }
        }
        this.run(begintime);
        this.finishDraw = true;
        if (!this.changed) {
            Graphics3D g3d = this.scene.getG3D();
            heightz = height / 2 - g3d.getnHeight() / 2;
            this.repaint(0, 0, g3d.getnWidth(), g3d.getnHeight() + heightz);
        } else {
            this.repaint();
        }
    }

    protected final void pointerPressed(int x, int y) {
        if (this.paused) {
            return;
        }
        this.x = x;
        this.y = y;
        if (GUIScreen.isLeftSoft(x, y, this.getWidth(), this.getHeight())) {
            this.keyPressed(this.keys.SOFT_LEFT);
        }
        if (GUIScreen.isRightSoft(x, y, this.getWidth(), this.getHeight())) {
            this.keyPressed(this.keys.SOFT_RIGHT);
        }
    }

    protected final void mouseScrollUp() {
        Arsenal.next();
    }

    protected final void mouseScrollDown() {
        Arsenal.previous();
    }

    private final void bloomScr(Graphics3D var2) {
        int[] var12 = var2.getDisplay();
        int[] rgb2 = new int[var2.getnHeight() / 10 * var2.getnWidth() / 10];
        ImageResize.bilinearResizeRGBnA_toLow(var12, rgb2, var2.getnWidth(), var2.getnHeight(), var2.getnWidth() / 10, var2.getnHeight() / 10);
        for (int i = 0; i < rgb2.length; ++i) {
            int col = rgb2[i];
            int cr = col >> 16 & 0xFF;
            int cg = col >> 8 & 0xFF;
            int cb = col & 0xFF;
            if ((cr = (cr - 96) * 2) < 0) {
                cr = 0;
            }
            if ((cg = (cg - 96) * 2) < 0) {
                cg = 0;
            }
            if ((cb = (cb - 96) * 2) < 0) {
                cb = 0;
            }
            rgb2[i] = col = cr << 16 | cg << 8 | cb;
        }
        int[] rgb3 = new int[var12.length];
        ImageResize.bilinearResizeRGBnA(rgb2, rgb3, var2.getnWidth() / 10, var2.getnHeight() / 10, var2.getnWidth(), var2.getnHeight());
        rgb2 = null;
        for (int i = 0; i < var12.length; ++i) {
            int col = var12[i];
            int col2 = rgb3[i];
            col &= 0xFEFEFE;
            col += (col2 &= 0xFEFEFE);
            col |= (col >> 8 & 0x10101) * 255;
            var12[i] = col;
        }
        rgb3 = null;
    }

    private final void fastbloomScr(Graphics3D var2) {
        int[] var12 = var2.getDisplay();
        int[] rgb2 = new int[var2.getnHeight() / 10 * var2.getnWidth() / 10];
        ImageResize.bilinearResizeRGBnA_toLow(var12, rgb2, var2.getnWidth(), var2.getnHeight(), var2.getnWidth() / 10, var2.getnHeight() / 10);
        for (int i = 0; i < rgb2.length; ++i) {
            int col = rgb2[i];
            rgb2[i] = ((col & 0xFF00FF) * 127 + 0 & 0xFF00FF00 | (col & 0xFF00) * 127 + 0 & 0xFF0000) >>> 8;
        }
        int[] rgb3 = new int[var12.length];
        ImageResize.bilinearResizeRGBnA(rgb2, rgb3, var2.getnWidth() / 10, var2.getnHeight() / 10, var2.getnWidth(), var2.getnHeight());
        rgb2 = null;
        for (int i = 0; i < var12.length; ++i) {
            int col = (var12[i] & 0xFEFEFE) + (rgb3[i] & 0xFEFEFE);
            var12[i] = col | (col >> 8 & 0x10101) * 255;
        }
        rgb3 = null;
    }

    private final void fastbloomScr3(Graphics3D var2) {
        int[] rgb = var2.getDisplay();
        int len = rgb.length - 1;
        int w = var2.getWidth();
        int h = var2.getHeight();
        int p = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int colt;
                int col = rgb[p];
                int col2 = 0;
                int col22 = 0;
                boolean c = false;
                for (int xx = 0; xx < 12; xx += 6) {
                    for (int yy = 0; yy < 12; yy += 6) {
                        colt = rgb[(p + xx % w + yy % h * w) % len];
                        col2 += colt & 0xFF00FF;
                        col22 += colt & 0xFF00;
                    }
                }
                colt = ((col2 <<= 5) & 0xFF00FF00 | (col22 <<= 5) & 0xFF0000) >>> 8;
                col &= 0xFEFEFE;
                col += (colt &= 0xFEFEFE);
                col |= (col >> 8 & 0x10101) * 255;
                rgb[p] = col;
                ++p;
            }
        }
    }

    private final void fastbloomScr2(Graphics3D var2) {
        int[] var12 = var2.getDisplay();
        int[] rgb2 = new int[var2.getnHeight() / 10 * var2.getnWidth() / 10];
        ImageResize.bilinearResizeRGBnA_toLow(var12, rgb2, var2.getnWidth(), var2.getnHeight(), var2.getnWidth() / 10, var2.getnHeight() / 10);
        int[] rgb3 = new int[var12.length];
        ImageResize.bilinearResizeRGBnA(rgb2, rgb3, var2.getnWidth() / 10, var2.getnHeight() / 10, var2.getnWidth(), var2.getnHeight());
        rgb2 = null;
        for (int i = 0; i < var12.length; ++i) {
            int col = var12[i];
            var12[i] = col = ((col & 0xFF00FF) * 64 & 0xFF00FF00 | (col & 0xFF00) * 64 & 0xFF0000) >>> 8;
            int col2 = rgb3[i];
            col2 = ((col2 & 0xFF00FF) * 128 & 0xFF00FF00 | (col2 & 0xFF00) * 128 & 0xFF0000) >>> 8;
            var12[i] = col;
            col &= 0xFEFEFE;
            col += (col2 &= 0xFEFEFE);
            col |= (col >> 8 & 0x10101) * 255;
            var12[i] = col;
        }
        rgb3 = null;
    }

    private final void damageScr(int[] var12) {
        for (int var9 = 0; var9 < var12.length; ++var9) {
            var12[var9] = var12[var9] & 0xFFFF0000;
        }
    }

    private final void deathScr(int[] var12) {
        for (int var9 = 0; var9 < var12.length; ++var9) {
            int var8 = var12[var9];
            int var6 = var8 >> 16 & 0xFF;
            int var7 = var8 >> 8 & 0xFF;
            var8 &= 0xFF;
            var8 = (var6 + var7 + var8) / 3;
            var12[var9] = var8 << 16 | var8 << 8 | var8;
        }
    }

    protected final void pointerDragged(int x, int y) {
        if (this.paused) {
            return;
        }
        this.dirX += (x - this.x) * 200;
        this.dirY += (y - this.y) * 200;
        this.x = x;
        this.y = y;
    }

    protected final void pointerReleased(int x, int y) {
        if (this.paused) {
            return;
        }
        this.x = x;
        this.y = y;
        this.dirY = 0;
        this.dirX = 0;
    }

    protected final void mousePressed(int x, int y) {
        this.key = this.keys.FIRE;
        this.keys.keyPressed(this.keys.FIRE);
    }

    protected final void mouseReleased(int x, int y) {
        this.key = this.keys.FIRE;
        this.keys.keyReleased(this.keys.FIRE);
    }

    protected final void keyPressed(int key) {
        if (this.paused) {
            return;
        }
        this.key = key;
        this.keys.keyPressed(key);
        if (this.key == 42) {
            this.player.zoom = !this.player.zoom;
            this.player.lastZoomAction = System.currentTimeMillis();
        }
        if (this.paused) {
            Fps.reset();
        } else if (this.key == this.keys.SOFT_RIGHT) {
            this.paused = true;
            if (MusicPlayer.player != null) {
                this.musTime = MusicPlayer.getTime();
                this.stopMus();
            }
            this.stop();
            Fps.reset();
            Main.setCurrent(new PauseScreen(this.main, this, this.scene.getG3D().getDisplay(), this.musTime));
        } else if (this.key == this.keys.SOFT_LEFT && !this.player.isDead()) {
            Matrix var4 = this.player.getCharacter().getTransform();
            System.out.println(var4.m03 + "," + var4.m13 + "," + var4.m23 + ";");
            RoomObject ro = this.scene.activateObject(true, this.player, height / 2 - this.scene.getG3D().getnHeight() / 2, this);
            if (ro != null) {
                return;
            }
            if (this.shopItems != null) {
                Shop.items = this.shopItems;
                System.arraycopy(Shop.bckFiles, 0, Shop.files, 0, Shop.files.length);
                System.arraycopy(Shop.bckPrices, 0, Shop.prices, 0, Shop.prices.length);
                Shop.index = this.shopItems[0];
                this.openShop();
            }
        }
    }

    protected final void keyReleased(int key) {
        if (this.paused) {
            return;
        }
        this.key = 0;
        this.keys.keyReleased(key);
    }

    public final void run(long var1) {
        if (this.paused) {
            return;
        }
        if (this.run) {
            this.scene.activateObject(false, this.player, height / 2 - this.scene.getG3D().getnHeight() / 2, this);
            try {
                long var10;
                long var5;
                if (!this.player.getCharacter().onFloor && this.wg != null) {
                    this.wg.moveY2(this.player.getCharacter().getSpeed().y, Fps.getFps());
                }
                if (!this.player.isDead()) {
                    Graphics3D var2;
                    if (this.keys.key3() && this.player.zoom || this.keys.up() && !this.player.zoom || this.keys.up() && MainCanvas.ignoreSensor) {
                        this.player.moveForward();
                        var2 = this.scene.getG3D();
                        if (this.wg != null) {
                            this.wg.move(5, Fps.getFps(), -(Graphics3D.camera.m12 * 90 / Matrix.FP));
                        }
                    }
                    if (this.keys.key1() && this.player.zoom || this.keys.down() && !this.player.zoom || this.keys.down() && MainCanvas.ignoreSensor) {
                        this.player.moveBackward();
                        var2 = this.scene.getG3D();
                        if (this.wg != null) {
                            this.wg.moveB(5, Fps.getFps(), -(Graphics3D.camera.m12 * 90 / Matrix.FP));
                        }
                    }
                    if (this.keys.left() && !MainCanvas.ignoreSensor) {
                        this.player.rotLeft();
                        if (this.wg != null) {
                            this.wg.moveX2((!this.player.zoom ? 5 : 1) * Main.mouseSpeed / 50, Fps.getFps());
                        }
                    }
                    if (this.keys.right() && !MainCanvas.ignoreSensor) {
                        this.player.rotRight();
                        if (this.wg != null) {
                            this.wg.moveX2(-(!this.player.zoom ? 5 : 1) * Main.mouseSpeed / 50, Fps.getFps());
                        }
                    }
                    if (this.keys.key7() || this.keys.left() && MainCanvas.ignoreSensor) {
                        this.player.moveLeft();
                        if (this.wg != null) {
                            this.wg.moveX(5, Fps.getFps());
                        }
                    }
                    if (this.keys.key9() || this.keys.right() && MainCanvas.ignoreSensor) {
                        this.player.moveRight();
                        if (this.wg != null) {
                            this.wg.moveX(-5, Fps.getFps());
                        }
                    }
                    if (this.keys.fire()) {
                        this.player.fire();
                    }
                    if (this.keys.key1() && !this.player.zoom || this.keys.down() && this.player.zoom && !MainCanvas.ignoreSensor) {
                        this.player.rotX(-3 * Main.mouseSpeed / 50);
                        if (this.wg != null) {
                            this.wg.moveY(-(!this.player.zoom ? 4 : 3) * Main.mouseSpeed / 50, Fps.getFps());
                        }
                        if (cam != null) {
                            cam.addAngle(-(!this.player.zoom ? 7 : 5) * 200 * Main.mouseSpeed / 50 / Fps.getFps());
                        }
                    }
                    if (this.keys.key3() && !this.player.zoom || this.keys.up() && this.player.zoom && !MainCanvas.ignoreSensor) {
                        this.player.rotX(3 * Main.mouseSpeed / 50);
                        if (this.wg != null) {
                            this.wg.moveY((!this.player.zoom ? 4 : 3) * Main.mouseSpeed / 50, Fps.getFps());
                        }
                        if (cam != null) {
                            cam.addAngle((!this.player.zoom ? 7 : 5) * 200 * Main.mouseSpeed / 50 / Fps.getFps());
                        }
                    }
                    if (this.key == 48) {
                        this.player.jump();
                    }
                    if (this.key == 35) {
                        this.key = 0;
                        Arsenal.next();
                    }
                    if (!(Main.landspace || this.dirX == 0 && this.dirY == 0)) {
                        if (this.dirY != 0) {
                            this.player.rotX(this.dirY * -(!this.player.zoom ? 2 : 1) * Main.mouseSpeed / 50 / height);
                            if (this.wg != null) {
                                this.wg.moveY(this.dirY * -(!this.player.zoom ? 2 : 1) * Main.mouseSpeed / 50 / height, Fps.getFps());
                            }
                            if (cam != null) {
                                cam.addAngle(this.dirY * -(!this.player.zoom ? 2 : 1) * Main.mouseSpeed / 50 / height * 2);
                                if (this.wg != null) {
                                    this.wg.moveY(this.dirY * -(!this.player.zoom ? 2 : 1) / height * 2, Fps.getFps());
                                }
                            }
                            if (this.dirY == 1) {
                                this.dirY = 0;
                            }
                            this.dirY /= 2;
                        }
                        if (this.dirX != 0) {
                            this.player.rotZ(-(!this.player.zoom ? 4 : 2) * Main.mouseSpeed / 50 * this.dirX / height);
                            if (this.wg != null) {
                                this.wg.moveX2(-(!this.player.zoom ? 4 : 2) * this.dirX * Main.mouseSpeed / 50 / height, Fps.getFps());
                            }
                            if (this.dirX == 1) {
                                this.dirX = 0;
                            }
                            this.dirX /= 2;
                        }
                    }
                }
                if (this.player.isTimeToRenew()) {
                    this.paused = true;
                    this.restartGame();
                    return;
                }
                if (!delayDialogs.isEmpty()) {
                    for (int i = 0; i < delayDialogs.size(); ++i) {
                        if (!((DelayedDialog)delayDialogs.elementAt(i)).update(this)) continue;
                        delayDialogs.removeElementAt(i);
                    }
                }
                this.scene.update(this.player, this);
                if (this.scene.getFrame() % 2 == 0) {
                    if (this.framesToEnd == 0 && this.scene.isLevelCompleted(this.player)) {
                        this.framesToEnd = 1;
                    }
                    if (this.framesToExit == 0 && this.scene.isWinner(this.player)) {
                        this.framesToExit = 1;
                    }
                }
                if (this.framesToEnd > 0) {
                    ++this.framesToEnd;
                }
                if (this.framesToExit > 0) {
                    ++this.framesToExit;
                    if (this.scene.ne) {
                        this.framesToExit = 45;
                    }
                }
                if (this.framesToEnd > 45) {
                    this.changed = true;
                    if (!Main.isLastLevel(this.levelNumber)) {
                        if (this.scene.getFinishPoint() != null) {
                            this.loadLevel(this.levelNumber + 1, this.scene.getFinishPoint());
                        }
                    } else {
                        Menu var13 = new Menu(this.main);
                        Main.setCurrent(var13);
                    }
                    return;
                }
                if (!this.changed) {
                    Weapon var3 = null;
                    if (Arsenal.current != -1) {
                        var3 = Arsenal.currentWeapon();
                    }
                    boolean bl = this.changed = this.player.getHp() != this.hp || this.player.getMoney() != this.money || this.player.getFrags() != this.frags;
                    if (var3 != null) {
                        boolean bl2 = this.changed = this.changed || var3.getRounds() != this.rounds;
                    }
                    if (this.changed) {
                        this.hp = this.player.getHp();
                        if (var3 != null) {
                            this.rounds = var3.getRounds();
                        }
                        this.money = this.player.getMoney();
                        this.frags = this.player.getFrags();
                    }
                }
                if ((var5 = 15L - ((var10 = System.currentTimeMillis()) - var1)) < 1L) {
                    var5 = 1L;
                }
                if (Main.frameskip) {
                    Thread.sleep(var5);
                }
            }
            catch (Exception var8) {
                var8.printStackTrace();
            }
        }
    }

    public final void start() {
        this.changed = true;
        this.run = true;
        Fps.reset();
    }

    public void startMus(long t) {
        try {
            MusicPlayer.start(t);
            Fps.reset();
            return;
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return;
        }
    }

    private void stop() {
        this.run = false;
    }

    private void stopMus() {
        if (MusicPlayer.player != null) {
            try {
                MusicPlayer.stop();
                return;
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    private Image getScreenShot() {
        Image screenshot = Image.createImage((int)widtho, (int)heighto);
        Graphics g = screenshot.getGraphics();
        this.paint(g);
        return Image.createImage((Image)screenshot);
    }

    public void destroyMusic() {
        if (MusicPlayer.player != null) {
            MusicPlayer.stop();
            MusicPlayer.destroy();
        }
    }

    public void init() {
        try {
            if (Main.isMusic && Main.music != 0) {
                if (MusicPlayer.player == null) {
                    MusicPlayer.playMusic(mus);
                }
                Fps.reset();
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }

    public void sizeChanged(int w, int h) {
        width = w;
        height = h;
        widtho = w;
        heighto = h;
        icohei = Main.getDisplaySize() <= 80 ? (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)) : height * 8 / 10;
        this.scene.getG3D().resize(width, (int)((float)height * ((float)Main.getDisplaySize() / 100.0f)));
    }

    public void showDialog(String str) {
        Fps.reset();
        this.keys.reset();
        this.stop();
        this.run = false;
        this.dialogScreen.set(str, this.font, this.scene.getG3D(), this.main, this);
        this.main.setCurrentRepaint(this.dialogScreen);
    }

    public final void openShop() {
        Fps.reset();
        this.stop();
        this.run = false;
        Main.setCurrent(new Shop(this.main, this, this.player));
    }

    public void loadLevel(int lvl, Vector3D stp) {
        this.loadLevel(lvl, stp, true);
    }

    public void loadLevel(int lvl, Vector3D stp, boolean stopMus) {
        this.main.addAvailableLevel(lvl - 1);
        if (this.newPos != null) {
            this.player.getCharacter().getTransform().subPosition(stp.x, stp.y, stp.z);
            this.player.getCharacter().getTransform().addPosition(this.newPos);
        }
        Main.saveGame(lvl, this.player);
        this.stop();
        if (stopMus) {
            this.stopMus();
        }
        this.destroy(stopMus);
        Main.loadLevel(true, true, lvl, this.hudInfo, this.main, null, 1);
    }

    public void restartGame() {
        this.stop();
        this.framesToExit = 0;
        this.framesToEnd = 0;
        this.scene.reset();
        this.player.setPart(-1);
        this.player.set(this.scene.getG3D().getnWidth(), this.scene.getG3D().getnHeight(), this.scene.getStartPoint(), this.hudInfo);
        if (Main.getContinueLevel() == this.levelNumber) {
            Main.loadGame(this.player, width, height);
            Main.loadPosition(this.player);
        } else {
            com.AI.Player.usedPoints.removeAllElements();
            com.AI.Player.arsenal = null;
            this.player.set(this.scene.getG3D().getnWidth(), this.scene.getG3D().getnHeight(), this.scene.getStartPoint(), this.hudInfo);
            com.AI.Player.money = 0;
        }
        this.scene.getHouse().addObject(this.player);
        Respawn.loadObjects(levelFile, this.scene, this.player, true);
        this.sear = null;
        this.paused = false;
        delayDialogs.removeAllElements();
        this.start();
        this.stopMus();
        this.startMus(0L);
        Fps.reset();
    }

    public final void resize() {
        try {
            this.imgSight = !Main.originalSight ? (!Main.fullScreenSight ? this.createImage2(Main.sight_icon) : this.createImageFullScr(Main.sight_icon)) : Image.createImage((String)Main.sight_icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().reset();
        }
    }

    static {
        mus = "/music.mid";
        levelFile = "/level_1.txt";
        pst = 0;
        delayDialogs = new Vector();
        bloom = false;
    }
}

