/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Math.Matrix;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Morphing;
import com.Rendering.Vertex;

public class BoundingBox {
    private Vertex[] vertices;
    private int minx;
    private int miny;
    private int maxx;
    private int maxy;
    private int minz;
    private int maxz;

    public BoundingBox(Mesh mesh) {
        this.set(mesh.minX(), mesh.minY(), mesh.minZ(), mesh.maxX(), mesh.maxY(), mesh.maxZ());
    }

    public BoundingBox(Morphing anim) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        short[][] vertices = anim.getVertices();
        for (int j = 0; j < vertices.length; ++j) {
            short[] vers = vertices[j];
            for (int i = 0; i < vers.length / 3; ++i) {
                short x = vers[i * 3];
                short y = vers[i * 3 + 1];
                short z = vers[i * 3 + 2];
                minX = Math.min(minX, x);
                minY = Math.min(minY, y);
                minZ = Math.min(minZ, z);
                maxX = Math.max(maxX, x);
                maxY = Math.max(maxY, y);
                maxZ = Math.max(maxZ, z);
            }
        }
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.vertices = new Vertex[]{new Vertex(minX, minY, minZ), new Vertex(maxX, minY, minZ), new Vertex(minX, minY, maxZ), new Vertex(maxX, minY, maxZ), new Vertex(minX, maxY, minZ), new Vertex(maxX, maxY, minZ), new Vertex(minX, maxY, maxZ), new Vertex(maxX, maxY, maxZ)};
    }

    public boolean isVisible(Graphics3D g3d, Matrix matrix, int x1, int y1, int x2, int y2) {
        g3d.transformAndProjectVertices(this.vertices, matrix);
        Vertex v = this.vertices[0];
        this.minx = this.maxx = v.sx;
        this.miny = this.maxy = v.sy;
        this.minz = this.maxz = v.rz;
        for (int i = 1; i < this.vertices.length; ++i) {
            v = this.vertices[i];
            if (v.sx < this.minx) {
                this.minx = v.sx;
            }
            if (v.sy < this.miny) {
                this.miny = v.sy;
            }
            if (v.rz < this.minz) {
                this.minz = v.rz;
            }
            if (v.rz > this.maxz) {
                this.maxz = v.rz;
            }
            if (v.sx > this.maxx) {
                this.maxx = v.sx;
            }
            if (v.sy <= this.maxy) continue;
            this.maxy = v.sy;
        }
        return this.maxx >= x1 && this.minx <= x2 && this.maxy >= y1 && this.miny <= y2 && this.minz < 0 && -this.maxz <= Graphics3D.drDist;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public int getMinX() {
        return this.minx;
    }

    public int getMinY() {
        return this.miny;
    }

    public int getMinZ() {
        return this.minz;
    }

    public int getMaxX() {
        return this.maxx;
    }

    public int getMaxY() {
        return this.maxy;
    }
}

