/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Math.MathUtils;
import com.Rendering.Graphics3D;
import com.Rendering.RenderObject;
import com.Rendering.Texture;
import com.Rendering.Texturing;
import com.Rendering.Vertex;
import com.misc.Main;

public class Polygon3V
extends RenderObject {
    public Vertex a;
    public Vertex b;
    public Vertex c;
    public byte au;
    public byte av;
    public byte bu;
    public byte bv;
    public byte cu;
    public byte cv;
    public byte tex = 0;
    private static int q;
    private static int sz2;
    private static short sizex;
    private static short sizey;
    private static short sizeu;
    private static short sizev;
    private static byte addmip;
    private static byte fog;

    public Polygon3V(Vertex a2, Vertex b2, Vertex c2, byte au, byte av, byte bu, byte bv, byte cu, byte cv) {
        super(a2, b2, c2);
        this.a = a2;
        this.au = au;
        this.av = av;
        this.b = b2;
        this.bu = bu;
        this.bv = bv;
        this.c = c2;
        this.cu = cu;
        this.cv = cv;
        fog = Graphics3D.fog;
    }

    public final void szCalcfogAdd() {
        this.sz = this.a.rz;
        if (this.c.rz < this.sz) {
            this.sz = this.c.rz;
        }
        if (this.b.rz < this.sz) {
            this.sz = this.b.rz;
        }
        sz2 = -this.sz / 255;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -this.sz / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        sz2 = 255 - sz2;
        int cr = Graphics3D.fogc >> 16 & 0xFF;
        int cg = Graphics3D.fogc >> 8 & 0xFF;
        int cb = Graphics3D.fogc & 0xFF;
        if ((cr -= sz2) < 0) {
            cr = 0;
        }
        if ((cg -= sz2) < 0) {
            cg = 0;
        }
        if ((cb -= sz2) < 0) {
            cb = 0;
        }
        sz2 = cr << 16 | cg << 8 | cb;
    }

    public final boolean isVisible(int x1, int y1, int x2, int y2) {
        if (this.a.sx < x1 && this.b.sx < x1 && this.c.sx < x1) {
            return false;
        }
        if (this.a.sx > x2 && this.b.sx > x2 && this.c.sx > x2) {
            return false;
        }
        if (this.a.sy < y1 && this.b.sy < y1 && this.c.sy < y1) {
            return false;
        }
        if (this.a.sy > y2 && this.b.sy > y2 && this.c.sy > y2) {
            return false;
        }
        if ((this.a.sx - this.b.sx) * (this.b.sy - this.c.sy) <= (this.a.sy - this.b.sy) * (this.b.sx - this.c.sx)) {
            return false;
        }
        this.sz = this.a.rz;
        if (this.c.rz < this.sz) {
            this.sz = this.c.rz;
        }
        if (this.b.rz < this.sz) {
            this.sz = this.b.rz;
        }
        if (this.sz > 0) {
            return false;
        }
        if (-this.sz > Graphics3D.drDist) {
            return false;
        }
        this.sz = (this.a.rz + this.c.rz + this.b.rz) * 4 / 3;
        if (this.ny > 4000 || this.ny < -4000) {
            this.sz += Main.offsetsz;
        }
        return true;
    }

    public final void render(Graphics3D g3d, Texture texture) {
        if (Main.persQ == -1 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = (short)Polygon3V.size(this.a.sx, this.b.sx, this.c.sx);
        sizey = (short)Polygon3V.size(this.a.sy, this.b.sy, this.c.sy);
        if (fog == 5 && (sz2 = MathUtils.calcLight(this.nx, this.ny, this.nz, Graphics3D.lightdirx, Graphics3D.lightdiry, Graphics3D.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null && (sizex + sizey >> 1) * (addmip = (byte)(this.ny > 4000 || this.ny < -4000 ? 2 : 3)) < (sizeu = (short)(Polygon3V.size(this.au & 0xFF, this.bu & 0xFF, this.cu & 0xFF) * texture.rImg.w >> 8)) + (sizev = (short)(Polygon3V.size(this.av & 0xFF, this.bv & 0xFF, this.cv & 0xFF) * texture.rImg.h >> 8))) {
            texture = texture.mip;
            if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu = (short)(sizeu >> 1)) + (sizev = (short)(sizev >> 1))) {
                texture = texture.mip;
            }
        }
        if (texture.perspectiveCorrection && (sizex > 30 - Main.persQ * 15 || sizey > 30 - Main.persQ * 15) && Main.persQ != -1 || Main.persQ == 2) {
            Texturing.paintPers(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, Graphics3D.fogc, fog, sz2, q);
        } else {
            Texturing.paintAffine(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, Graphics3D.fogc, fog, sz2);
        }
    }

    public final void renderFast(Graphics3D g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = MathUtils.calcLight(this.nx, this.ny, this.nz, Graphics3D.lightdirx, Graphics3D.lightdiry, Graphics3D.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1 && fog == 1) {
            this.szCalcfogAdd();
        }
        Texturing.paintAffine(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, Graphics3D.fogc, texture.drawmode, sz2);
    }

    private static final int size(int a, int b, int c) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        return c - a;
    }
}

