/*
 * Decompiled with CFR 0.152.
 */
package com.AI;

import com.AI.Bot;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.BoundingBox;
import com.Rendering.Meshes.MeshImage;
import com.misc.Main;
import java.util.Vector;

public final class BigZombie
extends Bot {
    public static int max_hp = 400;
    private static Fps fps;
    public static int model_height;
    private int state = -1;
    public MeshImage meshImage;
    private GameObject enemy = null;
    private static Main main;
    private Vector3D dir = new Vector3D();
    private static BoundingBox boundingBox;
    public static int[] attack;

    public BigZombie(Vector3D pos) {
        if (Main.bigzombiemod != null) {
            this.meshImage = new MeshImage(Main.bigzombiemod.getMesh(), Main.bigzombiemod.getAnimation());
            boundingBox = new BoundingBox(Main.bigzombiemod.getAnimation());
        }
        this.name = "BIG_ZOMBIE";
        this.getCharacter().getTransform().setIdentity();
        this.set(pos);
        this.fraction = 2;
    }

    public final void set(Vector3D pos) {
        super.set(pos);
        this.setHp(max_hp);
        this.setCharacterSize(model_height);
        this.dir.set(pos.x, pos.y, pos.z + 50);
        this.lookAt(pos.x, pos.z + 50);
    }

    public final void destroy() {
        super.destroy();
        this.enemy = null;
        this.meshImage = null;
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        Matrix var6 = this.getCharacter().getTransform();
        Matrix var6z = g3d.computeFinalMatrix(var6);
        if (!boundingBox.isVisible(g3d, var6z, x1, y1, x2, y2)) {
            return;
        }
        if (var6.m11 == 16384) {
            if (this.state == 1) {
                this.meshImage.setFrame(this.getFrameInter() * Main.bigzombieanimspeed / 100);
            }
            if (this.state == 2) {
                this.meshImage.setFrame(this.getFrameInter() * Main.bigzombieattackanimspeed / 100);
            }
        }
        this.meshImage.setMatrix(var6z);
        this.meshImage.setTexture(Main.bigzombietex);
        g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
        this.meshImage.sz += this.character.getRadius();
        if (this.getCharacter().oldFloorPoly != null && this.getCharacter().oldFloorPoly.sz > this.meshImage.sz) {
            this.getCharacter().oldFloorPoly.sz = this.meshImage.sz - 1;
        }
        this.renderBlood(g3d, 1500);
    }

    protected final void action(Scene scene) {
        if (Math.abs(this.getFrameInterDiv()) % Main.bigzombiereacttimer == 1) {
            House var7 = scene.getHouse();
            Vector var2 = var7.getObjects();
            if (this.enemy != null && this.enemy.isDead() || this.enemy != null && Fps.nFrame == 0) {
                this.enemy = null;
            }
            this.enemy = this.findBot(var2, this, attack);
            if (this.enemy != null) {
                boolean var10000;
                Vector3D var4 = this.dir;
                GameObject var3 = this.enemy;
                if (this.notCollided(var7, var3)) {
                    Matrix var8 = var3.getCharacter().getTransform();
                    var4.set(var8.m03, var8.m13, var8.m23);
                    var10000 = true;
                } else {
                    Portal var9 = BigZombie.commonPortal(var7, this.getPart(), var3.getPart());
                    if (var9 != null) {
                        BigZombie.computeCentre(var9, var4);
                    }
                    var10000 = false;
                }
                boolean var10 = var10000;
                if (this.dir.x != 0 && this.dir.z != 0) {
                    this.lookAt(this.dir.x, this.dir.z);
                }
                long var5 = this.getCharacter().distance(this.enemy.getCharacter());
                if (var10 && (float)var5 <= (float)BigZombie.sqr(this.getCharacter().getRadius() + this.enemy.getCharacter().getRadius()) * Main.bigzombieattackradius) {
                    this.state = Main.bigzombieplayerreaction;
                } else {
                    if (this.getCharacter().isCollision() && !var10) {
                        this.getCharacter().jump(Main.bigzombiejumpheight, Main.bigzombiejumpspeed);
                    }
                    if (var5 > BigZombie.sqr(this.getCharacter().getRadius() * 11)) {
                        this.getCharacter().jump(Main.bigzombiejumpheight2, Main.bigzombiejumpspeed2);
                    }
                    this.state = Main.bigzombieai;
                }
            } else {
                this.state = -1;
            }
        }
        if (this.state == 1) {
            this.moveZ(Main.bigzombiespeed);
        }
        if (this.state == Main.bigzombieattacktrigger && this.getFrameInterDiv() % Main.bigzombieattacktimer == 0) {
            this.enemy.damage(this, Main.bigzombiedamage);
        }
    }

    static {
        model_height = 2000;
    }
}

