/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.AI.Bot;
import com.AI.NPC;
import com.AI.Player;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Room;
import com.Gameplay.Objects.GameObject;
import com.Gameplay.Objects.MeshObject;
import com.Gameplay.Objects.SpriteObject;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Vertex;
import com.misc.DelayedDialog;
import com.misc.Main;
import com.misc.Stringer;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class RoomObject {
    private static final Vertex vert = new Vertex();
    private int oldX;
    private int oldZ;
    private int oldY;
    private int part = -1;
    public boolean activable = false;
    public boolean clickable = false;
    public boolean singleUse = false;
    public boolean destroyOnUse = false;
    public boolean alwaysActivate = false;
    public String desc = null;
    public String name = null;
    public String sound = null;
    public String[] need = null;
    public String[] additional = null;
    public String errMessage = null;
    public String message = null;
    public boolean hideWhenUnusable = false;
    public long lastActivate = -1L;
    public long timeToReset = 0L;
    public long radius = 4000L;
    public long messageTimeOut = -1L;
    public int messageType = 0;
    public int pointRadius = 150;
    public int pointHeight = 150;
    public Vector3D pointOffset = null;
    public boolean needToPoint = false;
    public boolean squarePoint = false;
    public boolean dynamicPoint = false;
    public boolean visible = true;
    public long errMessageTimeOut = -1L;
    public long errMessageDelay = 0L;
    public long messageDelay = 0L;
    public int errMessageType = 0;
    public boolean near = true;
    public boolean activated = false;

    public abstract void render(Graphics3D var1, int var2, int var3, int var4, int var5);

    public final int getPart() {
        return this.part;
    }

    public final void setPart(int part) {
        this.part = part;
    }

    public abstract int getPosX();

    public abstract int getPosZ();

    public abstract int getPosY();

    public abstract void setPos(int var1, int var2, int var3);

    protected boolean isNeedRecomputePart() {
        int x = this.getPosX();
        int z = this.getPosZ();
        int y = this.getPosY();
        if (this.oldX != x || this.oldZ != z || this.oldY != y || this.part == -1) {
            this.oldX = x;
            this.oldZ = z;
            this.oldY = y;
            return true;
        }
        return false;
    }

    public boolean isAllCollected(Vector points, Player player, House house, GameScreen gs) {
        if (this.need == null) {
            return true;
        }
        for (int i = 0; i < this.need.length; ++i) {
            if (RoomObject.containsCollected(points, this.need[i], player, house, gs)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCollected(Vector points, String name, Player player, House house, GameScreen gs) {
        if (name != null) {
            String hcName;
            boolean inverse = false;
            if (name.indexOf(33) == 0) {
                inverse = true;
                name = name.substring(1, name.length());
            }
            if ((hcName = name.toUpperCase()).indexOf("WEAPON_") == 0) {
                int i = Stringer.parseInt(name.substring(7, name.length()));
                if (Arsenal.weapons[i] != null) {
                    return !inverse;
                }
            } else {
                if (hcName.indexOf(61) != -1 || hcName.indexOf(62) != -1 || hcName.indexOf(60) != -1) {
                    int charind = hcName.indexOf(61);
                    if (charind == -1) {
                        charind = hcName.indexOf(62);
                    }
                    if (charind == -1) {
                        charind = hcName.indexOf(60);
                    }
                    char operator = hcName.charAt(charind);
                    char operator2 = hcName.charAt(charind - 1);
                    int var1 = operator2 == '>' || operator2 == '<' ? RoomObject.readVar(name.substring(0, charind - 1), player, house, gs) : RoomObject.readVar(name.substring(0, charind), player, house, gs);
                    int var2 = RoomObject.readVar(name.substring(charind + 1, name.length()), player, house, gs);
                    if (operator == '=' && operator2 == '>' && var1 >= var2) {
                        return !inverse;
                    }
                    if (operator == '=' && operator2 == '<' && var1 <= var2) {
                        return !inverse;
                    }
                    if (operator == '=' && var1 == var2) {
                        return !inverse;
                    }
                    if (operator == '>' && var1 > var2) {
                        return !inverse;
                    }
                    if (operator == '<' && var1 < var2) {
                        return !inverse;
                    }
                    return inverse;
                }
                if (hcName.equals("FALSE")) {
                    return inverse;
                }
                if (hcName.equals("TRUE")) {
                    return !inverse;
                }
                for (int i = 0; i < points.size(); ++i) {
                    String pName = (String)points.elementAt(i);
                    if (pName == null || !pName.equals(name)) continue;
                    return !inverse;
                }
            }
            return inverse;
        }
        return false;
    }

    public boolean contains(Vector points, String name) {
        if (name != null) {
            if (!this.singleUse) {
                return false;
            }
            boolean inverse = true;
            if (name.indexOf(33) == 0) {
                inverse = false;
                name = name.substring(1, name.length());
            }
            for (int i = 0; i < points.size(); ++i) {
                String pName = (String)points.elementAt(i);
                if (pName == null || !pName.equals(name)) continue;
                return inverse;
            }
            return !inverse;
        }
        return this.activated && this.singleUse;
    }

    public static boolean containsSimple(Vector points, String name) {
        if (name != null) {
            boolean inverse = true;
            if (name.indexOf(33) == 0) {
                inverse = false;
                name = name.substring(1, name.length());
            }
            for (int i = 0; i < points.size(); ++i) {
                String pName = (String)points.elementAt(i);
                if (pName == null || !pName.equals(name)) continue;
                return inverse;
            }
            return !inverse;
        }
        return false;
    }

    public void give(String[] name, Player player, House house, GameScreen gs) {
        if (name == null) {
            return;
        }
        for (int num = 0; num < name.length; ++num) {
            boolean inverse = false;
            String newName = name[num];
            if (newName == null) continue;
            if (newName.indexOf(33) == 0) {
                inverse = true;
                newName = newName.substring(1, newName.length());
            }
            String hcName = newName.toUpperCase();
            if (newName.charAt(0) == '{') {
                int counter = 1;
                for (int num2 = num + 1; num2 < name.length; ++num2) {
                    if (name[num2].charAt(0) == '}') {
                        if (--counter != 0) continue;
                        num = num2;
                        continue;
                    }
                    if (name[num2].charAt(0) != '{') continue;
                    ++counter;
                }
                continue;
            }
            if (newName.charAt(0) == '}') continue;
            if (hcName.indexOf("WEAPON_") == 0) {
                int i = RoomObject.readVar(newName.substring(7, newName.length()), player, house, gs);
                if (!inverse && Arsenal.weapons[i] == null) {
                    Arsenal.weapons[i] = Stringer.createWeapon(i);
                    Arsenal.weapons[i].setAmmo(0);
                    if (Arsenal.current != -1 && Arsenal.currentWeapon().getDamageValue() < Arsenal.weapons[i].getDamageValue()) {
                        Arsenal.current = i;
                    }
                }
                if (!inverse) continue;
                Arsenal.weapons[i] = null;
                Arsenal.next();
                continue;
            }
            if (hcName.equals("END_SCRIPT")) {
                return;
            }
            if (hcName.equals("SAVE_GAME")) {
                if (gs.player.getHp() <= 0) continue;
                Main.saveGame(gs.levelNumber, player);
                continue;
            }
            if (hcName.equals("LOAD_LEVEL(")) {
                String[] vars = Mesh.cutOnStrings(newName.substring(11, newName.length() - 1), ',');
                Vector3D pos = new Vector3D(player.getPosX(), player.getPosY(), player.getPosZ());
                boolean saveMus = false;
                gs.newPos = pos;
                if (vars.length >= 4) {
                    gs.newPos = new Vector3D(RoomObject.readVar(vars[1], player, house, gs), RoomObject.readVar(vars[2], player, house, gs), RoomObject.readVar(vars[3], player, house, gs));
                }
                if (vars.length >= 5) {
                    player.getCharacter().rotYn(RoomObject.readVar(vars[4], player, house, gs));
                }
                if (vars.length >= 6) {
                    saveMus = RoomObject.readBoolean(vars[5], player, house, gs);
                }
                gs.loadLevel(RoomObject.readVar(vars[0], player, house, gs), pos, !saveMus);
                return;
            }
            if (hcName.indexOf("IF") == 0) {
                boolean i = RoomObject.readBoolean(newName.substring(2, newName.length()), player, house, gs);
                if (num == name.length - 1) continue;
                if (i) {
                    if (name[num + 1].charAt(0) != '{') continue;
                    ++num;
                    continue;
                }
                if (name[num + 1].charAt(0) == '{') continue;
                ++num;
                continue;
            }
            if (hcName.indexOf("MONEY") == 0) {
                if (newName.charAt(5) == '=') {
                    Player.money = RoomObject.readVar(newName.substring(6, newName.length()), player, house, gs);
                    continue;
                }
                int i = RoomObject.readVar(newName.substring(7, newName.length()), player, house, gs);
                if (inverse) {
                    i *= -1;
                }
                if (newName.charAt(5) == '-') {
                    i *= -1;
                }
                Player.money += i;
                continue;
            }
            if (hcName.indexOf("AMMO_") == 0) {
                String tmp = newName.substring(5, newName.length());
                int weapon = RoomObject.readVar(tmp.substring(0, tmp.indexOf(95)), player, house, gs);
                if (tmp.substring(tmp.indexOf(95) + 1, tmp.length()).charAt(0) == '=') {
                    Arsenal.weapons[weapon].setAmmo(RoomObject.readVar(newName.substring(6, newName.length()), player, house, gs));
                    continue;
                }
                int i = RoomObject.readVar(tmp.substring(tmp.indexOf(95) + 1, tmp.length()), player, house, gs);
                if (inverse) {
                    i *= -1;
                }
                if (Arsenal.weapons[weapon] == null) continue;
                Arsenal.weapons[weapon].magazine.addAmmo(i);
                continue;
            }
            if (hcName.indexOf("FRAGS") == 0) {
                if (newName.charAt(4) == '=') {
                    Player.money = RoomObject.readVar(newName.substring(5, newName.length()), player, house, gs);
                    continue;
                }
                int i = RoomObject.readVar(newName.substring(6, newName.length()), player, house, gs);
                if (inverse) {
                    i *= -1;
                }
                if (newName.charAt(4) == '-') {
                    i *= -1;
                }
                player.frags += i;
                continue;
            }
            if (newName.indexOf(58) != -1) {
                int i;
                int i2;
                String objname = newName.substring(0, newName.indexOf(58));
                String command = newName.substring(newName.indexOf(58) + 1, newName.length());
                String hcCommand = command.toUpperCase();
                Vector objs = house.getObjects();
                boolean toggle = false;
                if (hcCommand.indexOf("TOGGLE_") != -1) {
                    toggle = true;
                    hcCommand = hcCommand.substring(7, hcCommand.length());
                    command = command.substring(7, command.length());
                }
                RoomObject obj = null;
                if (objname.equalsIgnoreCase("player")) {
                    obj = player;
                }
                if (objs.size() > 0 && obj == null) {
                    for (i2 = 0; i2 < objs.size(); ++i2) {
                        if (((RoomObject)objs.elementAt((int)i2)).name == null || !((RoomObject)objs.elementAt((int)i2)).name.equals(objname)) continue;
                        obj = (RoomObject)objs.elementAt(i2);
                    }
                }
                if (obj == null) continue;
                if (hcCommand.equals("ACTIVATE")) {
                    obj.activate(house, player, gs);
                    continue;
                }
                if (hcCommand.indexOf("HP") == 0 && obj instanceof GameObject) {
                    GameObject obj2 = (GameObject)obj;
                    if (hcCommand.charAt(2) == '=') {
                        obj2.setHp(RoomObject.readVar(hcCommand.substring(3, hcCommand.length()), player, house, gs));
                        continue;
                    }
                    i = RoomObject.readVar(hcCommand.substring(4, hcCommand.length()), player, house, gs);
                    if (inverse) {
                        i *= -1;
                    }
                    if (hcCommand.charAt(2) == '-') {
                        i *= -1;
                    }
                    obj2.damage(-i);
                    continue;
                }
                if (hcCommand.equals("ACTIVABLE")) {
                    if (!toggle) {
                        obj.activable = !inverse;
                        continue;
                    }
                    obj.activable ^= true;
                    continue;
                }
                if (hcCommand.equals("CLICKABLE")) {
                    if (!toggle) {
                        obj.clickable = !inverse;
                        continue;
                    }
                    obj.clickable ^= true;
                    continue;
                }
                if (hcCommand.equals("SINGLEUSE")) {
                    if (!toggle) {
                        obj.singleUse = !inverse;
                        continue;
                    }
                    obj.singleUse ^= true;
                    continue;
                }
                if (hcCommand.equals("DESTROYONUSE")) {
                    if (!toggle) {
                        obj.destroyOnUse = !inverse;
                        continue;
                    }
                    obj.destroyOnUse ^= true;
                    continue;
                }
                if (hcCommand.equals("HIDEWHENUNUSABLE")) {
                    if (!toggle) {
                        obj.hideWhenUnusable = !inverse;
                        continue;
                    }
                    obj.hideWhenUnusable ^= true;
                    continue;
                }
                if (hcCommand.equals("NEEDTOPOINT")) {
                    int ntp = 0;
                    if (obj.needToPoint) {
                        ntp = 1;
                    }
                    if (obj.squarePoint) {
                        ntp = 2;
                    }
                    if (hcCommand.charAt(11) == '=') {
                        ntp = RoomObject.readVar(command.substring(12, command.length()), player, house, gs);
                    } else {
                        i = RoomObject.readVar(newName.substring(13, newName.length()), player, house, gs);
                        if (hcCommand.charAt(11) == '-') {
                            i *= -1;
                        }
                        if (inverse) {
                            i *= -1;
                        }
                        ntp += i;
                    }
                    if (ntp == 0) {
                        obj.needToPoint = false;
                        obj.squarePoint = false;
                        continue;
                    }
                    if (ntp == 1) {
                        obj.needToPoint = true;
                        obj.squarePoint = false;
                        continue;
                    }
                    obj.needToPoint = true;
                    obj.squarePoint = true;
                    continue;
                }
                if (hcCommand.equals("X")) {
                    if (hcCommand.charAt(1) == '=') {
                        obj.setPos(RoomObject.readVar(command.substring(2, command.length()), player, house, gs), obj.getPosY(), obj.getPosZ());
                        continue;
                    }
                    i2 = RoomObject.readVar(newName.substring(3, newName.length()), player, house, gs);
                    if (hcCommand.charAt(11) == '-') {
                        i2 *= -1;
                    }
                    if (inverse) {
                        i2 *= -1;
                    }
                    obj.setPos(obj.getPosX() + RoomObject.readVar(command.substring(2, command.length()), player, house, gs), obj.getPosY(), obj.getPosZ());
                    continue;
                }
                if (hcCommand.equals("Y")) {
                    if (hcCommand.charAt(1) == '=') {
                        obj.setPos(obj.getPosX(), RoomObject.readVar(command.substring(2, command.length()), player, house, gs), obj.getPosZ());
                        continue;
                    }
                    i2 = RoomObject.readVar(newName.substring(3, newName.length()), player, house, gs);
                    if (hcCommand.charAt(11) == '-') {
                        i2 *= -1;
                    }
                    if (inverse) {
                        i2 *= -1;
                    }
                    obj.setPos(obj.getPosX(), obj.getPosY() + RoomObject.readVar(command.substring(2, command.length()), player, house, gs), obj.getPosZ());
                    continue;
                }
                if (hcCommand.equals("Z")) {
                    if (hcCommand.charAt(1) == '=') {
                        obj.setPos(obj.getPosX(), obj.getPosY(), RoomObject.readVar(command.substring(2, command.length()), player, house, gs));
                        continue;
                    }
                    i2 = RoomObject.readVar(newName.substring(3, newName.length()), player, house, gs);
                    if (hcCommand.charAt(11) == '-') {
                        i2 *= -1;
                    }
                    if (inverse) {
                        i2 *= -1;
                    }
                    obj.setPos(obj.getPosX(), obj.getPosY(), obj.getPosZ() + RoomObject.readVar(command.substring(2, command.length()), player, house, gs));
                    continue;
                }
                if (hcCommand.equals("VISIBLE")) {
                    if (!toggle) {
                        obj.visible = !inverse;
                        continue;
                    }
                    obj.visible ^= true;
                    continue;
                }
                if (hcCommand.indexOf("NAME=") == 0) {
                    obj.name = RoomObject.readString(hcCommand.substring(5, hcCommand.length()), player, house, gs);
                    continue;
                }
                if (hcCommand.indexOf("DESC=") == 0) {
                    obj.desc = RoomObject.readString(hcCommand.substring(5, hcCommand.length()), player, house, gs);
                    continue;
                }
                if (hcCommand.indexOf("NEED=") == 0) {
                    obj.need = Mesh.cutOnStrings(RoomObject.readString(hcCommand.substring(5, hcCommand.length()), player, house, gs), ',', ';');
                    continue;
                }
                if (hcCommand.indexOf("SOUND=") == 0) {
                    obj.sound = RoomObject.readString(hcCommand.substring(6, hcCommand.length()), player, house, gs);
                    continue;
                }
                if (hcCommand.indexOf("ERRMSG=") == 0) {
                    obj.errMessage = RoomObject.readString(hcCommand.substring(7, hcCommand.length()), player, house, gs);
                    continue;
                }
                if (hcCommand.indexOf("MESSAGE=") != 0) continue;
                obj.sound = RoomObject.readString(hcCommand.substring(9, hcCommand.length()), player, house, gs);
                continue;
            }
            if (inverse) {
                Player.usedPoints.removeElement(newName);
            }
            if (inverse || RoomObject.containsSimple(Player.usedPoints, newName)) continue;
            Player.usedPoints.addElement(newName);
        }
    }

    public static int readVar(String var, Player player, House house, GameScreen gs) {
        if (var == null) {
            return 0;
        }
        if (var.length() == 0) {
            return 0;
        }
        var = Stringer.deleteExtremeSpaces(var);
        String hcVar = var.toUpperCase();
        int ind = var.indexOf(40);
        if (ind > -1) {
            String s = var.substring(0, ind) + RoomObject.readVar(var.substring(ind + 1, var.indexOf(41)), player, house, gs);
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(41) + 1, var.length());
            }
            return RoomObject.readVar(s, player, house, gs);
        }
        ind = var.indexOf(43);
        if (ind > 0) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs) + RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs);
        }
        ind = var.indexOf(45);
        if (ind > 0) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs) - RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs);
        }
        ind = var.indexOf(42);
        if (ind > -1) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs) * RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs);
        }
        ind = var.indexOf(47);
        if (ind > -1) {
            return RoomObject.readVar(var.substring(0, ind), player, house, gs) / RoomObject.readVar(var.substring(ind + 1, var.length()), player, house, gs);
        }
        if (RoomObject.testNumeric(var)) {
            return Stringer.parseInt(var);
        }
        if (hcVar.equals("MONEY")) {
            return Player.money;
        }
        if (hcVar.equals("FRAGS")) {
            return player.frags;
        }
        if (hcVar.indexOf("AMMO_") == 0) {
            String tmp = var.substring(5, var.length());
            int weapon = RoomObject.readVar(tmp, player, house, gs);
            if (Arsenal.weapons[weapon] != null) {
                return Arsenal.weapons[weapon].magazine.ammo;
            }
            return 0;
        }
        if (var.indexOf(58) != -1) {
            String objname = var.substring(0, var.indexOf(58));
            String command = var.substring(var.indexOf(58) + 1, var.length());
            String hcCommand = command.toUpperCase();
            RoomObject obj = null;
            Vector objs = house.getObjects();
            if (objname.equalsIgnoreCase("player")) {
                obj = player;
            }
            if (objs.size() > 0 && obj == null) {
                for (int i = 0; i < objs.size(); ++i) {
                    if (!((RoomObject)objs.elementAt((int)i)).name.equals(objname)) continue;
                    obj = (RoomObject)objs.elementAt(i);
                    break;
                }
            }
            if (obj != null) {
                if (hcCommand.equals("HP") && obj instanceof GameObject) {
                    return ((GameObject)obj).getHp();
                }
                if (hcCommand.equals("HP") && !(obj instanceof GameObject)) {
                    return 100;
                }
            }
        }
        if (RoomObject.containsCollected(Player.usedPoints, var, player, house, gs)) {
            return 1;
        }
        return 0;
    }

    public static boolean readBoolean(String var, Player player, House house, GameScreen gs) {
        int ind = (var = Stringer.deleteExtremeSpaces(var)).indexOf(40);
        if (ind > -1) {
            String s = var.substring(0, ind) + RoomObject.readBoolean(var.substring(ind + 1, var.indexOf(41)), player, house, gs);
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(41) + 1, var.length());
            }
            boolean bol = RoomObject.readBoolean(s, player, house, gs);
            if (ind >= 1 && var.charAt(ind - 1) == '!') {
                return !bol;
            }
            return bol;
        }
        ind = var.indexOf(124);
        if (ind > -1) {
            return RoomObject.readBoolean(var.substring(0, ind), player, house, gs) || RoomObject.readBoolean(var.substring(ind + 1, var.length()), player, house, gs);
        }
        ind = var.indexOf(38);
        if (ind > -1) {
            return RoomObject.readBoolean(var.substring(0, ind), player, house, gs) && RoomObject.readBoolean(var.substring(ind + 1, var.length()), player, house, gs);
        }
        return RoomObject.containsCollected(Player.usedPoints, var, player, house, gs);
    }

    public static String readString(String var, Player player, House house, GameScreen gs) {
        int ind = (var = Stringer.deleteExtremeSpaces(var)).indexOf(91);
        if (ind > -1) {
            String s = var.substring(0, ind) + '\"' + String.valueOf(RoomObject.readVar(var.substring(ind + 1, var.indexOf(93)), player, house, gs)) + '\"';
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(93) + 1, var.length());
            }
            return RoomObject.readString(s, player, house, gs);
        }
        ind = var.indexOf(40);
        if (ind > -1) {
            String s = var.substring(0, ind) + '\"' + RoomObject.readString(var.substring(ind + 1, var.indexOf(41)), player, house, gs) + '\"';
            if (ind + 1 < var.length()) {
                s = s + var.substring(var.indexOf(41) + 1, var.length());
            }
            return RoomObject.readString(s, player, house, gs);
        }
        ind = var.indexOf(43);
        if (ind > -1 && var.charAt(ind - 1) == '\"' && var.charAt(ind + 1) == '\"') {
            return RoomObject.readString(var.substring(0, ind), player, house, gs) + RoomObject.readString(var.substring(ind + 1, var.length()), player, house, gs);
        }
        if (Stringer.countChars(var, '\"') == 2) {
            return var.substring(1, var.length() - 1);
        }
        return "null";
    }

    public static boolean testNumeric(String var) {
        char c = var.charAt(0);
        return c == '-' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    public void give(String name, Player player) {
        String newName = name;
        if (newName == null) {
            return;
        }
        boolean inverse = false;
        if (newName.indexOf(33) == 0) {
            inverse = true;
            newName = newName.substring(1, newName.length());
        }
        if (inverse) {
            Player.usedPoints.removeElement(newName);
        }
        if (!inverse && !RoomObject.containsSimple(Player.usedPoints, newName)) {
            Player.usedPoints.addElement(newName);
        }
    }

    public abstract void activate(House var1, Player var2, GameScreen var3);

    public void errMsg(GameScreen gs) {
        if (this.errMessageDelay > 0L) {
            GameScreen.delayDialogs.addElement(new DelayedDialog(this.errMessageTimeOut, this.errMessageType, this.errMessage, this.errMessageDelay));
            return;
        }
        if (this.errMessageType > 0) {
            gs.customMessage = this.errMessage;
            gs.customMessagePause = false;
            gs.customMessageEndTime = System.currentTimeMillis() + this.errMessageTimeOut;
            if (this.errMessageType == 2) {
                gs.customMessagePause = true;
                gs.customMessageEndTime = this.errMessageTimeOut;
            }
            GameScreen.lines.removeAllElements();
            gs.fillLines(this.message, GameScreen.lines);
        }
        if (this.errMessageType == 0) {
            gs.showDialog(this.errMessage);
        }
    }

    public void prMsg(GameScreen gs) {
        if (this.messageDelay > 0L) {
            GameScreen.delayDialogs.addElement(new DelayedDialog(this.messageTimeOut, this.messageType, this.message, this.messageDelay));
            return;
        }
        if (this.messageType > 0) {
            gs.customMessage = this.message;
            gs.customMessagePause = false;
            gs.customMessageEndTime = System.currentTimeMillis() + this.messageTimeOut;
            if (this.messageType == 2) {
                gs.customMessagePause = true;
                gs.customMessageEndTime = this.messageTimeOut;
            }
            GameScreen.lines.removeAllElements();
            gs.fillLines(this.message, GameScreen.lines);
        }
        if (this.messageType == 0) {
            gs.showDialog(this.message);
        }
    }

    public void drawDebug(Graphics g, Graphics3D g3d, int yy, boolean canReact, House house) {
        Room rm;
        if (!this.activable) {
            return;
        }
        if (this.squarePoint) {
            this.drawDebugSquare(g, g3d, yy, canReact, house);
            return;
        }
        vert.set(this.getPosX(), this.getPosY(), this.getPosZ());
        if (this.pointOffset != null) {
            vert.set(this.getPosX() + this.pointOffset.x, this.getPosY() + this.pointOffset.y, this.getPosZ() + this.pointOffset.z);
        }
        vert.transform(g3d.getInvCamera());
        vert.project(g3d);
        int px = RoomObject.vert.sx;
        int py = RoomObject.vert.sy;
        if (this.part != -1 && (rm = house.getRooms()[this.part]) != null && !rm.isOnRoom(px, py)) {
            return;
        }
        int rad = this.pointRadius * g3d.distX;
        if (-RoomObject.vert.rz + g3d.distX > 0) {
            rad /= -RoomObject.vert.rz + g3d.distX;
        }
        int height = this.pointHeight * g3d.distY;
        if (-RoomObject.vert.rz + g3d.distY > 0) {
            height /= -RoomObject.vert.rz + g3d.distY;
        }
        if (this.dynamicPoint) {
            RoomObject obj;
            if (this instanceof MeshObject) {
                obj = (MeshObject)this;
                ((MeshObject)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((MeshObject)obj).boundingBox.getMaxX() + ((MeshObject)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((MeshObject)obj).boundingBox.getMaxY() + ((MeshObject)obj).boundingBox.getMinY()) / 2;
                rad = (((MeshObject)obj).boundingBox.getMaxX() - ((MeshObject)obj).boundingBox.getMinX()) / 2;
                height = (((MeshObject)obj).boundingBox.getMaxY() - ((MeshObject)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof NPC) {
                obj = (NPC)this;
                ((NPC)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((NPC)obj).boundingBox.getMaxX() + ((NPC)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((NPC)obj).boundingBox.getMaxY() + ((NPC)obj).boundingBox.getMinY()) / 2;
                rad = (((NPC)obj).boundingBox.getMaxX() - ((NPC)obj).boundingBox.getMinX()) / 2;
                height = (((NPC)obj).boundingBox.getMaxY() - ((NPC)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof SpriteObject) {
                obj = (SpriteObject)this;
                ((SpriteObject)obj).spr.project(g3d.getInvCamera(), g3d);
                RoomObject.vert.sx = (((SpriteObject)obj).spr.pos.sx + ((SpriteObject)obj).spr.size.sx) / 2;
                RoomObject.vert.sy = (((SpriteObject)obj).spr.pos.sy + ((SpriteObject)obj).spr.size.sy) / 2;
                rad = (((SpriteObject)obj).spr.size.sx - ((SpriteObject)obj).spr.pos.sx) / 2;
                height = (((SpriteObject)obj).spr.size.sy - ((SpriteObject)obj).spr.pos.sy) / 2;
            }
        }
        if (RoomObject.vert.rz < 0) {
            g.setColor(0, 0, 0);
            g.fillArc(px - 3, py - 3 + yy, 7, 7, 0, 360);
            g.setColor(255, 0, 0);
            int xx = RoomObject.vert.sx - g3d.width / 2;
            xx *= xx;
            int yyy = RoomObject.vert.sy - g3d.height / 2;
            if (height == 0) {
                height = 1;
            }
            if (xx + (yyy = yyy * yyy * rad / height) < rad * rad && canReact) {
                g.setColor(0, 255, 0);
            }
            if (!this.needToPoint) {
                g.setColor(255, 255, 255);
            }
            g.fillArc(px - 2, py - 2 + yy, 5, 5, 0, 360);
            if (this.needToPoint) {
                g.drawArc(RoomObject.vert.sx - rad, RoomObject.vert.sy - height + yy, rad * 2, height * 2, 0, 360);
            }
            if (this.needToPoint && this instanceof Bot) {
                g.drawArc(RoomObject.vert.sx - rad / 2, RoomObject.vert.sy - height + yy, rad, height * 2 / 5, 0, 360);
            }
            this.printName(g, px, py + yy);
            g.setColor(255, 255, 255);
        }
    }

    public void drawDebugSquare(Graphics g, Graphics3D g3d, int yy, boolean canReact, House house) {
        Room rm;
        if (!this.activable) {
            return;
        }
        vert.set(this.getPosX(), this.getPosY(), this.getPosZ());
        if (this.pointOffset != null) {
            vert.set(this.getPosX() + this.pointOffset.x, this.getPosY() + this.pointOffset.y, this.getPosZ() + this.pointOffset.z);
        }
        vert.transform(g3d.getInvCamera());
        vert.project(g3d);
        int px = RoomObject.vert.sx;
        int py = RoomObject.vert.sy;
        if (this.part != -1 && (rm = house.getRooms()[this.part]) != null && !rm.isOnRoom(px, py)) {
            return;
        }
        int rad = this.pointRadius * g3d.distX / (-RoomObject.vert.rz + g3d.distX);
        int height = this.pointHeight * g3d.distY / (-RoomObject.vert.rz + g3d.distY);
        if (this.dynamicPoint) {
            RoomObject obj;
            if (this instanceof MeshObject) {
                obj = (MeshObject)this;
                ((MeshObject)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((MeshObject)obj).boundingBox.getMaxX() + ((MeshObject)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((MeshObject)obj).boundingBox.getMaxY() + ((MeshObject)obj).boundingBox.getMinY()) / 2;
                rad = (((MeshObject)obj).boundingBox.getMaxX() - ((MeshObject)obj).boundingBox.getMinX()) / 2;
                height = (((MeshObject)obj).boundingBox.getMaxY() - ((MeshObject)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof NPC) {
                obj = (NPC)this;
                ((NPC)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((NPC)obj).boundingBox.getMaxX() + ((NPC)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((NPC)obj).boundingBox.getMaxY() + ((NPC)obj).boundingBox.getMinY()) / 2;
                rad = (((NPC)obj).boundingBox.getMaxX() - ((NPC)obj).boundingBox.getMinX()) / 2;
                height = (((NPC)obj).boundingBox.getMaxY() - ((NPC)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof SpriteObject) {
                obj = (SpriteObject)this;
                ((SpriteObject)obj).spr.project(g3d.getInvCamera(), g3d);
                RoomObject.vert.sx = (((SpriteObject)obj).spr.pos.sx + ((SpriteObject)obj).spr.size.sx) / 2;
                RoomObject.vert.sy = (((SpriteObject)obj).spr.pos.sy + ((SpriteObject)obj).spr.size.sy) / 2;
                rad = (((SpriteObject)obj).spr.size.sx - ((SpriteObject)obj).spr.pos.sx) / 2;
                height = (((SpriteObject)obj).spr.size.sy - ((SpriteObject)obj).spr.pos.sy) / 2;
            }
        }
        if (RoomObject.vert.rz < 0) {
            g.setColor(0, 0, 0);
            g.fillArc(px - 3, py - 3 + yy, 7, 7, 0, 360);
            g.setColor(255, 0, 0);
            int xx = RoomObject.vert.sx - g3d.width / 2;
            xx *= xx;
            int yyy = RoomObject.vert.sy - g3d.height / 2;
            yyy *= yyy;
            if (xx < rad * rad && yyy < height * height && canReact) {
                g.setColor(0, 255, 0);
            }
            if (!this.needToPoint) {
                g.setColor(255, 255, 255);
            }
            g.fillArc(px - 2, py - 2 + yy, 5, 5, 0, 360);
            if (this.needToPoint) {
                g.drawRect(RoomObject.vert.sx - rad, RoomObject.vert.sy - height + yy, rad * 2, height * 2);
            }
            if (this.needToPoint && this instanceof Bot) {
                g.drawRect(RoomObject.vert.sx - rad / 2, RoomObject.vert.sy - height + yy, rad, height * 2 / 5);
            }
            this.printName(g, px, py + yy);
            g.setColor(255, 255, 255);
        }
    }

    private void printName(Graphics g, int px, int py) {
        if (this.name != null) {
            int col = g.getColor();
            g.setColor(0);
            g.drawString(this.name, px + 5, py - 5, 68);
            g.drawString(this.name, px + 4, py - 5, 68);
            g.drawString(this.name, px + 6, py - 5, 68);
            g.drawString(this.name, px + 4, py - 4, 68);
            g.drawString(this.name, px + 6, py - 4, 68);
            g.drawString(this.name, px + 4, py - 6, 68);
            g.drawString(this.name, px + 6, py - 6, 68);
            g.setColor(col);
            g.drawString(this.name, px + 5, py - 5, 68);
        }
    }

    public boolean check(Graphics3D g3d, int yy) {
        if (!this.activable) {
            return false;
        }
        if (!this.needToPoint) {
            return true;
        }
        vert.set(this.getPosX(), this.getPosY(), this.getPosZ());
        if (this.pointOffset != null) {
            vert.set(this.getPosX() + this.pointOffset.x, this.getPosY() + this.pointOffset.y, this.getPosZ() + this.pointOffset.z);
        }
        vert.transform(g3d.getInvCamera());
        vert.project(g3d);
        int rad = this.pointRadius * g3d.distX;
        if (-RoomObject.vert.rz + g3d.distX > 0) {
            rad /= -RoomObject.vert.rz + g3d.distX;
        }
        int height = this.pointHeight * g3d.distY;
        if (-RoomObject.vert.rz + g3d.distY > 0) {
            height /= -RoomObject.vert.rz + g3d.distY;
        }
        if (this.dynamicPoint) {
            RoomObject obj;
            if (this instanceof MeshObject) {
                obj = (MeshObject)this;
                ((MeshObject)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((MeshObject)obj).boundingBox.getMaxX() + ((MeshObject)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((MeshObject)obj).boundingBox.getMaxY() + ((MeshObject)obj).boundingBox.getMinY()) / 2;
                rad = (((MeshObject)obj).boundingBox.getMaxX() - ((MeshObject)obj).boundingBox.getMinX()) / 2;
                height = (((MeshObject)obj).boundingBox.getMaxY() - ((MeshObject)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof NPC) {
                obj = (NPC)this;
                ((NPC)obj).boundingBox.isVisible(g3d, g3d.computeFinalMatrix(((GameObject)obj).getCharacter().getTransform()), 0, 0, g3d.width, g3d.height);
                RoomObject.vert.sx = (((NPC)obj).boundingBox.getMaxX() + ((NPC)obj).boundingBox.getMinX()) / 2;
                RoomObject.vert.sy = (((NPC)obj).boundingBox.getMaxY() + ((NPC)obj).boundingBox.getMinY()) / 2;
                rad = (((NPC)obj).boundingBox.getMaxX() - ((NPC)obj).boundingBox.getMinX()) / 2;
                height = (((NPC)obj).boundingBox.getMaxY() - ((NPC)obj).boundingBox.getMinY()) / 2;
            } else if (this instanceof SpriteObject) {
                obj = (SpriteObject)this;
                ((SpriteObject)obj).spr.project(g3d.getInvCamera(), g3d);
                RoomObject.vert.sx = (((SpriteObject)obj).spr.pos.sx + ((SpriteObject)obj).spr.size.sx) / 2;
                RoomObject.vert.sy = (((SpriteObject)obj).spr.pos.sy + ((SpriteObject)obj).spr.size.sy) / 2;
                rad = (((SpriteObject)obj).spr.size.sx - ((SpriteObject)obj).spr.pos.sx) / 2;
                height = (((SpriteObject)obj).spr.size.sy - ((SpriteObject)obj).spr.pos.sy) / 2;
            }
        }
        if (RoomObject.vert.rz < 0) {
            if (this.squarePoint) {
                int xx = RoomObject.vert.sx - g3d.width / 2;
                xx *= xx;
                int yyy = RoomObject.vert.sy - g3d.height / 2;
                yyy *= yyy;
                if (xx < rad * rad && yyy < height * height) {
                    return true;
                }
            } else {
                int xx = RoomObject.vert.sx - g3d.width / 2;
                xx *= xx;
                int yyy = RoomObject.vert.sy - g3d.height / 2;
                if (height == 0) {
                    height = 1;
                }
                if (xx + (yyy = yyy * yyy * rad / height) < rad * rad) {
                    return true;
                }
            }
        }
        return false;
    }
}

