/*
 * Decompiled with CFR 0.152.
 */
package com.HUD.Base;

import com.HUD.Base.Font;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class Text {
    public Vector lines = new Vector();
    private Font font;
    private int wSpace;
    private int hSpace;
    private int width;
    private int height;
    private boolean centreAlign = false;
    private int y;

    public Text(String str, int wSpace, int hSpace, int width, int height, Font font) {
        this.font = font;
        this.wSpace = wSpace;
        this.hSpace = hSpace;
        this.width = width;
        this.height = height;
        str = Text.deleteCR(str);
        this.fillLines(str, this.lines);
        this.y = hSpace;
    }

    public int lineHeight() {
        return this.font.height() + 3;
    }

    private static String deleteCR(String str) {
        StringBuffer var2 = new StringBuffer(str);
        int var1 = 0;
        while (var1 < var2.length()) {
            if (var2.charAt(var1) == '\r') {
                var2.deleteCharAt(var1);
                continue;
            }
            ++var1;
        }
        return var2.toString();
    }

    private void fillLines(String str, Vector lines) {
        int var3 = 0;
        int var4 = 0;
        int var5 = -1;
        int var6 = 0;
        while (var6 < str.length()) {
            char var7 = str.charAt(var6);
            if (var7 == ' ') {
                var5 = var6;
            }
            if (var7 != '\n' && var3 + this.font.widthOf(var7) <= this.width) {
                var3 += this.font.widthOf(var7);
                ++var6;
                continue;
            }
            int var8 = var4;
            if (var7 == '\n') {
                var8 = var6++;
            } else if (var3 + this.font.widthOf(var7) > this.width) {
                if (var5 != -1) {
                    var8 = var5;
                    var6 = var5;
                } else {
                    var8 = var6;
                }
            }
            String var9 = str.substring(var4, var8);
            lines.addElement(var9);
            var3 = 0;
            var4 = var6;
        }
        if (var4 < str.length()) {
            lines.addElement(str.substring(var4, str.length()));
        }
    }

    public final void draw(Graphics g) {
        int var2 = this.lineHeight();
        int var3 = this.y;
        for (int var4 = 0; var4 < this.lines.size(); ++var4) {
            if (var3 >= this.hSpace) {
                if (var3 + var2 > this.height + this.hSpace) break;
                String var5 = (String)this.lines.elementAt(var4);
                int var6 = this.centreAlign ? this.width - this.font.widthOf(var5, g) >> 1 : 0;
                this.font.drawString(g, var5, var6 + this.wSpace, var3, 0);
            }
            var3 += var2;
        }
    }

    public final void move(int dy) {
        dy += this.y;
        int var2 = this.lineHeight() * this.lines.size();
        if (var2 > this.height) {
            if (dy <= this.hSpace && dy + var2 >= this.hSpace + this.height - this.lineHeight()) {
                this.y = dy;
                return;
            }
        } else if (dy >= this.hSpace && dy + var2 < this.height + this.hSpace) {
            this.y = dy;
        }
    }

    public final void setY(int dy) {
        int var2 = this.lineHeight() * this.lines.size();
        if (var2 > this.height) {
            if (dy <= this.hSpace && dy + var2 >= this.hSpace + this.height - this.lineHeight()) {
                this.y = dy;
                return;
            }
        } else if (dy >= this.hSpace && dy + var2 < this.height + this.hSpace) {
            this.y = dy;
        }
    }

    public final int getY() {
        return this.y;
    }

    public final void setCentreAlign(boolean flag) {
        this.centreAlign = true;
    }
}

