/*
 * Decompiled with CFR 0.152.
 */
package com.misc;

import com.AI.Player;
import com.AI.misc.Blood;
import com.AI.misc.Splinter;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Shop;
import com.Gameplay.Weapon;
import com.HUD.Base.Font;
import com.HUD.GameHelp;
import com.HUD.Menu;
import com.HUD.MyCanvas.MainCanvas;
import com.HUD.MyCanvas.MyCanvas;
import com.HUD.SplashScreen;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshClone;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import com.misc.Stringer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Main
extends MIDlet {
    private boolean run = false;
    public static int lastLevel;
    private static Font font;
    public static Stringer gameText;
    public static boolean mipMapping;
    public static Vector3D Pspeed;
    public static String Blood;
    public static Matrix Pmatrix;
    private static String savename;
    public static boolean debug;
    public static boolean corpses;
    public static boolean hideHud;
    public static boolean blood;
    public static boolean frameskip;
    public static int displaySize;
    public static MeshImage zombiemod;
    public static MultyTexture zombietex;
    public static MeshImage bigzombiemod;
    public static MultyTexture bigzombietex;
    public static boolean fullScreenSight;
    public static float bloodscale;
    public static float splinterscale;
    public static int zombieanimspeed;
    public static int zombieattackanimspeed;
    public static int zombieprice;
    public static int zombiedamage;
    public static float zombieattackradius;
    public static int zombiejumpheight;
    public static float zombiejumpspeed;
    public static int zombiespeed;
    public static int zombiereacttimer;
    public static int zombieattacktimer;
    public static int zombieai;
    public static int zombieplayerreaction;
    public static int zombieattacktrigger;
    public static int offsetsz;
    public static int bigzombieanimspeed;
    public static int bigzombieattackanimspeed;
    public static int bigzombiedamage;
    public static float bigzombieattackradius;
    public static int bigzombiejumpheight;
    public static float bigzombiejumpspeed;
    public static int bigzombiejumpheight2;
    public static float bigzombiejumpspeed2;
    public static int bigzombiespeed;
    public static int bigzombiereacttimer;
    public static int bigzombieattacktimer;
    public static int bigzombieai;
    public static int bigzombieplayerreaction;
    public static int bigzombieattacktrigger;
    public static int bigzombieprice;
    public static int lang;
    public static int q;
    public static String life_icon;
    public static String hand_icon;
    public static String money_icon;
    public static String patron_icon;
    public static String sight_icon;
    public static String skull_icon;
    public static String background_logo;
    public static String background;
    public static String shop_patron;
    public static String shop_medkit;
    public static String splash;
    public static String[] stepSound;
    public static String jumpSound;
    public static String menuMusic;
    public static boolean canSave;
    public static boolean canSelectLevel;
    public static boolean hasZoom;
    public static boolean levelSelectorLoadData;
    public static int minZoom;
    public static int maxZoom;
    public static String[] langs;
    public static Image bcks;
    public static Image bcks2;
    public static boolean updateOnlyNear;
    public static Stringer settings;
    public static boolean landspace;
    public static boolean hidesight;
    public static int fogQ;
    public static int pixelsQ;
    public static int persQ;
    private int availableLevel = 1;
    public static boolean forceLQFog;
    public static boolean chunksSupport;
    public static boolean originalSight;
    public static boolean originalUseIcon;
    public static int music;
    public static int sounds;
    public static int footsteps;
    public static int mouseSpeed;
    public static boolean saveState;
    public static boolean isMusic;
    public static boolean isSounds;
    public static boolean isFootsteps;
    public static boolean verticalShopScroll;
    public static MainCanvas mainCanvas;
    public static final boolean s60Optimization = true;

    public static boolean isExist(String file) {
        try {
            InputStream var2 = file.getClass().getResourceAsStream(file);
            if (var2 == null) {
                return false;
            }
            var2.close();
            return true;
        }
        catch (Exception var1) {
            return false;
        }
    }

    public String getInfo(Stringer str, String getinfo, String std) {
        if (str.getString(getinfo) != null) {
            return str.getString(getinfo);
        }
        return std;
    }

    protected final void startApp() {
        if (!this.run) {
            int var1;
            this.run = true;
            for (var1 = 0; var1 < 50 && Main.isExist("/level" + (var1 + 1) + ".txt"); ++var1) {
            }
            settings = Stringer.createFromResourceWithKeys("/setting.txt");
            String sn = settings.getString2("SAVE_NAME");
            if (sn != null) {
                savename = sn;
            }
            if (settings.getString2("DEBUG") != null && settings.getInt2("DEBUG") == 1) {
                debug = true;
            }
            if (settings.getString2("SPLINTER_SCALE") != null) {
                splinterscale = settings.getFloat2("SPLINTER_SCALE");
            }
            if (settings.getString2("BLOOD_SCALE") != null) {
                bloodscale = settings.getFloat2("BLOOD_SCALE");
            }
            if (settings.getString2("CANSAVE") != null && settings.getInt2("CANSAVE") == 0) {
                canSave = false;
            }
            if (settings.getString2("SAVESTATE") != null && settings.getInt2("SAVESTATE") == 1) {
                saveState = true;
            }
            if (settings.getString2("SHOPSCROLL") != null && settings.getString2("SHOPSCROLL").equals("VERTICAL")) {
                verticalShopScroll = true;
            }
            if (settings.getString2("HIDESIGHT") != null && settings.getInt2("HIDESIGHT") == 1) {
                hidesight = true;
            }
            if (settings.getString2("CANSELECTLEVEL") != null && settings.getInt2("CANSELECTLEVEL") == 0) {
                canSelectLevel = false;
            }
            if (settings.getString2("LEVELSELECTOR_LOAD_DATA") != null && settings.getInt2("LEVELSELECTOR_LOAD_DATA") == 1) {
                levelSelectorLoadData = true;
            }
            menuMusic = settings.getString2("MENU_MUSIC");
            lastLevel = var1;
            System.out.println("Levels:" + lastLevel);
            this.setLanguage("/languages/english.txt");
            Splinter.texture = Texture.createTexture(this.getInfo(settings, "SPLINTER_SPRITE", "/splinter.png"));
            com.AI.misc.Blood.blood = Texture.createTexture(this.getInfo(settings, "BLOOD_SPRITE", "/blood.png"));
            if (settings.getString2("TEXT_BCK") != null) {
                try {
                    bcks = Image.createImage((String)settings.getString("TEXT_BCK"));
                }
                catch (Exception var3) {
                    System.out.println("No text background");
                }
            }
            if (settings.getString2("DIALOG_BCK") != null) {
                try {
                    bcks2 = Image.createImage((String)settings.getString("DIALOG_BCK"));
                }
                catch (Exception var3) {
                    System.out.println("No dialog background");
                }
            }
            life_icon = this.getInfo(settings, "LIFE_ICON", "/life.png");
            money_icon = this.getInfo(settings, "MONEY_ICON", "/money.png");
            patron_icon = this.getInfo(settings, "PATRON_ICON", "/patron.png");
            sight_icon = this.getInfo(settings, "SIGHT_ICON", "/sight.png");
            skull_icon = this.getInfo(settings, "SKULL_ICON", "/skull.png");
            hand_icon = this.getInfo(settings, "HAND_ICON", "/hand.png");
            background_logo = this.getInfo(settings, "BACKGROUND_LOGO", "/background.png");
            background = this.getInfo(settings, "BACKGROUND", "/background2.png");
            shop_patron = this.getInfo(settings, "SHOP_PATRON_ICON", "/icon_patron.png");
            shop_medkit = this.getInfo(settings, "SHOP_MEDKIT_ICON", "/icon_medicine_chest.png");
            splash = this.getInfo(settings, "SPLASH", "/splash.png");
            Main var4 = this;
            music = 100;
            footsteps = 100;
            sounds = 100;
            displaySize = 80;
            this.availableLevel = 1;
            landspace = false;
            frameskip = false;
            corpses = false;
            blood = false;
            chunksSupport = true;
            mipMapping = true;
            hideHud = false;
            lang = -1;
            q = 24;
            mouseSpeed = 66;
            if (System.getProperty("microedition.platform").equals("pstros")) {
                displaySize = 100;
                frameskip = true;
                fogQ = 2;
                pixelsQ = 2;
                persQ = 2;
                q = 12 + (1 - Math.min(1, persQ)) * 12;
            }
            try {
                if (MeshClone.getNumRecords(savename) != 0) {
                    byte[] var2 = MeshClone.getRecord(savename, 1);
                    ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                    DataInputStream var6 = new DataInputStream(var5);
                    music = var6.readInt();
                    sounds = var6.readInt();
                    footsteps = var6.readInt();
                    displaySize = var6.readInt();
                    this.availableLevel = var6.readInt();
                    persQ = var6.readInt();
                    fogQ = var6.readInt();
                    pixelsQ = var6.readInt();
                    frameskip = var6.readBoolean();
                    corpses = var6.readBoolean();
                    blood = var6.readBoolean();
                    mipMapping = var6.readBoolean();
                    debug = var6.readBoolean();
                    lang = var6.readInt();
                    q = 12 + (1 - Math.min(1, persQ)) * 12;
                    mouseSpeed = var6.readInt();
                    hideHud = var6.readBoolean();
                }
            }
            catch (Exception var3) {
                var3.printStackTrace();
            }
            Shop.initShop();
            if (settings.getString2("OPEN_LEVELS") != null) {
                this.availableLevel = Math.max(this.availableLevel, settings.getInt2("OPEN_LEVELS"));
            }
            langs = Mesh.cutOnStrings(Mesh.getStringFromResource("/languages/languages.txt"), ',');
            if (lang != -1) {
                String path = "/languages/" + langs[lang].toLowerCase() + ".txt";
                this.setLanguage(path);
            }
            mainCanvas = new MainCanvas(this);
            Main.setCurrent(new SplashScreen(this));
        }
    }

    protected final void pauseApp() {
    }

    protected final void destroyApp(boolean var1) {
        if (saveState && mainCanvas.getScreen() instanceof GameScreen) {
            GameScreen scr = (GameScreen)mainCanvas.getScreen();
            if (scr.player.getHp() > 0) {
                Main.saveGame(scr.levelNumber, scr.player);
            }
        }
    }

    public static final void setCurrent(MyCanvas canvas) {
        mainCanvas.setScreen(canvas);
    }

    public final void setCurrentRepaint(MyCanvas canvas) {
        mainCanvas.setScreen(canvas);
        canvas.repaint();
    }

    public final void setLanguage(String file) {
        gameText = Stringer.createFromResource(file);
        font = new Font(gameText.getString2("FONT"));
    }

    public static final Font getFont() {
        return font;
    }

    public static Stringer getGameText$6783a6a7() {
        return gameText;
    }

    public static Stringer getGameText() {
        return gameText;
    }

    public static final boolean isFrameskip() {
        return frameskip;
    }

    public static final boolean isCorpses() {
        return corpses;
    }

    public static final boolean isMipMapping() {
        return mipMapping;
    }

    public static final boolean isDebug() {
        return debug;
    }

    public final boolean isBlood() {
        return blood;
    }

    public static final void setDisplaySize(int size) {
        if (size < 50) {
            size = 50;
        }
        if (size > 100) {
            size = 100;
        }
        displaySize = size;
    }

    public static final int getDisplaySize() {
        return displaySize;
    }

    public final int getAvailableLevelCount() {
        return Math.min(this.availableLevel, lastLevel);
    }

    public final void addAvailableLevel(int level) {
        if (level + 1 > this.availableLevel && level + 1 <= lastLevel) {
            this.availableLevel = level + 1;
            this.saveSettingToStore();
        }
    }

    public static final boolean isLastLevel(int level) {
        return level >= lastLevel;
    }

    public final void saveSettingToStore() {
        try {
            String var1 = savename;
            try {
                RecordStore.deleteRecordStore((String)var1);
            }
            catch (RecordStoreException var5) {
                var5.printStackTrace();
            }
            ByteArrayOutputStream var7 = new ByteArrayOutputStream();
            DataOutputStream var2 = new DataOutputStream(var7);
            var2.writeInt(music);
            var2.writeInt(sounds);
            var2.writeInt(footsteps);
            var2.writeInt(displaySize);
            var2.writeInt(this.availableLevel);
            var2.writeInt(persQ);
            var2.writeInt(fogQ);
            var2.writeInt(pixelsQ);
            var2.writeBoolean(frameskip);
            var2.writeBoolean(corpses);
            var2.writeBoolean(blood);
            var2.writeBoolean(mipMapping);
            var2.writeBoolean(debug);
            var2.writeInt(lang);
            q = 12 + (1 - Math.min(persQ, 1)) * 12;
            var2.writeInt(mouseSpeed);
            var2.writeBoolean(hideHud);
            byte[] var3 = var7.toByteArray();
            var2.close();
            var7.close();
            String var9 = savename;
            byte[] var8 = var3;
            try {
                RecordStore var10 = RecordStore.openRecordStore((String)var9, (boolean)true);
                var10.addRecord(var8, 0, var8.length);
                var10.closeRecordStore();
            }
            catch (RecordStoreException var4) {
                var4.printStackTrace();
                return;
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
    }

    public static void drawBck(Graphics g, int beginy, int endy) {
        int y;
        if (bcks == null) {
            return;
        }
        int imgh = bcks.getHeight();
        int imgw = bcks.getWidth();
        int iy = 0;
        for (y = beginy - 1; y > beginy - imgh; --y) {
            g.drawRegion(bcks, 0, imgh - 2 - iy, imgw, 1, 0, 0, y, 0);
            ++iy;
        }
        for (y = beginy; y < endy; ++y) {
            g.drawRegion(bcks, 0, imgh - 1, imgw, 1, 0, 0, y, 0);
        }
        iy = imgh - 1;
        for (y = endy; y < endy + imgh; ++y) {
            g.drawRegion(bcks, 0, iy, imgw, 1, 0, 0, y, 0);
            --iy;
        }
    }

    public static void drawBckDialog(Graphics g, int beginy, int endy) {
        int y;
        if (bcks2 == null) {
            return;
        }
        int imgh = bcks2.getHeight();
        int imgw = bcks2.getWidth();
        int iy = 0;
        for (y = beginy - 1; y > beginy - imgh; --y) {
            g.drawRegion(bcks2, 0, imgh - 2 - iy, imgw, 1, 0, 0, y, 0);
            ++iy;
        }
        for (y = beginy; y < endy; ++y) {
            g.drawRegion(bcks2, 0, imgh - 1, imgw, 1, 0, 0, y, 0);
        }
        iy = imgh - 1;
        for (y = endy; y < endy + imgh; ++y) {
            g.drawRegion(bcks2, 0, iy, imgw, 1, 0, 0, y, 0);
            --iy;
        }
    }

    public static final void saveGame(int levelNum, Player player) {
        if (!canSave) {
            return;
        }
        try {
            int i;
            String var1 = savename + "_Player";
            try {
                RecordStore.deleteRecordStore((String)var1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ByteArrayOutputStream var7 = new ByteArrayOutputStream();
            DataOutputStream var2 = new DataOutputStream(var7);
            var2.writeInt(levelNum + 1);
            Matrix pos = player.getCharacter().getTransform();
            var2.writeInt(pos.m00);
            var2.writeInt(pos.m01);
            var2.writeInt(pos.m02);
            var2.writeInt(pos.m03);
            var2.writeInt(pos.m10);
            var2.writeInt(pos.m11);
            var2.writeInt(pos.m12);
            var2.writeInt(pos.m13);
            var2.writeInt(pos.m20);
            var2.writeInt(pos.m21);
            var2.writeInt(pos.m22);
            var2.writeInt(pos.m23);
            var2.writeInt(player.getCharacter().getSpeed().x);
            var2.writeInt(player.getCharacter().getSpeed().y);
            var2.writeInt(player.getCharacter().getSpeed().z);
            var2.writeInt(Player.money);
            var2.writeInt(player.getHp());
            var2.writeInt(player.fov);
            var2.writeInt(player.maxFov);
            var2.writeInt(player.minFov);
            var2.writeBoolean(player.zoom);
            int weapons = 0;
            int weapons2 = 0;
            Weapon[] weaps = Arsenal.getWeapons();
            if (weaps != null) {
                weapons = weaps.length;
            }
            for (i = 0; i < weapons; ++i) {
                if (weaps[i] == null) continue;
                ++weapons2;
            }
            System.out.println("write weapons count");
            var2.writeInt(weapons2);
            System.out.println("write weapon current");
            var2.writeInt(Arsenal.current);
            for (i = 0; i < weapons; ++i) {
                Weapon weapon = weaps[i];
                if (weapon == null) continue;
                var2.writeInt(i);
                var2.writeShort(weapon.magazine.ammo);
                var2.writeShort(weapon.magazine.rounds);
            }
            System.out.println("write keys");
            if (Player.usedPoints != null) {
                int el = Player.usedPoints.size();
                var2.writeInt(el);
                for (int i2 = 0; i2 < el; ++i2) {
                    var2.writeUTF((String)Player.usedPoints.elementAt(i2));
                }
            } else {
                var2.writeInt(0);
            }
            System.out.println("Game saved");
            byte[] var3 = var7.toByteArray();
            var2.close();
            var7.close();
            byte[] var8 = var3;
            RecordStore var10 = RecordStore.openRecordStore((String)var1, (boolean)true);
            var10.addRecord(var8, 0, var8.length);
            var10.closeRecordStore();
        }
        catch (RecordStoreException var6) {
            var6.printStackTrace();
        }
        catch (IOException var6) {
            var6.printStackTrace();
        }
    }

    public static final void loadGame(Player player, int w, int h) {
        if (!canSave) {
            return;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] var2 = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                DataInputStream var6 = new DataInputStream(var5);
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                var6.readInt();
                Player.money = var6.readInt();
                player.setHp(var6.readInt());
                player.fov = var6.readInt();
                player.maxFov = var6.readInt();
                player.minFov = var6.readInt();
                player.zoom = var6.readBoolean();
                int weapc = var6.readInt();
                int current = var6.readInt();
                Arsenal.destroy();
                Arsenal.current = current;
                Weapon[] weapons = new Weapon[Shop.weapon_count];
                for (int i = 0; i < weapc; ++i) {
                    int tw = var6.readInt();
                    weapons[tw] = Stringer.createWeapon(tw);
                    weapons[tw].createSprite(w, h * displaySize / 100);
                    weapons[tw].magazine.set(var6.readShort(), var6.readShort());
                }
                Arsenal.weapons = weapons;
                Player.usedPoints.removeAllElements();
                int objs = var6.readInt();
                for (int i = 0; i < objs; ++i) {
                    Player.usedPoints.addElement(var6.readUTF());
                }
            }
        }
        catch (Exception var3) {
            System.out.println("Error reading save file");
        }
    }

    public static final void loadPosition(Player player) {
        if (!canSave) {
            return;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] var2 = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                DataInputStream var6 = new DataInputStream(var5);
                var6.readInt();
                player.getCharacter().getTransform().set(var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt(), var6.readInt());
                player.getCharacter().getSpeed().set(var6.readInt(), var6.readInt(), var6.readInt());
            }
        }
        catch (Exception var3) {
            System.out.println("Error reading save file");
        }
    }

    public static final void loadLevel(boolean loadSave, boolean loadpos, int levelNumber, Object hudInfo, Main main, Menu menu) {
        Main.loadLevel(loadSave, loadpos, levelNumber, hudInfo, main, menu, 1);
    }

    public static final void loadLevel(boolean loadSave, boolean loadpos, int levelNumber, Object hudInfo, Main main, Menu menu, int helpState) {
        try {
            System.gc();
            Thread.sleep(5L);
            Fps.reset();
            String add = "";
            if (helpState > 1) {
                add = "_" + Integer.toString(helpState);
            }
            if (!(Main.getGameText$6783a6a7().getString2("GAME_HELP_TEXT_" + Integer.toString(levelNumber) + add) != null || levelNumber == 1 && add.equals("") && Main.getGameText$6783a6a7().getString2("GAME_HELP_TEXT") != null || Main.getGameText$6783a6a7().getString2("GAME_HELP_PREVIEW_" + Integer.toString(levelNumber) + add) != null || Main.getGameText$6783a6a7().getString2("GAME_HELP_BACKGROUND_" + Integer.toString(levelNumber) + add) != null)) {
                GameScreen gs = new GameScreen(main, levelNumber, hudInfo);
                if (loadSave) {
                    Main.loadGame(gs.player, gs.getWidth(), gs.getHeight());
                    if (loadpos) {
                        Main.loadPosition(gs.player);
                    }
                }
                gs.start();
                Main.setCurrent(gs);
            } else {
                GameHelp gh = new GameHelp(main, menu, levelNumber, hudInfo, helpState);
                GameHelp.loadSave = loadSave;
                GameHelp.loadpos = loadpos;
                Main.setCurrent(gh);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static final void removeSave() {
        if (!canSave) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)(savename + "_Player"));
        }
        catch (RecordStoreException var6) {
            System.out.println("Error removing save file");
        }
    }

    public static final int getContinueLevel() {
        if (!canSave) {
            return 1;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] var2 = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                DataInputStream var6 = new DataInputStream(var5);
                return var6.readInt() - 1;
            }
            return 1;
        }
        catch (Exception var3) {
            System.out.println("Error reading save file");
            return 1;
        }
    }

    public static final boolean hasSave() {
        if (!canSave) {
            return false;
        }
        try {
            byte[] var2;
            ByteArrayInputStream var5;
            DataInputStream var6;
            return MeshClone.getNumRecords(savename + "_Player") != 0 && (var6 = new DataInputStream(var5 = new ByteArrayInputStream(var2 = MeshClone.getRecord(savename + "_Player", 1)))).readInt() != 0;
        }
        catch (Exception var3) {
            return false;
        }
    }

    public static void setpersQ(int pq) {
        persQ = pq;
        q = 12 + (1 - Math.min(persQ, 1)) * 12;
    }

    static {
        mipMapping = true;
        Pspeed = new Vector3D();
        Blood = "/blood.png";
        Pmatrix = new Matrix();
        savename = "ZOMBIE";
        debug = false;
        corpses = false;
        hideHud = false;
        blood = false;
        frameskip = false;
        displaySize = 80;
        fullScreenSight = false;
        bloodscale = 1.0f;
        splinterscale = 1.0f;
        zombieanimspeed = 140;
        zombieattackanimspeed = 700;
        zombieprice = 10;
        zombiedamage = 1;
        zombieattackradius = 1.2f;
        zombiejumpheight = 140;
        zombiejumpspeed = 1.2f;
        zombiespeed = 140;
        zombiereacttimer = 8;
        zombieattacktimer = 8;
        zombieai = 1;
        zombieplayerreaction = 2;
        zombieattacktrigger = 2;
        offsetsz = 0;
        bigzombieanimspeed = 135;
        bigzombieattackanimspeed = 270;
        bigzombiedamage = 7;
        bigzombieattackradius = 1.2f;
        bigzombiejumpheight = 202;
        bigzombiejumpspeed = 1.2f;
        bigzombiejumpheight2 = 202;
        bigzombiejumpspeed2 = 1.5f;
        bigzombiespeed = 135;
        bigzombiereacttimer = 8;
        bigzombieattacktimer = 14;
        bigzombieai = 1;
        bigzombieplayerreaction = 2;
        bigzombieattacktrigger = 2;
        bigzombieprice = 30;
        lang = -1;
        q = 24;
        life_icon = "/life.png";
        hand_icon = "/hand.png";
        money_icon = "/money.png";
        patron_icon = "/patron.png";
        sight_icon = "/sight.png";
        skull_icon = "/skull.png";
        background_logo = "/background.png";
        background = "/background2.png";
        shop_patron = "/icon_patron.png";
        shop_medkit = "/icon_medicine_chest.png";
        splash = "/splash.png";
        stepSound = null;
        jumpSound = null;
        menuMusic = null;
        canSave = true;
        canSelectLevel = true;
        hasZoom = true;
        levelSelectorLoadData = false;
        minZoom = 5000;
        maxZoom = 10000;
        langs = null;
        bcks = null;
        bcks2 = null;
        updateOnlyNear = false;
        landspace = false;
        hidesight = false;
        fogQ = 2;
        pixelsQ = 0;
        persQ = 0;
        forceLQFog = false;
        chunksSupport = true;
        originalSight = false;
        originalUseIcon = false;
        music = 100;
        sounds = 100;
        footsteps = 100;
        mouseSpeed = 66;
        saveState = false;
        isMusic = true;
        isSounds = true;
        isFootsteps = true;
        verticalShopScroll = false;
    }
}

