/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private static boolean useMP3;
    private Player player = null;
    public String file;
    private int volume = 100;
    private int loopCount = 1;

    public Sound() {
    }

    public Sound(String file) {
        this.loadFile(file);
    }

    public static Sound createMusicPlayer() {
        Sound snd = new Sound();
        snd.loopCount = -1;
        return snd;
    }

    public void loadFile(String file) {
        try {
            this.destroy();
            String lcFile = file.toLowerCase();
            if (lcFile.equals("noone")) {
                return;
            }
            this.file = file;
            String format = Sound.formatCheck(lcFile);
            InputStream is = new Object().getClass().getResourceAsStream(file);
            this.player = Manager.createPlayer((InputStream)is, (String)format);
            this.player.realize();
            this.player.prefetch();
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.file = null;
        this.stop();
        try {
            if (this.player != null) {
                this.player.close();
            }
            this.player = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLoopCount(int count) {
        return this.loopCount;
    }

    public void setLoopCount(int count) {
        this.loopCount = count;
        if (this.player == null) {
            return;
        }
        try {
            this.player.setLoopCount(this.loopCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        this.start(0L);
    }

    public void start(long time) {
        if (this.player == null) {
            return;
        }
        try {
            this.setVolume(this.volume);
            this.player.setMediaTime(time);
            this.player.setLoopCount(this.loopCount);
            this.player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public long getTime() {
        if (this.player == null) {
            return 0L;
        }
        long t = this.player.getMediaTime();
        if (t == -1L) {
            t = 0L;
        }
        return t;
    }

    public void setTime(long time) {
        if (this.player == null) {
            return;
        }
        try {
            this.player.setMediaTime(time);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void setVolume(int i) {
        if (this.player == null) {
            return;
        }
        this.volume = i > 100 ? 100 : (i < 0 ? 0 : i);
        VolumeControl control = (VolumeControl)this.player.getControl("VolumeControl");
        if (control != null) {
            control.setLevel(this.volume);
        }
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public int getState() {
        if (this.player == null) {
            return -1;
        }
        return this.player.getState();
    }

    public static final String formatCheck(String file) {
        if (file.endsWith(".wav") || file.endsWith(".wave")) {
            return "audio/x-wav";
        }
        if (file.endsWith(".midi") || file.endsWith(".mid")) {
            return "audio/midi";
        }
        if (file.endsWith(".mp3")) {
            return useMP3 ? "audio/mp3" : "audio/mpeg";
        }
        if (file.endsWith(".amr")) {
            return "audio/amr";
        }
        if (file.endsWith(".jts")) {
            return "audio/x-tone-seq";
        }
        if (file.endsWith(".mxmf")) {
            return "audio/mobile-xmf";
        }
        if (file.endsWith(".mmf")) {
            return "application/vnd.yamaha.smaf-audio";
        }
        return "";
    }

    static {
        String[] conts = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < conts.length; ++i) {
            if (!conts[i].equals("audio/mp3")) continue;
            useMP3 = true;
            break;
        }
    }
}

