/*
 * Decompiled with CFR 0.152.
 */
package code.AI;

import code.AI.BigZombie;
import code.AI.NPC;
import code.AI.TPPose;
import code.AI.Zombie;
import code.Gameplay.Arsenal;
import code.Gameplay.GameScreen;
import code.Gameplay.Inventory.ItemList;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Map.Scene;
import code.Gameplay.Objects.GameObject;
import code.Gameplay.Weapon;
import code.HUD.Base.HUDInfo;
import code.HUD.DeveloperMenu;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.Camera;
import code.Rendering.DirectX7;
import code.utils.Asset;
import code.utils.Main;
import code.utils.QFPS;
import code.utils.WeaponCreator;
import java.util.Vector;

public final class Player
extends GameObject {
    public static String[] sndWalk = null;
    public static String sndJump = null;
    public static boolean arcadeJumpPhysics = false;
    public static boolean fallDamage = true;
    public static int walkSpeed = 150;
    public static Vector toAddOnStart = new Vector();
    public static Vector usedPoints = new Vector();
    public int money = 0;
    public int frags = 0;
    public int stepIndex = 0;
    public Arsenal arsenal;
    private boolean damage = false;
    public boolean zoom = false;
    public float fov = Main.stdFov;
    public int stdFov = Main.stdFov;
    public int zoomFov = Main.zoomFov;
    public long lastZoomAction = 0L;
    private int falldist = 0;
    private long lastStep = 0L;
    private long lastYCheck = 0L;
    private int lastY = 0;
    public float rotateX = 0.0f;
    public float rotateY = 0.0f;
    public ItemList items;
    int walkFrame;
    int attackFrame;
    int muzzleFrame;
    Camera cam;
    TPPose scenePose;

    public Player(int wG3D, int hG3D, Vector3D pos, Object hudInfo, TPPose scenePose) {
        this.set(wG3D, hG3D, pos, hudInfo, scenePose);
    }

    public final void set(int wG3D, int hG3D, Vector3D pos, Object hudInfo, TPPose scenePose) {
        this.name = "PLAYER";
        this.character.reset();
        this.character.getTransform().setPosition(0, 0, 0);
        if (pos != null) {
            this.character.getTransform().setPosition(pos.x, pos.y, pos.z);
        }
        this.setHp(100);
        this.frags = 0;
        this.setCharacterSize(400, 1503);
        this.falldist = 0;
        this.money = 0;
        this.rotateY = 0.0f;
        this.rotateX = 0.0f;
        this.arsenal = new Arsenal(wG3D, hG3D);
        if (hudInfo != null) {
            this.money = ((HUDInfo)hudInfo).money;
            int[] ammos = ((HUDInfo)hudInfo).ammo;
            Weapon[] weapons = this.arsenal.getWeapons();
            for (int i = 0; i < weapons.length; ++i) {
                if (weapons[i] != null) {
                    weapons[i].reset();
                }
                if (ammos[i] == -1) {
                    weapons[i] = null;
                    continue;
                }
                weapons[i] = WeaponCreator.createWeapon(i);
                weapons[i].setAmmo(ammos[i]);
            }
            if (this.arsenal.current != -1) {
                this.arsenal.currentWeapon().createSprite(wG3D, hG3D);
            }
        }
        this.items = new ItemList();
        this.character.fly = DeveloperMenu.fly > 0;
        this.walkFrame = 0;
        this.attackFrame = Integer.MAX_VALUE;
        this.muzzleFrame = 0;
        this.scenePose = scenePose;
        if (this.currentPose() != null) {
            this.cam = new Camera();
            if (TPPose.meshPoses != null) {
                TPPose.applyRenderModes(TPPose.meshPoses);
            }
            if (scenePose != null) {
                TPPose.applyRenderModes(new TPPose[]{scenePose});
            }
            if (TPPose.radius != 0) {
                this.setCharacterSize(TPPose.radius, TPPose.height);
            }
        }
    }

    public final void destroy() {
        this.money = 0;
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (Main.stepSound != null && Main.isFootsteps && Main.footsteps != 0 && (this.character.speed.x != 0 || this.character.speed.z != 0) && this.character.onFloor && System.currentTimeMillis() - this.lastStep > 450L && !this.character.fly) {
            String[] soundz = Main.stepSound;
            if (sndWalk != null) {
                soundz = sndWalk;
            }
            if (soundz != null && this.stepIndex >= soundz.length) {
                this.stepIndex = 0;
            }
            if (soundz != null) {
                try {
                    Asset.getSound(soundz[this.stepIndex]).setVolume(Main.footsteps);
                    Asset.getSound(soundz[this.stepIndex]).start(0L);
                    ++this.stepIndex;
                }
                catch (Exception var2) {
                    System.err.println("ERROR in Step sound: " + var2);
                }
            }
            this.lastStep = System.currentTimeMillis();
        }
        if (this.arsenal.currentWeapon() != null) {
            this.arsenal.currentWeapon().renderSplinter(g3d);
        }
        if (this.currentPose() != null) {
            this.currentPose().draw(this, g3d, x1, y1, x2, y2);
        }
    }

    public void nextWeapon() {
        int old = this.arsenal.current;
        this.arsenal.next();
        if (old != this.arsenal.current) {
            this.attackFrame = Integer.MAX_VALUE;
            this.muzzleFrame = 0;
        }
    }

    public void previousWeapon() {
        int old = this.arsenal.current;
        this.arsenal.previous();
        if (old != this.arsenal.current) {
            this.attackFrame = Integer.MAX_VALUE;
            this.muzzleFrame = 0;
        }
    }

    public final void update(Scene scene, Player player) {
        super.update(scene, player);
        sndWalk = scene.getHouse().getRooms()[this.getPart()].stepSound;
        sndJump = scene.getHouse().getRooms()[this.getPart()].jumpSound;
        if (fallDamage) {
            if (!this.character.onFloor && System.currentTimeMillis() - this.lastYCheck < 1000L) {
                this.falldist += this.lastY - this.getPosY();
            }
            if (this.falldist > 7000 && this.character.onFloor) {
                this.damage = true;
                this.damage((this.falldist - 7000) / 40);
            }
            if (this.falldist > 11000 && !this.character.onFloor) {
                this.damage = true;
                this.damage(100);
            }
            this.lastYCheck = System.currentTimeMillis();
            this.lastY = this.getPosY();
            if (this.character.onFloor || this.character.fly) {
                this.falldist = 0;
            }
        }
        if (this.arsenal.current != -1 && this.arsenal.currentWeapon() != null) {
            GameObject obj = this.arsenal.currentWeapon().update(scene.getHouse(), this);
            if (obj instanceof Zombie) {
                this.money += Zombie.moneyOnDeath;
                ++this.frags;
            } else if (obj instanceof BigZombie) {
                this.money += BigZombie.moneyOnDeath;
                ++this.frags;
            } else if (obj instanceof NPC) {
                NPC npc = (NPC)obj;
                this.frags += npc.fragsOnDeath;
                this.money += npc.moneyOnDeath;
                scene.runScript(new Object[]{npc, npc.onDeath});
            }
        }
        if (this.cam != null) {
            if (this.currentPose() != null) {
                this.currentPose().update(this.cam, this);
            }
            this.cam.calcPart(scene.getHouse());
            if (this.cam.getPart() == -1 && this.getPart() != -1) {
                this.cam.setPart(this.getPart());
            }
        }
    }

    public TPPose currentPose() {
        if (this.scenePose != null) {
            return this.scenePose;
        }
        if (TPPose.meshPoses == null) {
            return null;
        }
        Weapon wp = this.arsenal.currentWeapon();
        if (wp == null) {
            return TPPose.meshPoses[0];
        }
        return TPPose.meshPoses[wp.playerPose];
    }

    public boolean canWalk() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canWalk(this);
    }

    public boolean canJump() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canJump(this);
    }

    public boolean canLookX() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canLookX(this);
    }

    public boolean canLookY() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canLookY(this);
    }

    public boolean canAttack() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canAttack(this);
    }

    public boolean canAttackSight() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canAttackSight;
    }

    public boolean canAttackNoSight() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.canAttack;
    }

    public boolean isSwapStrafeLook() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return false;
        }
        return tppose.isSwapStrafeLook(this);
    }

    public boolean isRotToWalkDir() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return false;
        }
        return tppose.isRotToWalkDir(this);
    }

    public boolean show2D() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return true;
        }
        return tppose.show2D(this);
    }

    public float lookSpeed() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return this.zoom ? 0.71f : 1.0f;
        }
        return tppose.lookSpeed(this);
    }

    public int walkSpeed() {
        TPPose tppose = this.currentPose();
        if (tppose == null) {
            return walkSpeed;
        }
        return tppose.walkSpeed(this);
    }

    public void setCamera(DirectX7 g3d) {
        Matrix playerMat = this.character.getTransform();
        int playerHeight = this.getEyesHeight();
        if (this.cam == null) {
            playerMat.m13 += playerHeight;
            g3d.setCamera(playerMat);
            playerMat.m13 -= playerHeight;
        } else {
            g3d.setCamera(this.cam.getCamera());
        }
    }

    public Camera getCamera() {
        return this.cam;
    }

    public int getRenderPart(Scene scene) {
        if (this.cam == null) {
            return this.getPart();
        }
        return this.cam.getPart();
    }

    public int getEyesHeight() {
        int height = 1503;
        if (this.isDead() && (height = (int)((float)height / Math.max(0.4f * (float)this.getFrame(), 1.0f))) < this.character.getRadius()) {
            height = this.character.getRadius();
        }
        return height;
    }

    public final boolean damage(GameObject obj, int dmg) {
        if (DeveloperMenu.debugMode && dmg > 0 && DeveloperMenu.godMode) {
            return true;
        }
        if (dmg > 0) {
            this.damage = true;
        }
        if (dmg < 0 && this.getHp() - dmg > 100) {
            return super.damage(obj, -(100 - this.getHp()));
        }
        return super.damage(obj, dmg);
    }

    public final boolean isDamaged() {
        boolean tmp = this.damage;
        this.damage = false;
        return tmp;
    }

    public final void pay(int price) {
        this.money -= price;
    }

    public final boolean isTimeToRenew() {
        return this.isDead() && System.currentTimeMillis() - this.DeathTime > 3000L;
    }

    public final void fire(DirectX7 g3d) {
        if (this.arsenal.current != -1 && this.canAttack() && this.arsenal.currentWeapon().fire(g3d)) {
            this.attackFrame = 0;
            TPPose tp = this.currentPose();
            if (tp != null) {
                this.muzzleFrame = tp.muzzleFlashTimer;
            }
        }
    }

    public final void jump() {
        if (!this.canJump()) {
            return;
        }
        if (!arcadeJumpPhysics) {
            this.jump(150, 1.2f);
        } else {
            this.character.jumpArcade(150, 1.2f);
        }
        if (this.character.onFloor && Main.isFootsteps && Main.footsteps != 0) {
            try {
                String snd = Main.jumpSound;
                if (sndJump != null) {
                    snd = sndJump;
                }
                if (snd != null && Asset.getSound(snd).getState() != 400) {
                    Asset.getSound(snd).setVolume(Main.footsteps);
                    Asset.getSound(snd).start();
                }
            }
            catch (Exception var2) {
                System.err.println("ERROR in Step sound: " + var2);
            }
        }
    }

    public void updateMatrix() {
        int x = this.character.transform.m03;
        int y = this.character.transform.m13;
        int z = this.character.transform.m23;
        if (this.rotateX < -80.0f) {
            this.rotateX = -80.0f;
        }
        if (this.rotateX > 80.0f) {
            this.rotateX = 80.0f;
        }
        while (this.rotateY > 360.0f) {
            this.rotateY -= 360.0f;
        }
        while (this.rotateY < 0.0f) {
            this.rotateY += 360.0f;
        }
        this.character.transform.setIdentity();
        this.character.transform.setRotX((int)this.rotateX);
        this.character.transform.setPosition(x, y, z);
        this.character.transform.rotY((int)this.rotateY);
    }

    public final void rotYn(float i) {
        if (!this.canLookY()) {
            return;
        }
        this.rotateY += i;
        this.updateMatrix();
    }

    public final void rotXn(float i) {
        if (!this.canLookX()) {
            return;
        }
        this.rotateX += i;
        this.updateMatrix();
    }

    public final void rotLeft() {
        if (!this.canLookY()) {
            return;
        }
        this.rotYn(7.0f * this.lookSpeed() * (float)Main.mouseSpeed / 50.0f * (float)QFPS.frameTime / 50.0f);
    }

    public final void rotRight() {
        if (!this.canLookY()) {
            return;
        }
        this.rotYn(-(7.0f * this.lookSpeed() * (float)Main.mouseSpeed / 50.0f) * (float)QFPS.frameTime / 50.0f);
    }

    public final void rotUp() {
        if (!this.canLookX()) {
            return;
        }
        this.rotXn(7.0f * this.lookSpeed() * (float)Main.mouseSpeed / 100.0f * (float)QFPS.frameTime / 50.0f);
    }

    public final void rotDown() {
        if (!this.canLookX()) {
            return;
        }
        this.rotXn(-(7.0f * this.lookSpeed() * (float)Main.mouseSpeed / 100.0f) * (float)QFPS.frameTime / 50.0f);
    }

    public void walk(int right, int forward) {
        if (!this.canWalk()) {
            return;
        }
        int walkSpeed = this.walkSpeed();
        if (this.character.fly) {
            walkSpeed = walkSpeed * 7 / 3;
        }
        if (this.cam != null && this.isRotToWalkDir()) {
            float modelRot = this.cam.currentRotY;
            if (forward < 0) {
                modelRot += 180.0f;
            }
            Vector3D dir = new Vector3D((int)(-Math.sin((double)(modelRot -= (float)(right * 90 / (forward != 0 ? (forward > 0 ? 2 : -2) : 1))) * Math.PI / 180.0) * (double)walkSpeed), 0, (int)(-Math.cos((double)modelRot * Math.PI / 180.0) * (double)walkSpeed));
            if (this.character.fly || this.character.onFloor) {
                this.rotateY = modelRot;
                this.updateMatrix();
                this.character.moveFree(dir);
            }
        } else {
            this.character.moveZ(-walkSpeed * forward);
            this.character.moveX(walkSpeed * right);
        }
        if ((forward != 0 || right != 0) && this.arsenal.currentWeapon() != null) {
            this.arsenal.currentWeapon().enableShake();
        }
    }

    public final Object getHUDInfo() {
        Weapon[] weapons = this.arsenal.getWeapons();
        int[] ammos = new int[weapons.length];
        for (int i = 0; i < weapons.length; ++i) {
            ammos[i] = weapons[i] != null ? weapons[i].getAmmo() + weapons[i].getRounds() : -1;
        }
        return new HUDInfo(this.money, ammos);
    }

    public void activate(House house, Player player, GameScreen gs) {
    }

    public void copyNewToUsed() {
        if (toAddOnStart.isEmpty()) {
            return;
        }
        while (!toAddOnStart.isEmpty()) {
            if (!RoomObject.containsSimple(usedPoints, (String)toAddOnStart.firstElement())) {
                usedPoints.addElement(toAddOnStart.firstElement());
            }
            toAddOnStart.removeElementAt(0);
        }
    }
}

