/*
 * Decompiled with CFR 0.152.
 */
package code.AI;

import code.AI.Bot;
import code.Gameplay.Map.House;
import code.Gameplay.Map.Portal;
import code.Gameplay.Map.Scene;
import code.Gameplay.Objects.GameObject;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.BoundingBox;
import code.Rendering.Meshes.MeshImage;
import code.Rendering.MultyTexture;
import code.utils.QFPS;
import java.util.Vector;

public final class BigZombie
extends Bot {
    public static byte fallDeath = 1;
    public static boolean bloodHas = true;
    public static int max_hp = 400;
    public static int model_height = 2000;
    private static BoundingBox boundingBox;
    public static int[] attackTo;
    public static int enemyReaction;
    public static int animSpeed;
    public static int walkSpeed;
    public static int moneyOnDeath;
    public static int attackState;
    public static float jumpSpeed;
    public static int attackTimer;
    public static int attackAnimSpeed;
    public static float jumpSpeed2;
    public static int reactTimer;
    public static int AI;
    public static MultyTexture texture;
    public static int jumpHeight2;
    public static int jumpHeight;
    public static int attackDamage;
    public static float attackRadius;
    public static MeshImage model;
    private int state = -1;
    public MeshImage meshImage;
    private GameObject enemy = null;
    private boolean notCol = false;
    private final Vector3D dir = new Vector3D();

    public BigZombie(Vector3D pos) {
        if (model != null) {
            this.meshImage = new MeshImage(model.getMesh(), model.getAnimation());
            boundingBox = new BoundingBox(model.getAnimation());
        }
        this.name = "BIG_ZOMBIE";
        this.getCharacter().getTransform().setIdentity();
        this.set(pos);
        this.fraction = 2;
        this.deathFall = fallDeath;
        this.hasBlood = bloodHas;
    }

    public final void set(Vector3D pos) {
        super.set(pos);
        this.setHp(max_hp);
        this.setCharacterSize(model_height);
        this.dir.set(pos.x, pos.y, pos.z + 50);
        this.lookAt(pos.x, pos.z + 50);
        this.notCol = false;
    }

    public final void destroy() {
        super.destroy();
        this.enemy = null;
        this.meshImage = null;
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        Matrix mat = this.getCharacter().getTransform();
        Matrix finalMatrix = g3d.computeFinalMatrix(mat);
        if (!boundingBox.isVisible(g3d, finalMatrix, x1, y1, x2, y2)) {
            return;
        }
        if (mat.m11 == 16384) {
            if (this.state == 1) {
                this.meshImage.setFrame(this.getFrameInter() * animSpeed / 100);
            }
            if (this.state == 2) {
                this.meshImage.setFrame(this.getFrameInter() * attackAnimSpeed / 100);
            }
        }
        this.meshImage.setMatrix(finalMatrix);
        this.meshImage.setTexture(texture);
        g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
        this.meshImage.sz += this.character.getRadius();
        if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.meshImage.sz) {
            this.character.oldFloorPoly.sz = this.meshImage.sz - 1;
        }
        this.renderBlood(g3d, 1500);
    }

    protected final void action(Scene scene) {
        if (Math.abs(this.getFrameInterDiv()) % reactTimer == 1) {
            House house = scene.getHouse();
            Vector objects = house.getObjects();
            if (this.enemy != null && this.enemy.isDead() || this.enemy != null && QFPS.frames == 0) {
                this.enemy = null;
            }
            this.enemy = this.findBot(objects, this, attackTo);
            if (this.enemy != null) {
                Vector3D walkTo = this.dir;
                if (this.notCollided(house, this.enemy) && scene.getHouse().isNear(this.getPart(), this.enemy.getPart())) {
                    Matrix mat = this.enemy.getCharacter().getTransform();
                    walkTo.set(mat.m03, mat.m13, mat.m23);
                    this.notCol = true;
                } else {
                    int nextPart = scene.getNext(this.getPart(), this.enemy.getPart());
                    Portal portal = BigZombie.commonPortal(house, this.getPart(), nextPart);
                    if (portal != null) {
                        BigZombie.computeCentre(portal, walkTo);
                    }
                    this.notCol = false;
                }
                if (this.dir.x != 0 && this.dir.z != 0) {
                    this.lookAt(this.dir.x, this.dir.z);
                }
                long distance = this.character.distance(this.enemy.getCharacter());
                if (this.notCol && (float)distance <= (float)BigZombie.sqr(this.character.getRadius() + this.enemy.getCharacter().getRadius()) * attackRadius) {
                    this.state = enemyReaction;
                } else {
                    if (this.character.isCollision() && !this.notCol) {
                        this.character.jump(jumpHeight, jumpSpeed);
                    }
                    if (distance > BigZombie.sqr(this.character.getRadius() * 11)) {
                        this.character.jump(jumpHeight2, jumpSpeed2);
                    }
                    this.state = AI;
                }
            } else {
                this.state = -1;
            }
        }
        if (this.state == 1) {
            this.character.moveZ(walkSpeed);
        }
        if (this.state == attackState && this.getFrameInterDiv() % attackTimer == 0 && this.notCol) {
            this.enemy.damage(this, attackDamage);
        }
    }

    static {
        enemyReaction = 2;
        animSpeed = 135;
        walkSpeed = 135;
        moneyOnDeath = 30;
        attackState = 2;
        jumpSpeed = 1.2f;
        attackTimer = 14;
        attackAnimSpeed = 270;
        jumpSpeed2 = 1.5f;
        reactTimer = 8;
        AI = 1;
        jumpHeight2 = 202;
        jumpHeight = 202;
        attackDamage = 7;
        attackRadius = 1.2f;
    }
}

