/*
 * Decompiled with CFR 0.152.
 */
package code.Collision;

import code.Collision.Ray;
import code.Math.MathUtils2;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.RenderObject;
import code.Rendering.Texture;
import code.Rendering.Vertex;

public final class RayCast {
    private static final Vector3D temp = new Vector3D();
    private static final Vector3D colPoint = new Vector3D();
    private static final Vector3D normal = new Vector3D();
    private static final Vector3D v1 = new Vector3D();
    private static final Vector3D v2 = new Vector3D();
    private static final Vector3D v3 = new Vector3D();
    private static final Vector3D v4 = new Vector3D();
    private static boolean roomNeed = false;
    private static int room = -1;

    public static void superFastRayCast(Mesh mesh, Ray ray) {
        RenderObject[] elements = mesh.getPolygons();
        Vector3D start = ray.start;
        Vector3D dir = ray.dir;
        int dirLen = dir.length();
        for (int i = 0; i < elements.length; ++i) {
            RenderObject poly = elements[i];
            long dis = Long.MAX_VALUE;
            int mat = -1;
            if (poly instanceof Polygon4V) {
                Polygon4V p = (Polygon4V)poly;
                RayCast.normal.x = p.nx;
                RayCast.normal.y = p.ny;
                RayCast.normal.z = p.nz;
                RayCast.v1.x = p.a.x;
                RayCast.v1.y = p.a.y;
                RayCast.v1.z = p.a.z;
                RayCast.v2.x = p.b.x;
                RayCast.v2.y = p.b.y;
                RayCast.v2.z = p.b.z;
                RayCast.v3.x = p.c.x;
                RayCast.v3.y = p.c.y;
                RayCast.v3.z = p.c.z;
                RayCast.v4.x = p.d.x;
                RayCast.v4.y = p.d.y;
                RayCast.v4.z = p.d.z;
                dis = RayCast.rayTracing(ray, v1, v2, v3, v4, normal, start, dir, colPoint, v1);
                mat = p.tex;
            } else if (poly instanceof Polygon3V) {
                Polygon3V p = (Polygon3V)poly;
                RayCast.normal.x = p.nx;
                RayCast.normal.y = p.ny;
                RayCast.normal.z = p.nz;
                RayCast.v1.x = p.a.x;
                RayCast.v1.y = p.a.y;
                RayCast.v1.z = p.a.z;
                RayCast.v2.x = p.b.x;
                RayCast.v2.y = p.b.y;
                RayCast.v2.z = p.b.z;
                RayCast.v3.x = p.c.x;
                RayCast.v3.y = p.c.y;
                RayCast.v3.z = p.c.z;
                dis = RayCast.rayTracing(ray, v1, v2, v3, normal, start, dir, colPoint, v1);
                mat = p.tex;
            }
            if (mat != -1) {
                Texture tex = mesh.getTexture().textures[mat];
                boolean castShadow = tex.castShadow;
                boolean collidable = tex.collision;
                if (ray.ignoreNonShadowed && !castShadow || ray.onlyCollidable && !collidable) continue;
            }
            if (dis == Long.MAX_VALUE || ray.origPol == poly || dis < 0L) continue;
            long distance = (long)dirLen * dis >> 12;
            if (distance > Integer.MAX_VALUE) {
                distance = Integer.MAX_VALUE;
            }
            if (distance >= (long)ray.distance) continue;
            ray.collision = true;
            ray.distance = (int)distance;
            ray.collisionPoint.set(colPoint);
            ray.triangle = poly;
            if (ray.findNearest) continue;
            return;
        }
    }

    public static void rayCast(Mesh mesh, Ray ray, boolean reCalcNorm) {
        RenderObject[] elements = mesh.getPolygons();
        Vector3D start = ray.start;
        Vector3D dir = ray.dir;
        int sx = start.x;
        int sy = start.y;
        int sz = start.z;
        int ex = sx + dir.x;
        int ey = sy + dir.y;
        int ez = sz + dir.z;
        int x1 = RayCast.min(sx, ex);
        int y1 = RayCast.min(sy, ey);
        int z1 = RayCast.min(sz, ez);
        int x2 = RayCast.max(sx, ex);
        int y2 = RayCast.max(sy, ey);
        int z2 = RayCast.max(sz, ez);
        int dirLen = dir.length();
        for (int i = 0; i < elements.length; ++i) {
            Vertex c;
            RenderObject poly = elements[i];
            long dis = Long.MAX_VALUE;
            int mat = -1;
            if (poly instanceof Polygon3V) {
                Polygon3V p = (Polygon3V)poly;
                Vertex a = p.a;
                Vertex b = p.b;
                c = p.c;
                if (!ray.infinity && (RayCast.max(a.x, b.x, c.x) < x1 || RayCast.min(a.x, b.x, c.x) > x2 || RayCast.max(a.z, b.z, c.z) < z1 || RayCast.min(a.z, b.z, c.z) > z2 || RayCast.max(a.y, b.y, c.y) < y1 || RayCast.min(a.y, b.y, c.y) > y2)) continue;
                if (!reCalcNorm) {
                    RayCast.normal.x = p.nx;
                    RayCast.normal.y = p.ny;
                    RayCast.normal.z = p.nz;
                } else {
                    long xx = (long)(a.y - b.y) * (long)(a.z - c.z) - (long)(a.z - b.z) * (long)(a.y - c.y);
                    long yy = (long)(a.z - b.z) * (long)(a.x - c.x) - (long)(a.x - b.x) * (long)(a.z - c.z);
                    long zz = (long)(a.x - b.x) * (long)(a.y - c.y) - (long)(a.y - b.y) * (long)(a.x - c.x);
                    double sqrt = Math.sqrt(xx * xx + yy * yy + zz * zz) / 4096.0;
                    RayCast.normal.x = (int)((double)xx / sqrt);
                    RayCast.normal.y = (int)((double)yy / sqrt);
                    RayCast.normal.z = (int)((double)zz / sqrt);
                }
                v1.set(a.x, a.y, a.z);
                v2.set(b.x, b.y, b.z);
                v3.set(c.x, c.y, c.z);
                dis = RayCast.rayTracing(ray, v1, v2, v3, normal, start, dir, colPoint, v1);
                mat = p.tex;
            } else if (poly instanceof Polygon4V) {
                Polygon4V p = (Polygon4V)poly;
                Vertex a = p.a;
                Vertex b = p.b;
                c = p.c;
                Vertex d = p.d;
                if (!ray.infinity && (RayCast.max(a.x, b.x, c.x, d.x) < x1 || RayCast.min(a.x, b.x, c.x, d.x) > x2 || RayCast.max(a.z, b.z, c.z, d.z) < z1 || RayCast.min(a.z, b.z, c.z, d.z) > z2 || RayCast.max(a.y, b.y, c.y, d.y) < y1 || RayCast.min(a.y, b.y, c.y, d.y) > y2)) continue;
                if (!reCalcNorm) {
                    RayCast.normal.x = p.nx;
                    RayCast.normal.y = p.ny;
                    RayCast.normal.z = p.nz;
                } else {
                    long xx = (long)(a.y - b.y) * (long)(a.z - d.z) - (long)(a.z - b.z) * (long)(a.y - d.y);
                    long yy = (long)(a.z - b.z) * (long)(a.x - d.x) - (long)(a.x - b.x) * (long)(a.z - d.z);
                    long zz = (long)(a.x - b.x) * (long)(a.y - d.y) - (long)(a.y - b.y) * (long)(a.x - d.x);
                    double sqrt = Math.sqrt(xx * xx + yy * yy + zz * zz) / 4096.0;
                    RayCast.normal.x = (int)((double)xx / sqrt);
                    RayCast.normal.y = (int)((double)yy / sqrt);
                    RayCast.normal.z = (int)((double)zz / sqrt);
                }
                v1.set(a.x, a.y, a.z);
                v2.set(b.x, b.y, b.z);
                v3.set(c.x, c.y, c.z);
                v4.set(d.x, d.y, d.z);
                dis = RayCast.rayTracing(ray, v1, v2, v3, v4, normal, start, dir, colPoint, v1);
                mat = p.tex;
            }
            if (mat != -1) {
                Texture tex = mesh.getTexture().textures[mat];
                boolean castShadow = tex.castShadow;
                boolean collidable = tex.collision;
                if (ray.ignoreNonShadowed && !castShadow || ray.onlyCollidable && !collidable) continue;
            }
            if (dis == Long.MAX_VALUE || ray.origPol == poly || dis < 0L) continue;
            long distance = (long)dirLen * dis >> 12;
            if (distance > Integer.MAX_VALUE) {
                distance = Integer.MAX_VALUE;
            }
            if (distance >= (long)ray.distance) continue;
            ray.collision = true;
            ray.distance = (int)distance;
            ray.collisionPoint.set(colPoint);
            ray.triangle = poly;
            if (ray.findNearest) continue;
            return;
        }
    }

    private static long rayTracing(Ray ray, Vector3D a, Vector3D b, Vector3D c, Vector3D nor, Vector3D start, Vector3D dir, Vector3D pos, Vector3D check) {
        pos.set(start.x - check.x, start.y - check.y, start.z - check.z);
        int dot = (int)(dir.dotLong(nor) >> 12);
        if (dot <= 0) {
            return Long.MAX_VALUE;
        }
        dot = (int)(-pos.dotLong(nor) / (long)dot);
        if (dot < -1 || dot > 4096 && !ray.infinity) {
            return Long.MAX_VALUE;
        }
        pos.set(start.x + (dir.x * dot >> 12), start.y + (dir.y * dot >> 12), start.z + (dir.z * dot >> 12));
        if (MathUtils2.isPointOnPolygon(pos, a, b, c, nor)) {
            return dot;
        }
        return Long.MAX_VALUE;
    }

    private static long rayTracing(Ray ray, Vector3D a, Vector3D b, Vector3D c, Vector3D d, Vector3D nor, Vector3D start, Vector3D dir, Vector3D pos, Vector3D check) {
        pos.set(start.x - check.x, start.y - check.y, start.z - check.z);
        int dot = (int)(dir.dotLong(nor) >> 12);
        if (dot <= 0) {
            return Long.MAX_VALUE;
        }
        dot = (int)(-pos.dotLong(nor) / (long)dot);
        if (dot < -1 || dot > 4096 && !ray.infinity) {
            return Long.MAX_VALUE;
        }
        pos.set(start.x + (dir.x * dot >> 12), start.y + (dir.y * dot >> 12), start.z + (dir.z * dot >> 12));
        if (MathUtils2.isPointOnPolygon(pos, a, b, c, d, nor)) {
            return dot;
        }
        return Long.MAX_VALUE;
    }

    public static long isRayOnPolygon(Vector3D a, Vector3D b, Vector3D c, Vector3D d, Vector3D nor, Vector3D start, Vector3D dir) {
        temp.set(start.x - a.x, start.y - a.y, start.z - a.z);
        int dot = (int)(dir.dotLong(nor) >> 12);
        if (dot <= 0) {
            return Long.MAX_VALUE;
        }
        dot = (int)(-temp.dotLong(nor) / (long)dot);
        if (dot < -1) {
            return Long.MAX_VALUE;
        }
        temp.set(start.x + (dir.x * dot >> 12), start.y + (dir.y * dot >> 12), start.z + (dir.z * dot >> 12));
        if (MathUtils2.isPointOnPolygon(temp, a, b, c, d, nor)) {
            return dot * dir.length() >> 12;
        }
        return Long.MAX_VALUE;
    }

    public static long isRayOnPolygon(Vector3D a, Vector3D b, Vector3D c, Vector3D nor, Vector3D start, Vector3D dir) {
        temp.set(start.x - a.x, start.y - a.y, start.z - a.z);
        int dot = (int)(dir.dotLong(nor) >> 12);
        if (dot <= 0) {
            return Long.MAX_VALUE;
        }
        dot = (int)(-temp.dotLong(nor) / (long)dot);
        if (dot < -1) {
            return Long.MAX_VALUE;
        }
        temp.set(start.x + (dir.x * dot >> 12), start.y + (dir.y * dot >> 12), start.z + (dir.z * dot >> 12));
        if (MathUtils2.isPointOnPolygon(temp, a, b, c, nor)) {
            return dot * dir.length() >> 12;
        }
        return Long.MAX_VALUE;
    }

    private static int max(int a, int b, int c, int d) {
        return RayCast.max(RayCast.max(a, b), RayCast.max(c, d));
    }

    private static int min(int a, int b, int c, int d) {
        return RayCast.min(RayCast.min(a, b), RayCast.min(c, d));
    }

    private static int max(int a, int b, int c) {
        return RayCast.max(a, RayCast.max(b, c));
    }

    private static int min(int a, int b, int c) {
        return RayCast.min(a, RayCast.min(b, c));
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static void rayCast(Mesh mesh, Ray ray, Matrix mat) {
        DirectX7.transformSave(mesh, mat);
        RayCast.rayCast(mesh, ray, true);
        DirectX7.transformReturn(mesh);
    }

    public static void rayCast(Mesh mesh, Ray ray, int rom) {
        roomNeed = true;
        room = rom;
        RayCast.rayCast(mesh, ray);
        roomNeed = false;
    }

    public static void rayCast(Mesh mesh, Ray ray) {
        RayCast.rayCast(mesh, ray, false);
    }
}

