/*
 * Decompiled with CFR 0.152.
 */
package ru.antares.GameUtils;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import ru.antares.GameUtils.GameMenu;
import ru.antares.utils.PointXY;
import ru.antares.utils.Rect;

public class MenuItem {
    protected int itemImageIndex = -1;
    protected Rect itemRect;
    protected String itemText;
    protected Font itemTextFont;
    protected int[] itemTextColorArr;
    protected int curItemTextColorIndex = -1;
    protected GameMenu menu;
    protected boolean showItemImage = true;
    protected boolean showItemText = true;
    protected int textAlign = 0;
    public int itemID = -1;

    public MenuItem() {
    }

    public MenuItem(GameMenu gameMenu, int n, Rect rect, String string, Font font, int[] nArray, int n2, boolean bl, boolean bl2) {
        this.createItem(gameMenu, n, rect, string, font, nArray, n2, bl, bl2);
    }

    public MenuItem(GameMenu gameMenu, int n, Rect rect, String string, Font font, int[] nArray, int n2, boolean bl, boolean bl2, int n3) {
        this.createItem(gameMenu, n, rect, string, font, nArray, n2, bl, bl2, n3);
    }

    public void createItem(GameMenu gameMenu, int n, Rect rect, String string, Font font, int[] nArray, int n2, boolean bl, boolean bl2, int n3) {
        this.createItem(gameMenu, n, rect, string, font, nArray, n2, bl, bl2);
        this.textAlign = n3;
    }

    public void createItem(GameMenu gameMenu, int n, Rect rect, String string, Font font, int[] nArray, int n2, boolean bl, boolean bl2) {
        PointXY pointXY;
        if (rect != null && rect.isEmpty() && (pointXY = gameMenu.getImageSize(n)) != null) {
            rect.width = pointXY.x;
            rect.height = pointXY.y;
        }
        this.menu = gameMenu;
        this.itemImageIndex = n;
        this.itemRect = rect;
        this.itemText = string;
        this.itemTextFont = font;
        this.itemTextColorArr = nArray;
        this.curItemTextColorIndex = n2;
        this.showItemImage = bl;
        this.showItemText = bl2;
        this.textAlign = 0;
    }

    public boolean eraseItem(Graphics graphics) {
        return this.menu.redrawBackImage(graphics, this.itemRect);
    }

    public boolean drawItem(Graphics graphics) {
        this.menu.redrawBackImage(graphics, this.itemRect);
        PointXY pointXY = this.menu.getImageSize(this.itemImageIndex);
        if (this.showItemImage && pointXY != null && !this.menu.drawImage(graphics, this.itemImageIndex, this.itemRect.x + this.itemRect.width / 2 - pointXY.x / 2, this.itemRect.y + this.itemRect.height / 2 - pointXY.y / 2, this.itemRect)) {
            return false;
        }
        if (this.showItemText && this.itemText != null) {
            if (this.itemTextFont != null) {
                graphics.setFont(this.itemTextFont);
            }
            PointXY pointXY2 = this.itemRect.getCenter();
            if (this.itemTextColorArr != null && this.curItemTextColorIndex >= 0 && this.curItemTextColorIndex < this.itemTextColorArr.length) {
                graphics.setColor(this.itemTextColorArr[this.curItemTextColorIndex]);
            }
            if (this.textAlign == 0) {
                graphics.drawString(this.itemText, pointXY2.x, pointXY2.y - graphics.getFont().getHeight() / 2, 0x10 | 1);
            } else if (this.textAlign < 0) {
                graphics.drawString(this.itemText, this.itemRect.x, pointXY2.y - graphics.getFont().getHeight() / 2, 0x10 | 4);
            } else {
                graphics.drawString(this.itemText, this.itemRect.x + this.itemRect.width, pointXY2.y - graphics.getFont().getHeight() / 2, 0x10 | 8);
            }
        }
        return true;
    }

    public void onKeyUp() {
    }

    public void onKeyDown() {
    }

    public void onKeyLeft() {
    }

    public void onKeyRight() {
    }

    public void onKeyFire() {
    }

    public void onLossFocus() {
    }

    public void onSetFocus() {
    }

    public void setTextAlign(int n) {
        this.textAlign = n;
    }

    public void setItemText(String string) {
        this.itemText = string;
    }

    public void setItemParam(boolean bl, boolean bl2, int n) {
        this.showItemImage = bl;
        this.showItemText = bl2;
        this.curItemTextColorIndex = n;
    }
}

