/*
 * Decompiled with CFR 0.152.
 */
package ru.antares.utils;

public final class MathEx {
    private MathEx() {
    }

    public static long sqrt_fast(long l) {
        long l2 = l;
        if (l <= 0L) {
            return 0L;
        }
        long l3 = (l & 0xFFFF0000L) != 0L ? ((l & 0xFF000000L) != 0L ? 16383L : 1023L) : ((l & 0xFF00L) != 0L ? 63L : (l > 4L ? 7L : l));
        while (l > 0L) {
            long l4 = l / l3 + l3;
            l3 = l4 >> 1;
            if (l2 > (l3 += l4 & 1L)) {
                l2 = l3;
                continue;
            }
            if (l / l2 == l2 - 1L && l % l2 == 0L) {
                --l2;
            }
            return l2;
        }
        return 0L;
    }

    public static long sqrt_slow(long l) {
        long l2 = 1L;
        long l3 = 0L;
        while (l > 0L) {
            l3 += (l -= (l2 += 2L)) < 0L ? 0L : 1L;
        }
        return l3;
    }

    public static long sqrt_near(long l) {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = l;
        long l3 = l;
        while (true) {
            long l4 = l / l2 + l2;
            l2 = l4 >> 1;
            if (l3 <= (l2 += l4 & 1L)) break;
            l3 = l2;
        }
        return l3;
    }
}

