/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.geodetic.utils.conversion;

import com.henson.midp.Float11;
import es.prodevelop.geodetic.utils.conversion.Elipsoide;
import es.prodevelop.geodetic.utils.conversion.GeoUtils;
import es.prodevelop.gvsig.mobile.fmap.proj.Projection;
import es.prodevelop.gvsig.phone.geom.Point;
import es.prodevelop.gvsig.phone.projection.TileConversor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ConversionCoords {
    private ConversionCoords() {
    }

    public static double[] a(double d2, double d3, Elipsoide elipsoide, int n2) {
        double d4 = elipsoide.d;
        double d5 = elipsoide.e;
        if (d2 > 180.0) {
            d2 = 180.0;
        }
        if (d2 < -180.0) {
            d2 = -180.0;
        }
        if (d3 > 90.0) {
            d3 = 90.0;
        }
        if (d3 < -90.0) {
            d3 = -90.0;
        }
        double d6 = d2 * (Math.PI / 180);
        double d7 = d3 * (Math.PI / 180);
        String string = Integer.toString(n2);
        double d8 = Double.parseDouble(string);
        double d9 = d8 * 6.0 - 183.0;
        double d10 = d6 - d9 * (Math.PI / 180);
        double d11 = Math.cos(d7) * Math.sin(d10);
        double d12 = 0.5 * Float11.c((1.0 + d11) / (1.0 - d11));
        double d13 = Float11.a(Math.tan(d7) / Math.cos(d10)) - d7;
        double d14 = d5 * 0.9996 / Math.sqrt(1.0 + d4 * Float11.b(Math.cos(d7), 2.0));
        double d15 = d4 * Float11.b(d12, 2.0) * Float11.b(Math.cos(d7), 2.0) / 2.0;
        double d16 = Math.sin(2.0 * d7);
        double d17 = d16 * Float11.b(Math.cos(d7), 2.0);
        double d18 = d7 + d16 / 2.0;
        double d19 = (3.0 * d18 + d17) / 4.0;
        double d20 = (5.0 * d19 + d17 * Float11.b(Math.cos(d7), 2.0)) / 3.0;
        double d21 = 0.75 * d4;
        double d22 = 1.6666666666666667 * Float11.b(d21, 2.0);
        double d23 = 1.2962962962962963 * Float11.b(d21, 3.0);
        double d24 = 0.9996 * d5 * (d7 - d21 * d18 + d22 * d19 - d23 * d20);
        double d25 = d12 * d14 * (1.0 + d15 / 3.0) + 500000.0;
        double d26 = d13 * d14 * (1.0 + d15) + d24;
        if (d3 < 0.0) {
            d26 += 1.0E7;
        }
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d25;
        dArray2[1] = d26;
        return dArray2;
    }

    public static double[] a(double d2, double d3, double d4, Elipsoide elipsoide, int n2) {
        double d5 = elipsoide.d;
        double d6 = elipsoide.e;
        d2 -= 500000.0;
        if (n2 == -1) {
            d3 -= 1.0E7;
        }
        double d7 = d4 * 6.0 - 183.0;
        double d8 = d3 / 6363651.2449104;
        double d9 = d6 * 0.9996 / Math.sqrt(1.0 + d5 * Float11.b(Math.cos(d8), 2.0));
        double d10 = d2 / d9;
        double d11 = Math.sin(2.0 * d8);
        double d12 = d11 * Float11.b(Math.cos(d8), 2.0);
        double d13 = d8 + d11 / 2.0;
        double d14 = (3.0 * d13 + d12) / 4.0;
        double d15 = (5.0 * d14 + d12 * Float11.b(Math.cos(d8), 2.0)) / 3.0;
        double d16 = 0.75 * d5;
        double d17 = 1.6666666666666667 * Float11.b(d16, 2.0);
        double d18 = 1.2962962962962963 * Float11.b(d16, 3.0);
        double d19 = 0.9996 * d6 * (d8 - d16 * d13 + d17 * d14 - d18 * d15);
        double d20 = (d3 - d19) / d9;
        double d21 = d5 * Float11.b(d10, 2.0) * Float11.b(Math.cos(d8), 2.0) / 2.0;
        double d22 = d10 * (1.0 - d21 / 3.0);
        double d23 = d20 * (1.0 - d21) + d8;
        double d24 = (Float11.b(Math.E, d22) - Float11.b(Math.E, -d22)) / 2.0;
        double d25 = Float11.a(d24 / Math.cos(d23));
        double d26 = Float11.a(Math.cos(d25) * Math.tan(d23));
        double d27 = d25 * 57.29577951308232;
        double d28 = d27 + d7;
        double d29 = d8 + (1.0 + d5 * Float11.b(Math.cos(d8), 2.0) - 1.5 * d5 * Math.sin(d8) * Math.cos(d8) * (d26 - d8)) * (d26 - d8);
        double d30 = d29 * 57.29577951308232;
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d28;
        dArray2[1] = d30;
        return dArray2;
    }

    private static double[] a(double d2, double d3, double d4, Elipsoide elipsoide) {
        double[] dArray = elipsoide.a(d3);
        double d5 = dArray[1];
        double d6 = d2 * (Math.PI / 180);
        double d7 = d3 * (Math.PI / 180);
        double d8 = (d5 + d4) * Math.cos(d7) * Math.cos(d6);
        double d9 = (d5 + d4) * Math.cos(d7) * Math.sin(d6);
        double d10 = Float11.b(elipsoide.a, 2.0);
        double d11 = Float11.b(elipsoide.b, 2.0);
        double d12 = (d11 / d10 * d5 + d4) * Math.sin(d7);
        double[] dArray2 = new double[]{d8, d9, d12};
        return dArray2;
    }

    private static double[] b(double d2, double d3, double d4, Elipsoide elipsoide) {
        double d5 = Math.sqrt(Float11.b(d2, 2.0) + Float11.b(d3, 2.0));
        double d6 = elipsoide.a;
        double d7 = elipsoide.b;
        double d8 = elipsoide.c;
        double d9 = elipsoide.d;
        double d10 = Float11.a(d4 * d6 / (d5 * d7));
        double d11 = d4 + d9 * d7 * Float11.b(Math.sin(d10), 3.0);
        double d12 = d5 - d8 * d6 * Float11.b(Math.cos(d10), 3.0);
        double d13 = Float11.a(d11 / d12);
        double d14 = d13 * 57.29577951308232;
        double d15 = 0.0;
        if (d2 > 0.0) {
            d15 = Float11.a(d3 / d2);
        }
        if (d2 < 0.0 & d3 > 0.0) {
            d15 = Math.PI + Float11.a(d3 / d2);
        }
        if (d2 < 0.0 & d3 < 0.0) {
            d15 = -(Math.PI - Float11.a(d3 / d2));
        }
        if (d2 == 0.0 & d3 > 0.0) {
            d15 = 1.5707963267948966;
        }
        if (d2 == 0.0 & d3 < 0.0) {
            d15 = -1.5707963267948966;
        }
        if (d2 == 0.0 & d3 == 0.0) {
            d15 = 0.0;
        }
        double d16 = d15 * 57.29577951308232;
        double[] dArray = elipsoide.a(d14);
        double d17 = dArray[1];
        double d18 = d5 / (Math.cos(d14) - d17);
        double[] dArray2 = new double[]{d16, d14, d18};
        return dArray2;
    }

    public static double[] a(double d2, double d3) {
        Elipsoide elipsoide = Elipsoide.a();
        Elipsoide elipsoide2 = Elipsoide.b();
        double[] dArray = ConversionCoords.a(d2, d3, 0.0, elipsoide);
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        double d7 = 9.39E-6 * d4;
        double d8 = 9.39E-6 * d5;
        double d9 = 9.39E-6 * d6;
        double d10 = 5.544329257168654E-6 * d5 + -9.453866781635952E-8 * d6;
        double d11 = -5.544329257168654E-6 * d4 + 6.030112565640408E-6 * d6;
        double d12 = 9.453866781635952E-8 * d4 + -6.030112565640408E-6 * d5;
        double d13 = d4 + (-131.032 + d7 + d10);
        double d14 = d5 + (-100.251 + d8 + d11);
        double d15 = d6 + (-163.354 + d9 + d12);
        double[] dArray2 = ConversionCoords.b(d13, d14, d15, elipsoide2);
        return dArray2;
    }

    public static double[] b(double d2, double d3) {
        Elipsoide elipsoide = Elipsoide.a();
        Elipsoide elipsoide2 = Elipsoide.b();
        double[] dArray = ConversionCoords.a(d2, d3, 0.0, elipsoide2);
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        double d7 = -9.39E-6 * d4;
        double d8 = -9.39E-6 * d5;
        double d9 = -9.39E-6 * d6;
        double d10 = -5.544329257168654E-6 * d5 + 9.453866781635952E-8 * d6;
        double d11 = 5.544329257168654E-6 * d4 + -6.030112565640408E-6 * d6;
        double d12 = -9.453866781635952E-8 * d4 + 6.030112565640408E-6 * d5;
        double d13 = d4 + (131.032 + d7 + d10);
        double d14 = d5 + (100.251 + d8 + d11);
        double d15 = d6 + (163.354 + d9 + d12);
        double[] dArray2 = ConversionCoords.b(d13, d14, d15, elipsoide);
        return dArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] a(double d2, double d3, Projection projection) {
        double[] dArray = new double[2];
        if (GeoUtils.a(projection)) {
            int n2 = GeoUtils.a(projection);
            if (n2 == -1) return null;
            double[] dArray2 = ConversionCoords.b(d2, d3);
            return ConversionCoords.a(dArray2[0], dArray2[1], Elipsoide.a(), n2);
        }
        if (GeoUtils.b(projection)) {
            int n3 = GeoUtils.a(projection);
            if (n3 == -1) return null;
            return ConversionCoords.a(d2, d3, Elipsoide.b(), n3);
        }
        if (projection.a.toUpperCase().compareTo("EPSG:4230") == 0) {
            double[] dArray3 = ConversionCoords.b(d2, d3);
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
            return dArray;
        } else if (projection.a.toUpperCase().compareTo("EPSG:4326") == 0) {
            dArray[0] = d2;
            dArray[1] = d3;
            return dArray;
        } else {
            if (projection.a.toUpperCase().compareTo("EPSG:3785") == 0 || projection.a.toUpperCase().compareTo("EPSG:900913") == 0 || projection.a.toUpperCase().compareTo("OSGEO:41001") == 0) {
                Point point = TileConversor.a(d2, d3);
                return new double[]{point.b, point.c};
            }
            if (projection.a.toUpperCase().compareTo("EPSG:27700") == 0) {
                return ConversionCoords.c(d2, d3);
            }
            if (projection.a.toUpperCase().compareTo("EPSG:27561") == 0) {
                double[] dArray4 = ConversionCoords.e(d2, d3);
                dArray[0] = dArray4[0];
                dArray[1] = dArray4[1];
                return dArray;
            } else if (projection.a.toUpperCase().compareTo("EPSG:27572") == 0) {
                double[] dArray5 = ConversionCoords.g(d2, d3);
                dArray[0] = dArray5[0];
                dArray[1] = dArray5[1];
                return dArray;
            } else if (projection.a.toUpperCase().compareTo("EPSG:27562") == 0) {
                double[] dArray6 = ConversionCoords.f(d2, d3);
                dArray[0] = dArray6[0];
                dArray[1] = dArray6[1];
                return dArray;
            } else if (projection.a.toUpperCase().compareTo("EPSG:27563") == 0) {
                double[] dArray7 = ConversionCoords.h(d2, d3);
                dArray[0] = dArray7[0];
                dArray[1] = dArray7[1];
                return dArray;
            } else {
                if (projection.a.toUpperCase().compareTo("EPSG:27564") != 0) return null;
                double[] dArray8 = ConversionCoords.i(d2, d3);
                dArray[0] = dArray8[0];
                dArray[1] = dArray8[1];
            }
        }
        return dArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] b(double d2, double d3, Projection projection) {
        double[] dArray = new double[2];
        if (GeoUtils.a(projection.a)) {
            return new double[]{d2, d3};
        }
        if (GeoUtils.a(projection)) {
            int n2 = GeoUtils.a(projection);
            if (n2 == -1) return null;
            double[] dArray2 = ConversionCoords.a(d2, d3, (double)n2, Elipsoide.a(), 1);
            return ConversionCoords.a(dArray2[0], dArray2[1]);
        }
        if (GeoUtils.b(projection)) {
            int n3 = GeoUtils.a(projection);
            if (n3 == -1) return null;
            int n4 = 1;
            if (projection.a.indexOf("EPSG:327") != 0) return ConversionCoords.a(d2, d3, (double)n3, Elipsoide.b(), n4);
            n4 = -1;
            return ConversionCoords.a(d2, d3, (double)n3, Elipsoide.b(), n4);
        }
        if (projection.a.toUpperCase().compareTo("EPSG:3785") != 0 && projection.a.toUpperCase().compareTo("EPSG:900913") != 0) {
            if (projection.a.toUpperCase().compareTo("OSGEO:41001") != 0) return dArray;
        }
        Point point = TileConversor.b(d2, d3);
        return new double[]{point.b, point.c};
    }

    public static double[] c(double d2, double d3) {
        double[] dArray = ConversionCoords.d(d2, d3);
        double[] dArray2 = new double[2];
        double[] dArray3 = dArray2;
        dArray2[0] = ConversionCoords.a(dArray[1], dArray[0], 6377563.396, 6356256.91, 400000.0, 0.999601272, -2.0);
        dArray3[1] = ConversionCoords.a(dArray[1], dArray[0], 6377563.396, 6356256.91, 400000.0, -100000.0, 0.999601272, 49.0, -2.0);
        return dArray3;
    }

    private static double[] d(double d2, double d3) {
        double d4 = ConversionCoords.a(d3, d2, 0.0, 6378137.0, 6356752.313);
        double d5 = ConversionCoords.b(d3, d2, 0.0, 6378137.0, 6356752.313);
        double d6 = ConversionCoords.b(d3, 0.0, 6378137.0, 6356752.313);
        double d7 = ConversionCoords.b(d4, d5, d6, -446.448, -0.247, -0.8421, 20.4894);
        double d8 = ConversionCoords.c(d4, d5, d6, 125.157, -0.1502, -0.8421, 20.4894);
        double d9 = ConversionCoords.d(d4, d5, d6, -542.06, -0.1502, -0.247, 20.4894);
        double d10 = ConversionCoords.c(d7, d8, d9, 6377563.396, 6356256.91);
        double d11 = ConversionCoords.a(d7, d8);
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d11;
        dArray2[1] = d10;
        return dArray2;
    }

    private static double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2 * (Math.PI / 180);
        double d12 = d3 * (Math.PI / 180);
        double d13 = d9 * (Math.PI / 180);
        double d14 = d10 * (Math.PI / 180);
        double d15 = d4 * d8;
        double d16 = d5 * d8;
        double d17 = (Float11.b(d15, 2.0) - Float11.b(d16, 2.0)) / Float11.b(d15, 2.0);
        double d18 = (d15 - d16) / (d15 + d16);
        double d19 = d15 / Math.sqrt(1.0 - d17 * Float11.b(Math.sin(d11), 2.0));
        double d20 = d19 * (1.0 - d17) / (1.0 - d17 * Float11.b(Math.sin(d11), 2.0));
        double d21 = d19 / d20 - 1.0;
        double d22 = d12 - d14;
        double d23 = ConversionCoords.a(d16, d18, d13, d11);
        double d24 = d23 + d7;
        double d25 = d19 / 2.0 * Math.sin(d11) * Math.cos(d11);
        double d26 = d19 / 24.0 * Math.sin(d11) * Float11.b(Math.cos(d11), 3.0) * (5.0 - Float11.b(Math.tan(d11), 2.0) + 9.0 * d21);
        double d27 = d19 / 720.0 * Math.sin(d11) * Float11.b(Math.cos(d11), 5.0) * (61.0 - 58.0 * Float11.b(Math.tan(d11), 2.0) + Float11.b(Math.tan(d11), 4.0));
        return d24 + Float11.b(d22, 2.0) * d25 + Float11.b(d22, 4.0) * d26 + Float11.b(d22, 6.0) * d27;
    }

    private static double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d2 * (Math.PI / 180);
        double d10 = d3 * (Math.PI / 180);
        double d11 = d8 * (Math.PI / 180);
        double d12 = d4 * d7;
        double d13 = d5 * d7;
        double d14 = (Float11.b(d12, 2.0) - Float11.b(d13, 2.0)) / Float11.b(d12, 2.0);
        double d15 = d12 / Math.sqrt(1.0 - d14 * Float11.b(Math.sin(d9), 2.0));
        double d16 = d15 * (1.0 - d14) / (1.0 - d14 * Float11.b(Math.sin(d9), 2.0));
        double d17 = d15 / d16 - 1.0;
        double d18 = d10 - d11;
        double d19 = d15 * Math.cos(d9);
        double d20 = d15 / 6.0 * Float11.b(Math.cos(d9), 3.0) * (d15 / d16 - Float11.b(Math.tan(d9), 2.0));
        double d21 = d15 / 120.0 * Float11.b(Math.cos(d9), 5.0) * (5.0 - 18.0 * Float11.b(Math.tan(d9), 2.0) + Float11.b(Math.tan(d9), 4.0) + 14.0 * d17 - 58.0 * Float11.b(Math.tan(d9), 2.0) * d17);
        return d6 + d18 * d19 + Float11.b(d18, 3.0) * d20 + Float11.b(d18, 5.0) * d21;
    }

    private static double a(double d2, double d3, double d4, double d5) {
        return d2 * ((1.0 + d3 + 1.0 * Float11.b(d3, 2.0) + 1.0 * Float11.b(d3, 3.0)) * (d5 - d4) - (3.0 * d3 + 3.0 * Float11.b(d3, 2.0) + 2.0 * Float11.b(d3, 3.0)) * Math.sin(d5 - d4) * Math.cos(d5 + d4) + (1.0 * Float11.b(d3, 2.0) + 1.0 * Float11.b(d3, 3.0)) * Math.sin(2.0 * (d5 - d4)) * Math.cos(2.0 * (d5 + d4)) - 1.0 * Float11.b(d3, 3.0) * Math.sin(3.0 * (d5 - d4)) * Math.cos(3.0 * (d5 + d4)));
    }

    private static double a(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 * (Math.PI / 180);
        double d8 = d3 * (Math.PI / 180);
        double d9 = (Float11.b(d5, 2.0) - Float11.b(d6, 2.0)) / Float11.b(d5, 2.0);
        double d10 = d5 / Math.sqrt(1.0 - d9 * Float11.b(Math.sin(d7), 2.0));
        return (d10 + d4) * Math.cos(d7) * Math.cos(d8);
    }

    private static double b(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 * (Math.PI / 180);
        double d8 = d3 * (Math.PI / 180);
        double d9 = (Float11.b(d5, 2.0) - Float11.b(d6, 2.0)) / Float11.b(d5, 2.0);
        double d10 = d5 / Math.sqrt(1.0 - d9 * Float11.b(Math.sin(d7), 2.0));
        return (d10 + d4) * Math.cos(d7) * Math.sin(d8);
    }

    private static double b(double d2, double d3, double d4, double d5) {
        double d6 = d2 * (Math.PI / 180);
        double d7 = (Float11.b(d4, 2.0) - Float11.b(d5, 2.0)) / Float11.b(d4, 2.0);
        double d8 = d4 / Math.sqrt(1.0 - d7 * Float11.b(Math.sin(d6), 2.0));
        return (d8 * (1.0 - d7) + d3) * Math.sin(d6);
    }

    private static double b(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d8 * 1.0E-6;
        double d10 = d6 / 3600.0 * (Math.PI / 180);
        double d11 = d7 / 3600.0 * (Math.PI / 180);
        return d2 + d2 * d9 - d3 * d11 + d4 * d10 + d5;
    }

    private static double c(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d8 * 1.0E-6;
        double d10 = d6 / 3600.0 * (Math.PI / 180);
        double d11 = d7 / 3600.0 * (Math.PI / 180);
        return d2 * d11 + d3 + d3 * d9 - d4 * d10 + d5;
    }

    private static double d(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d8 * 1.0E-6;
        double d10 = d6 / 3600.0 * (Math.PI / 180);
        double d11 = d7 / 3600.0 * (Math.PI / 180);
        return -1.0 * d2 * d11 + d3 * d10 + d4 + d4 * d9 + d5;
    }

    private static double c(double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(Float11.b(d2, 2.0) + Float11.b(d3, 2.0));
        double d8 = (Float11.b(d5, 2.0) - Float11.b(d6, 2.0)) / Float11.b(d5, 2.0);
        double d9 = Float11.a(d4, d7 * (1.0 - d8));
        double d10 = ConversionCoords.d(d5, d8, d9, d4, d7);
        return d10 * 57.29577951308232;
    }

    private static double d(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        while (Math.abs(d4 - (d8 = Float11.a(d5 + d3 * (d7 = d2 / Math.sqrt(1.0 - d3 * Float11.b(Math.sin(d4), 2.0))) * Math.sin(d4), d6))) > 1.0E-12) {
            d4 = d8;
        }
        return d8;
    }

    private static double a(double d2, double d3) {
        return Float11.a(d3, d2) * 57.29577951308232;
    }

    private static double[] e(double d2, double d3) {
        double d4 = d2 * (Math.PI / 180);
        double d5 = d3 * (Math.PI / 180);
        double d6 = 6378137.0 / Math.sqrt(1.0 - 0.006694380066764658 * Float11.b(Math.sin(d5), 2.0));
        double d7 = d6 * Math.cos(d5) * Math.cos(d4);
        double d8 = d6 * Math.cos(d5) * Math.sin(d4);
        double d9 = d6 * 0.9933056199332353 * Math.sin(d5);
        double d10 = d7 + 168.0;
        double d11 = d8 + 60.0;
        double d12 = d9 + -320.0;
        double d13 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) * (1.0 - 43394.339637222176 / Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12)));
        double d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        while (!(Math.abs(d14 - d13) < 1.0E-10)) {
            d13 = d14;
            d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        }
        double d15 = d14;
        double d16 = Float11.a(d11 / d10);
        double d17 = Math.sqrt(0.0068034876462998925);
        double d18 = Float11.c(Math.tan(0.7853981633974483 + d15 / 2.0) * Float11.b((1.0 - d17 * Math.sin(d15)) / (1.0 + d17 * Math.sin(d15)), d17 / 2.0));
        double d19 = 600000.0 + 1.160379698E7 * Float11.b(-0.7604059656 * d18) * Math.sin(0.7604059656 * (d16 - 0.04079234433198));
        double d20 = 5657616.674 - 1.160379698E7 * Float11.b(-0.7604059656 * d18) * Math.cos(0.7604059656 * (d16 - 0.04079234433198));
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d19;
        dArray2[1] = d20;
        return dArray2;
    }

    private static double[] f(double d2, double d3) {
        double d4 = d2 * (Math.PI / 180);
        double d5 = d3 * (Math.PI / 180);
        double d6 = 6378137.0 / Math.sqrt(1.0 - 0.006694380066764658 * Float11.b(Math.sin(d5), 2.0));
        double d7 = d6 * Math.cos(d5) * Math.cos(d4);
        double d8 = d6 * Math.cos(d5) * Math.sin(d4);
        double d9 = d6 * 0.9933056199332353 * Math.sin(d5);
        double d10 = d7 + 168.0;
        double d11 = d8 + 60.0;
        double d12 = d9 + -320.0;
        double d13 = Float11.b(10.0, -10.0);
        double d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) * (1.0 - 43394.339637222176 / Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12)));
        double d15 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d14) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d14), 2.0)))));
        while (!(Math.abs(d15 - d14) < d13)) {
            d14 = d15;
            d15 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d14) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d14), 2.0)))));
        }
        double d16 = d15;
        double d17 = Float11.a(d11 / d10);
        double d18 = Math.sqrt(0.0068034876462998925);
        double d19 = Float11.c(Math.tan(0.7853981633974483 + d16 / 2.0) * Float11.b((1.0 - d18 * Math.sin(d16)) / (1.0 + d18 * Math.sin(d16)), d18 / 2.0));
        double d20 = 600000.0 + 1.174579339E7 * Float11.b(-0.7289686274 * d19) * Math.sin(0.7289686274 * (d17 - 0.04079234433198));
        double d21 = 6199965.768 - 1.174579339E7 * Float11.b(-0.7289686274 * d19) * Math.cos(0.7289686274 * (d17 - 0.04079234433198));
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d20;
        dArray2[1] = d21;
        return dArray2;
    }

    private static double[] g(double d2, double d3) {
        double d4 = d2 * (Math.PI / 180);
        double d5 = d3 * (Math.PI / 180);
        double d6 = 6378137.0 / Math.sqrt(1.0 - 0.006694380066764658 * Float11.b(Math.sin(d5), 2.0));
        double d7 = d6 * Math.cos(d5) * Math.cos(d4);
        double d8 = d6 * Math.cos(d5) * Math.sin(d4);
        double d9 = d6 * 0.9933056199332353 * Math.sin(d5);
        double d10 = d7 + 168.0;
        double d11 = d8 + 60.0;
        double d12 = d9 + -320.0;
        double d13 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) * (1.0 - 43394.339637222176 / Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12)));
        double d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        while (!(Math.abs(d14 - d13) < 1.0E-10)) {
            d13 = d14;
            d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        }
        double d15 = d14;
        double d16 = Float11.a(d11 / d10);
        double d17 = Math.sqrt(0.0068034876462998925);
        double d18 = Float11.c(Math.tan(0.7853981633974483 + d15 / 2.0) * Float11.b((1.0 - d17 * Math.sin(d15)) / (1.0 + d17 * Math.sin(d15)), d17 / 2.0));
        double d19 = 600000.0 + 1.174579339E7 * Float11.b(-0.7289686274 * d18) * Math.sin(0.7289686274 * (d16 - 0.04079234433198));
        double d20 = 8199695.768 - 1.174579339E7 * Float11.b(-0.7289686274 * d18) * Math.cos(0.7289686274 * (d16 - 0.04079234433198));
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d19;
        dArray2[1] = d20;
        return dArray2;
    }

    private static double[] h(double d2, double d3) {
        double d4 = d2 * (Math.PI / 180);
        double d5 = d3 * (Math.PI / 180);
        double d6 = 6378137.0 / Math.sqrt(1.0 - 0.006694380066764658 * Float11.b(Math.sin(d5), 2.0));
        double d7 = d6 * Math.cos(d5) * Math.cos(d4);
        double d8 = d6 * Math.cos(d5) * Math.sin(d4);
        double d9 = d6 * 0.9933056199332353 * Math.sin(d5);
        double d10 = d7 + 168.0;
        double d11 = d8 + 60.0;
        double d12 = d9 + -320.0;
        double d13 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) * (1.0 - 43394.339637222176 / Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12)));
        double d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        while (!(Math.abs(d14 - d13) < 1.0E-10)) {
            d13 = d14;
            d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        }
        double d15 = d14;
        double d16 = Float11.a(d11 / d10);
        double d17 = Math.sqrt(0.0068034876462998925);
        double d18 = Float11.c(Math.tan(0.7853981633974483 + d15 / 2.0) * Float11.b((1.0 - d17 * Math.sin(d15)) / (1.0 + d17 * Math.sin(d15)), d17 / 2.0));
        double d19 = 600000.0 + 1.194799252E7 * Float11.b(-0.6959127966 * d18) * Math.sin(0.6959127966 * (d16 - 0.04079234433198));
        double d20 = 6791905.085 - 1.194799252E7 * Float11.b(-0.6959127966 * d18) * Math.cos(0.6959127966 * (d16 - 0.04079234433198));
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d19;
        dArray2[1] = d20;
        return dArray2;
    }

    private static double[] i(double d2, double d3) {
        double d4 = d2 * (Math.PI / 180);
        double d5 = d3 * (Math.PI / 180);
        double d6 = 6378137.0 / Math.sqrt(1.0 - 0.006694380066764658 * Float11.b(Math.sin(d5), 2.0));
        double d7 = d6 * Math.cos(d5) * Math.cos(d4);
        double d8 = d6 * Math.cos(d5) * Math.sin(d4);
        double d9 = d6 * 0.9933056199332353 * Math.sin(d5);
        double d10 = d7 + 168.0;
        double d11 = d8 + 60.0;
        double d12 = d9 + -320.0;
        double d13 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) * (1.0 - 43394.339637222176 / Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12)));
        double d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        while (!(Math.abs(d14 - d13) < 1.0E-10)) {
            d13 = d14;
            d14 = Float11.a(d12 / Math.sqrt(d10 * d10 + d11 * d11) / (1.0 - 43394.339637222176 * Math.cos(d13) / Math.sqrt((d10 * d10 + d11 * d11) * (1.0 - 0.0068034876462998925 * Float11.b(Math.sin(d13), 2.0)))));
        }
        double d15 = d14;
        double d16 = Float11.a(d11 / d10);
        double d17 = Math.sqrt(0.0068034876462998925);
        double d18 = Float11.c(Math.tan(0.7853981633974483 + d15 / 2.0) * Float11.b((1.0 - d17 * Math.sin(d15)) / (1.0 + d17 * Math.sin(d15)), d17 / 2.0));
        double d19 = 234.358 + 1.213628199E7 * Float11.b(-0.6712679322 * d18) * Math.sin(0.6712679322 * (d16 - 0.04079234433198));
        double d20 = 7239161.542 - 1.213628199E7 * Float11.b(-0.6712679322 * d18) * Math.cos(0.6712679322 * (d16 - 0.04079234433198));
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d19;
        dArray2[1] = d20;
        return dArray2;
    }

    public static double[] a(double d2, double d3, Projection projection, Projection projection2) {
        double[] dArray = new double[2];
        try {
            if (projection == null && projection2 == null) {
                return null;
            }
            if (GeoUtils.a(projection.a, projection2.a)) {
                dArray[0] = d2;
                dArray[1] = d3;
                return dArray;
            }
            if (GeoUtils.a(projection.a)) {
                dArray = ConversionCoords.a(d2, d3, projection2);
            } else if (GeoUtils.b(projection.a)) {
                if (GeoUtils.a(projection2.a)) {
                    Point point = TileConversor.b(d2, d3);
                    dArray[0] = point.b;
                    dArray[1] = point.c;
                } else if (GeoUtils.b(projection2.a)) {
                    Point point = TileConversor.b(d2, d3);
                    dArray = ConversionCoords.a(point.b, point.c, projection2);
                } else {
                    Point point = TileConversor.b(d2, d3);
                    dArray = ConversionCoords.a(point.b, point.c, projection2);
                }
            } else if (GeoUtils.a(projection2.a)) {
                dArray = ConversionCoords.b(d2, d3, projection);
            } else if (GeoUtils.b(projection2.a)) {
                dArray = ConversionCoords.b(d2, d3, projection);
                Point point = TileConversor.a(dArray[0], dArray[1]);
                dArray[0] = point.b;
                dArray[1] = point.c;
            } else {
                double[] dArray2 = ConversionCoords.b(d2, d3, projection);
                dArray = ConversionCoords.a(dArray2[0], dArray2[1], projection2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return dArray;
    }
}

